/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Document;

public abstract class FileOperations {
    public static final Charset charsetUTF8 = Charset.forName("UTF-8");
    public static final Charset charsetASCII = Charset.forName("US-ASCII");
    public static final Charset charsetISO8859_15 = Charset.forName("ISO-8859-15");
    public static final Charset charsetUTF16BE = Charset.forName("UTF-16BE");
    public static final String DATA_MODEL = System.getProperty("sun.arch.data.model");
    private static final String newLine;
    private static final boolean isBackslashOS;

    public static String convertBackslash(String path) {
        if (isBackslashOS) {
            return path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public static boolean copy(FSILogger logger, Path source, Path target) {
        boolean returnvalue;
        block2: {
            returnvalue = false;
            try {
                returnvalue = FileOperations.copy(source, target);
            }
            catch (IOException e) {
                if (logger == null) break block2;
                logger.logException(e, 1005, e.getLocalizedMessage());
            }
        }
        return returnvalue;
    }

    public static boolean copy(Path source, Path target) throws IOException {
        Path result;
        Path targetV = Files.isDirectory(target, new LinkOption[0]) && !Files.isDirectory(source, new LinkOption[0]) ? target.resolve(source.getFileName()) : target;
        Path targetParent = targetV.getParent();
        if (Files.notExists(targetParent, new LinkOption[0])) {
            Files.createDirectories(targetParent, new FileAttribute[0]);
        }
        return (result = Files.copy(source, targetV, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES)) != null;
    }

    public static boolean copyDirectory(FSILogger logger, final Path sourcePath, final Path targetPath) {
        block2: {
            boolean success = true;
            try {
                Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        FileOperations.copy(file, targetPath.resolve(sourcePath.relativize(file)));
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                if (logger == null) break block2;
                logger.log(1005, e.getLocalizedMessage());
            }
        }
        return true;
    }

    public static Pair<Long, Long> countDirFiles(Path directory) throws IOException {
        return FileOperations.countDirFilesRecursively(directory, FileVisitResult.SKIP_SUBTREE);
    }

    public static Pair<Long, Long> countDirFilesRecursively(Path directory) throws IOException {
        return FileOperations.countDirFilesRecursively(directory, FileVisitResult.CONTINUE);
    }

    public static long countFilesRecursively(Path directory) throws IOException {
        long result = 0L;
        class MyFileVisitor<T>
        extends SimpleFileVisitor<T> {
            long count = 0L;

            MyFileVisitor() {
            }

            @Override
            public FileVisitResult visitFile(T file, BasicFileAttributes attrs) throws IOException {
                ++this.count;
                return FileVisitResult.CONTINUE;
            }
        }
        MyFileVisitor cfv = new MyFileVisitor();
        Files.walkFileTree(directory, cfv);
        result = cfv.count;
        return result;
    }

    public static boolean deleteDir(Path path) throws IOException {
        if (Files.isWritable(path) && Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else if (Files.isWritable(path) && !Files.isDirectory(path, new LinkOption[0])) {
            Files.delete(path);
        }
        return true;
    }

    public static String getNewLine() {
        return newLine;
    }

    public static List<PathCached> getRecurseDirectoryFiles(Path directory, final DirectoryStream.Filter<Path> filter) throws IOException {
        final ArrayList<PathCached> result = new ArrayList<PathCached>();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (filter == null) {
                    result.add(new PathCached(file, attrs));
                } else if (filter.accept(file)) {
                    result.add(new PathCached(file, attrs));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }

    public static long getSafeLastModified(Path path) {
        long lm = 0L;
        try {
            lm = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            if (lm < 0L) {
                lm = 0L;
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return lm;
    }

    public static final String getTextFileContent(FSILogger logger, Path file, Charset charset) {
        String returnvalue;
        block2: {
            returnvalue = "";
            try {
                returnvalue = FileOperations.getTextFileContent(file, charset);
            }
            catch (IOException e) {
                if (logger == null) break block2;
                logger.log(1005, e.getLocalizedMessage());
            }
        }
        return returnvalue;
    }

    /*
     * Exception decompiling
     */
    public static final String getTextFileContent(Path file, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ArrayList<String> getTextFileContentAsArrayList(FSILogger logger, Path file, Charset charset) {
        ArrayList<String> result;
        block2: {
            result = null;
            try {
                result = FileOperations.getTextFileContentAsArrayList(file, charset);
            }
            catch (IOException e) {
                if (logger == null) break block2;
                logger.log(1005, e.getLocalizedMessage());
            }
        }
        return result;
    }

    public static ArrayList<String> getTextFileContentAsArrayList(Path file, Charset charset) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader br = Files.newBufferedReader(file, charset);){
            String line;
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
        }
        return result;
    }

    public static long getUnallocatedSpace(Path path) {
        long availSpace = 0L;
        for (FileStore store : path.getFileSystem().getFileStores()) {
            try {
                availSpace += store.getUnallocatedSpace();
            }
            catch (IOException iOException) {}
        }
        return availSpace;
    }

    public static long getUsableSpace(Path path) {
        long availSpace = 0L;
        for (FileStore store : path.getFileSystem().getFileStores()) {
            try {
                availSpace += store.getUsableSpace();
            }
            catch (IOException iOException) {}
        }
        return availSpace;
    }

    public static Document getXMLFileContent(FSILogger logger, InputStream stream) {
        return stream != null ? XMLOperations.getXMLContent(logger, stream, null) : null;
    }

    public static Document getXMLFileContent(FSILogger logger, Path file) {
        byte[] xmlraw = FileOperations.readFile(logger, file);
        return xmlraw != null ? XMLOperations.getXMLContent(logger, xmlraw, file) : null;
    }

    public static List<PathCached> listAllFiles(Path baseDir) throws IOException {
        return FileOperations.list(baseDir, null, true, true, 0, 0);
    }

    public static List<PathCached> listAllFiles(Path baseDir, DirectoryStream.Filter<Path> filter) throws IOException {
        return FileOperations.list(baseDir, filter, true, true, 0, 0);
    }

    public static List<PathCached> listAllFiles(Path baseDir, DirectoryStream.Filter<Path> filter, int from, int length) throws IOException {
        return FileOperations.list(baseDir, filter, true, true, from, length);
    }

    public static List<PathCached> listAllFiles(Path baseDir, String glob) throws IOException {
        return FileOperations.listAllFiles(baseDir, FileOperations.globToFilter(baseDir, glob));
    }

    public static List<PathCached> listAllFiles(Path baseDir, String glob, int from, int length) throws IOException {
        return FileOperations.listAllFiles(baseDir, FileOperations.globToFilter(baseDir, glob), from, length);
    }

    public static List<PathCached> listDirectories(Path baseDir) throws IOException {
        return FileOperations.list(baseDir, null, true, false, 0, 0);
    }

    public static List<PathCached> listDirectories(Path baseDir, DirectoryStream.Filter<Path> filter) throws IOException {
        return FileOperations.list(baseDir, filter, true, false, 0, 0);
    }

    public static List<PathCached> listDirectories(Path baseDir, String glob) throws IOException {
        return FileOperations.list(baseDir, FileOperations.globToFilter(baseDir, glob), true, false, 0, 0);
    }

    public static List<PathCached> listFiles(Path baseDir) throws IOException {
        return FileOperations.list(baseDir, null, false, true, 0, 0);
    }

    public static List<PathCached> listFiles(Path baseDir, DirectoryStream.Filter<Path> filter) throws IOException {
        return FileOperations.list(baseDir, filter, false, true, 0, 0);
    }

    public static List<PathCached> listFiles(Path baseDir, String glob) throws IOException {
        return FileOperations.listFiles(baseDir, FileOperations.globToFilter(baseDir, glob));
    }

    public static void move(Path source, Path target) throws IOException {
        Path targetIn = Files.isDirectory(target, new LinkOption[0]) && Files.isRegularFile(source, new LinkOption[0]) ? target.resolve(source.getFileName()) : target;
        try {
            Files.move(source, targetIn, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(source, targetIn, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile(FSILogger logger, Path path) {
        try (SeekableByteChannel channel = Files.newByteChannel(path, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
            long size = channel.size();
            if (size < Integer.MAX_VALUE) {
                byte[] data = new byte[(int)size];
                ByteBuffer bb = ByteBuffer.wrap(data);
                channel.read(bb);
                byte[] byArray = data;
                return byArray;
            }
            if (logger == null) return null;
            logger.log(1005, "File too big");
            return null;
        }
        catch (IOException e) {
            if (logger == null) return null;
            logger.log(1005, e.getLocalizedMessage());
        }
        return null;
    }

    public static byte[] readFile(Path path) throws IOException {
        Throwable throwable = null;
        try (SeekableByteChannel channel = Files.newByteChannel(path, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
            long size = channel.size();
            if (size < Integer.MAX_VALUE) {
                byte[] data = new byte[(int)size];
                ByteBuffer bb = ByteBuffer.wrap(data);
                channel.read(bb);
                byte[] byArray = data;
                return byArray;
            }
            try {
                throw new IOException("File too big");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static byte[] readFile(Path path, long from, long to) throws IOException {
        Throwable throwable = null;
        try (SeekableByteChannel channel = Files.newByteChannel(path, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
            long size = to - from;
            if (size < Integer.MAX_VALUE) {
                byte[] data = new byte[(int)size];
                ByteBuffer bb = ByteBuffer.wrap(data);
                channel.position(from);
                channel.read(bb);
                byte[] byArray = data;
                return byArray;
            }
            try {
                throw new IOException("File too big");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static final Object readObjectFromFile(Path path) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(path, new OpenOption[0]));){
            Object object;
            Object object2 = object = ois.readObject();
            return object2;
        }
    }

    public static void removeEmptyParents(FSILogger logger, Path dirparents, Path stopdir) {
        Path dir = dirparents;
        while (!dir.toAbsolutePath().equals(stopdir.toAbsolutePath())) {
            try {
                Files.delete(dir);
                logger.log(1058, dir);
                dir = dir.getParent();
            }
            catch (IOException e) {
                break;
            }
        }
    }

    public static final boolean saveStreamToFile(FSILogger logger, Path file, InputStream stream) {
        boolean result = false;
        try {
            FileOperations.saveStreamToFile(file, stream);
            result = true;
        }
        catch (IOException ioe) {
            logger.log(1008, file, ioe.getLocalizedMessage());
        }
        return result;
    }

    public static void saveStreamToFile(Path file, InputStream stream) throws IOException {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = stream.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        stream.close();
    }

    public static boolean saveXMLFileContent(FSILogger logger, Path file, Document document) {
        boolean result;
        block15: {
            result = false;
            byte[] xmlraw = XMLOperations.indentXMLDocument(logger, document, file);
            if (xmlraw != null) {
                try (OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);){
                    fos.write(xmlraw);
                    result = true;
                }
                catch (IOException e) {
                    if (logger == null) break block15;
                    logger.log(1014, file, e.getLocalizedMessage());
                }
            }
        }
        return result;
    }

    public static boolean saveXMLFileContent(FSILogger logger, String filename, Document document) {
        return FileOperations.saveXMLFileContent(logger, Paths.get(filename, new String[0]), document);
    }

    public static boolean setSafeLastModified(Path path, long time) {
        boolean result = true;
        long timeVal = time < 0L ? 0L : time;
        try {
            Files.setLastModifiedTime(path, FileTime.fromMillis(timeVal));
        }
        catch (IOException | SecurityException e) {
            result = false;
        }
        return result;
    }

    public static String[] splitFilename(Path path) {
        return FileOperations.splitFilename(path.getFileName().toString());
    }

    public static String[] splitFilename(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            String prefix = filename.substring(0, lastDot);
            String suffix = filename.substring(lastDot + 1);
            return new String[]{prefix, suffix};
        }
        return null;
    }

    public static String trim(String path, char trimChar) {
        char c;
        int start = -1;
        int end = -1;
        int len = path.length();
        int i = 0;
        while (i < len && (c = path.charAt(i)) == trimChar) {
            start = i++;
        }
        i = len - 1;
        while (i > 0 && (c = path.charAt(i)) == trimChar) {
            end = i--;
        }
        if (start == -1 && end == -1) {
            return path;
        }
        if (end == -1) {
            return path.substring(start + 1);
        }
        return path.substring(start + 1, end);
    }

    public static boolean writeFile(FSILogger logger, Path file, byte[] data) {
        boolean result;
        block2: {
            result = false;
            try {
                result = FileOperations.writeFile(file, data);
            }
            catch (IOException ioe) {
                if (logger == null) break block2;
                logger.log(1008, file, ioe.getLocalizedMessage());
            }
        }
        return result;
    }

    public static boolean writeFile(Path path, byte[] data) throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(path, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);){
            ByteBuffer bb = ByteBuffer.wrap(data);
            int bytesWritten = channel.write(bb);
            if (bytesWritten == data.length) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static boolean writeFile(Path path, ByteBuffer buffer) throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(path, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE), new FileAttribute[0]);){
            buffer.flip();
            int bytesWritten = channel.write(buffer);
            if (bytesWritten == buffer.capacity()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileAtomic(Path file, byte[] data) throws IOException {
        Path tmpPath = file.resolveSibling(file.getFileName() + ".tmp");
        try {
            if (FileOperations.writeFile(tmpPath, data)) {
                FileOperations.move(tmpPath, file);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Files.delete(tmpPath);
        }
        return false;
    }

    public static final void writeObjectToFile(Path path, Object object) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            oos.writeObject(object);
        }
    }

    public static final boolean writeTextFileContent(FSILogger logger, Path path, String content, Charset charset) {
        try {
            return FileOperations.writeTextFileContent(path, content, charset, false);
        }
        catch (IOException e) {
            logger.logException(e, 1022, path, e.getLocalizedMessage());
            return false;
        }
    }

    public static final boolean writeTextFileContent(Path path, String content, Charset charset) throws IOException {
        return FileOperations.writeTextFileContent(path, content, charset, false);
    }

    public static final boolean writeTextFileContent(Path path, String content, Charset charset, boolean append) throws IOException {
        boolean result;
        Path parent = path.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (content != null) {
            try (BufferedWriter fw = Files.newBufferedWriter(path, charset, new OpenOption[0]);){
                fw.write(content);
            }
            result = true;
        } else {
            Files.createFile(path, new FileAttribute[0]);
            result = true;
        }
        return result;
    }

    private static Pair<Long, Long> countDirFilesRecursively(final Path directory, final FileVisitResult dirBehavior) throws IOException {
        class MyFileVisitor<T>
        extends SimpleFileVisitor<T> {
            long files = 0L;
            long dirs = 0L;

            MyFileVisitor() {
            }

            @Override
            public FileVisitResult preVisitDirectory(T dir, BasicFileAttributes attrs) throws IOException {
                if (directory.equals(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                ++this.dirs;
                return dirBehavior;
            }

            @Override
            public FileVisitResult visitFile(T file, BasicFileAttributes attrs) throws IOException {
                ++this.files;
                return FileVisitResult.CONTINUE;
            }
        }
        MyFileVisitor cfv = new MyFileVisitor();
        Files.walkFileTree(directory, cfv);
        return new Pair<Long, Long>(cfv.dirs, cfv.files);
    }

    private static DirectoryStream.Filter<Path> globToFilter(Path path, String glob) {
        DirectoryStream.Filter<Path> filter;
        if (glob != null && !glob.equals("*")) {
            final PathMatcher matcher = path.getFileSystem().getPathMatcher("glob:" + glob);
            filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) {
                    return matcher.matches(entry.getFileName());
                }
            };
        } else {
            filter = null;
        }
        return filter;
    }

    private static List<PathCached> list(final Path baseDir, final DirectoryStream.Filter<Path> filter, final boolean addDirs, final boolean addFiles, final int from, final int length) throws IOException {
        if (!Files.isDirectory(baseDir, new LinkOption[0])) {
            return null;
        }
        final ArrayList<PathCached> result = new ArrayList<PathCached>();
        final AtomicInteger posAtom = new AtomicInteger();
        final int to = from + length;
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (baseDir.equals(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                int pos = posAtom.get();
                if (addDirs) {
                    if (!(pos < from || to > 0 && pos >= to || filter != null && !filter.accept(dir))) {
                        result.add(new PathCached(dir, attrs));
                    }
                    posAtom.incrementAndGet();
                }
                if (length <= 0 || to > 0 && pos < to) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                int pos = posAtom.get();
                if (addFiles) {
                    if (!(pos < from || to > 0 && pos >= to || filter != null && !filter.accept(file))) {
                        result.add(new PathCached(file, attrs));
                    }
                    posAtom.incrementAndGet();
                }
                if (length <= 0 || to > 0 && pos < to) {
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.TERMINATE;
            }
        });
        return result;
    }

    static {
        isBackslashOS = File.separatorChar == '\\';
        newLine = System.getProperty("line.separator");
    }
}

