/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class IOController {
    private boolean parallelRead = true;
    private boolean parallelWrite = false;
    private boolean parallelReadWrite = false;
    private final ReentrantReadWriteLock masterLock = new ReentrantReadWriteLock(false);
    private final ReentrantLock secondWriteLock = new ReentrantLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.masterLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.masterLock.writeLock();
    private volatile boolean running = true;
    private static final boolean lockDebug = false;

    public void setParallelReadWriteLocks(boolean parallelRead, boolean parallelWrite, boolean parallelReadWrite) {
        this.parallelRead = parallelRead;
        this.parallelWrite = parallelWrite;
        this.parallelReadWrite = parallelReadWrite;
    }

    public void waitForRead() {
        if (this.running) {
            try {
                if (this.parallelRead || this.parallelReadWrite) {
                    this.readLock.lockInterruptibly();
                } else {
                    this.writeLock.lockInterruptibly();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void unlockRead() {
        if (this.running) {
            if (this.parallelRead || this.parallelReadWrite) {
                this.readLock.unlock();
            } else {
                this.writeLock.unlock();
            }
        }
    }

    public void waitForWrite() {
        if (this.running) {
            try {
                if (!this.parallelWrite) {
                    if (this.parallelReadWrite) {
                        this.secondWriteLock.lockInterruptibly();
                    } else {
                        this.writeLock.lockInterruptibly();
                    }
                } else if (!this.parallelReadWrite) {
                    this.writeLock.lockInterruptibly();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void unlockWrite() {
        if (this.running) {
            if (this.parallelReadWrite && this.secondWriteLock.isLocked() && this.secondWriteLock.isHeldByCurrentThread()) {
                this.secondWriteLock.unlock();
            } else if (!this.parallelReadWrite) {
                if (this.masterLock.isWriteLockedByCurrentThread()) {
                    this.writeLock.unlock();
                } else if (this.parallelRead && !this.writeLock.isHeldByCurrentThread()) {
                    this.readLock.unlock();
                }
            }
        }
    }

    public void halt() {
        this.running = false;
    }
}

