/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.List;

public final class MemoryManager {
    private static final MemoryManager instance = new MemoryManager();
    private static Boolean vmUsesG1GC = null;
    private final int MINIMUM_FREE_MEM_PERCENTAGE = 20;
    private final MemoryPoolMXBean oldGenerationMemoryPool = this.findOldGenPool();
    private long currentThreshold = 0L;
    private long lastPotentialMaxTenured = 0L;

    private MemoryManager() {
    }

    public static final MemoryManager getInstance() {
        return instance;
    }

    public void adaptThreshold() {
        if (this.usesG1GC()) {
            long potientialMaxTenured = MemoryManager.getTotalHeapSpace() + this.getCommitedYoungGen();
            if (potientialMaxTenured != this.lastPotentialMaxTenured) {
                this.lastPotentialMaxTenured = potientialMaxTenured;
                this.currentThreshold = potientialMaxTenured - (long)((float)(potientialMaxTenured * 20L) / 100.0f);
                this.oldGenerationMemoryPool.setUsageThreshold(MemoryManager.getTotalHeapSpace());
                this.oldGenerationMemoryPool.setUsageThreshold(this.currentThreshold);
            }
        } else {
            long maxMemory = this.oldGenerationMemoryPool.getUsage().getMax();
            this.currentThreshold = maxMemory - (long)((float)(maxMemory * 20L) / 100.0f);
            this.oldGenerationMemoryPool.setUsageThreshold(this.currentThreshold);
        }
    }

    public boolean usesG1GC() {
        if (vmUsesG1GC == null) {
            List<GarbageCollectorMXBean> gcpools = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean pool : gcpools) {
                if (!pool.getName().contains("G1")) continue;
                vmUsesG1GC = true;
            }
            if (vmUsesG1GC == null) {
                vmUsesG1GC = false;
            }
        }
        return vmUsesG1GC;
    }

    public long getCommitedYoungGen() {
        long result = 0L;
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.getName().contains("Eden") && !pool.getName().contains("Survivor")) continue;
            result += pool.getUsage().getCommitted();
        }
        return result;
    }

    public long getMaxYoungGen() {
        long result = 0L;
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.getName().contains("Eden") && !pool.getName().contains("Survivor")) continue;
            result += pool.getUsage().getMax();
        }
        return result;
    }

    public long getCommitedOldGen() {
        long result = 0L;
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || pool.getName().contains("Eden") || pool.getName().contains("Survivor")) continue;
            result += pool.getUsage().getCommitted();
        }
        return result;
    }

    public long getMaxOldGen() {
        long result = 0L;
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || pool.getName().contains("Eden") || pool.getName().contains("Survivor")) continue;
            result += pool.getUsage().getMax();
        }
        return result;
    }

    public long getCurrentThreshold() {
        return this.currentThreshold;
    }

    public long getUsedOldGen() {
        return this.oldGenerationMemoryPool.getUsage().getUsed();
    }

    public static long getUsedHeapSpace() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    public static long getTotalHeapSpace() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
    }

    public static long getFreeHeapSpace() {
        return MemoryManager.getTotalHeapSpace() - MemoryManager.getUsedHeapSpace();
    }

    public MemoryPoolMXBean findOldGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    public void dumpMemory() {
        List<GarbageCollectorMXBean> gcpools = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean pool : gcpools) {
            String[] pools;
            System.out.println("MemoryPool Name: %" + pool.getName());
            for (String poolname : pools = pool.getMemoryPoolNames()) {
                System.out.println("Pool Name: %" + poolname);
            }
        }
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        System.out.println("Current thread count: " + tb.getThreadCount());
        System.out.println("Peak thread count: " + tb.getPeakThreadCount());
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean pool : pools) {
            MemoryUsage peak = pool.getPeakUsage();
            System.out.println("Peak %s memory used: " + pool.getName() + ", " + peak.getUsed());
            System.out.println("Peak %s memory reserved: " + pool.getName() + " " + peak.getCommitted());
        }
    }
}

