/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.io.FileOperations;
import java.io.IOException;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MimeHelper {
    public static final String DEFAULT_TYPE = "application/unknown";
    private static final Pattern XML_PATTERN = Pattern.compile("<\\?xml", 8);
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\s*\\{\\s*\"", 8);
    private static final Pattern HTML_PATTERN = Pattern.compile("<html", 10);

    public static String getMimeTypeByDeepScan(Path file) {
        String result = DEFAULT_TYPE;
        try {
            byte[] bytes = FileOperations.readFile(file, 0L, 128L);
            result = MimeHelper.getMimeType(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String getMimeTypeFromFileExtension(String filename) {
        if (filename.endsWith(".css")) {
            return "text/css";
        }
        if (filename.endsWith(".js")) {
            return "application/javascript";
        }
        if (filename.endsWith(".fsi") || filename.endsWith(".xml")) {
            return "application/xml";
        }
        if (filename.endsWith(".tiff") || filename.endsWith(".tif")) {
            return "image/tiff";
        }
        if (filename.endsWith(".jpeg") || filename.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (filename.endsWith(".gif")) {
            return "image/gif";
        }
        if (filename.endsWith(".png")) {
            return "image/png";
        }
        if (filename.endsWith(".bmp")) {
            return "image/bmp";
        }
        if (filename.endsWith(".fpx")) {
            return "image/vnd.fpx";
        }
        if (filename.endsWith(".zip")) {
            return "application/zip";
        }
        return DEFAULT_TYPE;
    }

    public static String getFileExtensionFromMimeType(String mimeType) {
        if ("image/jpeg".equalsIgnoreCase(mimeType)) {
            return ".jpg";
        }
        if ("image/png".equalsIgnoreCase(mimeType)) {
            return ".png";
        }
        if ("application/xml".equalsIgnoreCase(mimeType) || "text/xml".equalsIgnoreCase(mimeType)) {
            return ".xml";
        }
        if ("application/json".equalsIgnoreCase(mimeType) || "text/json".equalsIgnoreCase(mimeType)) {
            return ".json";
        }
        return "";
    }

    public static boolean hasSuffix(String filename) {
        boolean result = false;
        int lDot = filename.lastIndexOf(46);
        if (lDot > 0 && lDot >= filename.length() - 4) {
            result = true;
        }
        return result;
    }

    public static String simplifyMime(String mimetype) {
        String mimeTypeResult = mimetype.equals("application/x-zip") || mimetype.equals("application/x-zip-compressed") || mimetype.equals("application/x-compress") || mimetype.equals("application/x-compressed") || mimetype.equals("multipart/x-zip") ? "application/zip" : (mimetype.equals("image/fpx") || mimetype.equals("application/vnd.fpx") || mimetype.equals("application/vnd.netfpx") || mimetype.equals("image/x-fpx") ? "image/vnd.fpx" : (mimetype.equals("image/vnd.swiftview-jpeg") || mimetype.equals("image/pjpe") || mimetype.equals("image/jpe_") ? "image/jpeg" : (mimetype.equals("image/x-bmp") || mimetype.equals("image/x-win-bitmap") || mimetype.equals("image/x-windows-bmp") || mimetype.equals("image/ms-bmp") || mimetype.equals("image/x-ms-bmp") || mimetype.equals("application/bmp") || mimetype.equals("application/x-bmp") || mimetype.equals("application/x-win-bitmap ") ? "image/bmp" : (mimetype.equals("application/png") || mimetype.equals("application/x-png") ? "image/png" : (mimetype.equals("image/gi_") ? "image/gif" : (mimetype.equals("text/xml") || mimetype.equals("application/x-xml") ? "application/xml" : mimetype))))));
        return mimeTypeResult;
    }

    public static String getMimeType(byte[] content) {
        String result = DEFAULT_TYPE;
        if (content.length > 4) {
            if ((content[0] & 0xFF) == 255 && (content[1] & 0xFF) == 216) {
                result = "image/jpeg";
            } else if ((content[1] & 0xFF) == 80 && (content[2] & 0xFF) == 78 && (content[3] & 0xFF) == 71) {
                result = "image/png";
            } else if ((content[0] & 0xFF) == 73 && (content[1] & 0xFF) == 73 && (content[2] & 0xFF) == 42 && (content[3] & 0xFF) == 0) {
                result = "image/tiff";
            } else if ((content[0] & 0xFF) == 77 && (content[1] & 0xFF) == 77 && (content[2] & 0xFF) == 0 && (content[3] & 0xFF) == 42) {
                result = "image/tiff";
            } else if ((content[0] & 0xFF) == 71 && (content[1] & 0xFF) == 73 && (content[2] & 0xFF) == 70) {
                result = "image/gif";
            } else if (((content[0] & 0xFF) == 70 || (content[0] & 0xFF) == 67) && (content[1] & 0xFF) == 87 && (content[2] & 0xFF) == 83) {
                result = "application/x-shockwave-flash";
            } else if ((content[0] & 0xFF) == 37 && (content[1] & 0xFF) == 80 && (content[2] & 0xFF) == 68 && (content[3] & 0xFF) == 70) {
                result = "application/pdf";
            } else if ((content[0] & 0xFF) == 37 && (content[1] & 0xFF) == 33 && (content[2] & 0xFF) == 80 && (content[3] & 0xFF) == 83) {
                result = "application/postscript";
            } else if ((content[0] & 0xFF) == 80 && (content[1] & 0xFF) == 75 && (content[2] & 0xFF) == 3 && (content[3] & 0xFF) == 4) {
                result = "application/zip";
            } else {
                String searchable = new String(content);
                Matcher mat_xml = XML_PATTERN.matcher(searchable);
                if (mat_xml.find()) {
                    result = "application/xml";
                } else {
                    Matcher mat_json = JSON_PATTERN.matcher(searchable);
                    if (mat_json.find()) {
                        result = "application/json";
                    } else {
                        Matcher mat_html = HTML_PATTERN.matcher(searchable);
                        if (mat_html.find()) {
                            result = "text/html";
                        }
                    }
                }
            }
        }
        return result;
    }
}

