/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.concurrent.Pausable;
import com.neptunelabs.fsiframework.io.FileOperations;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class PartitionMonitor
extends Thread {
    final Path file;
    final Pausable pausable;
    long minFreeSpace = 0x100000L;
    private volatile boolean running;

    public PartitionMonitor(Path file, Pausable pausable) {
        this.file = file;
        this.pausable = pausable;
        this.setDaemon(true);
        this.setName("PartitionMonitor watching " + file);
    }

    public PartitionMonitor(Path file, Pausable pausable, long minFreeSpace) {
        this.file = file;
        this.pausable = pausable;
        this.setDaemon(true);
        this.setName("PartitionMonitor watching " + file);
        if (minFreeSpace <= 0L) {
            throw new IllegalArgumentException("Invalid value " + minFreeSpace + " for minFreeSpace.");
        }
        this.minFreeSpace = minFreeSpace;
    }

    @Override
    public void run() {
        this.running = true;
        try {
            Path testdir = this.file;
            boolean partitionOk = false;
            while (!partitionOk && this.running) {
                PartitionMonitor.sleep(10000L);
                while (Files.notExists(testdir, new LinkOption[0]) || !Files.isDirectory(testdir, new LinkOption[0])) {
                    testdir = testdir.getParent();
                }
                boolean space = FileOperations.getUsableSpace(testdir) > this.minFreeSpace;
                boolean write = Files.isWritable(testdir);
                partitionOk = space & write;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.pausable.endPause();
    }

    public void halt() {
        this.running = false;
        this.interrupt();
    }
}

