/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.io.FileOperations;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;

public final class PathCached
implements Comparable<PathCached> {
    private final Path path;
    private File file;
    private BasicFileAttributes attrs;
    private String name;
    private boolean hasFile = false;
    private boolean hasSplitted = false;
    private String prefix;
    private String suffix;
    private boolean hasLength = false;
    private long length;
    private boolean hasAbsolutePath = false;
    private Path absolutePath;
    private boolean hasAbsoluteName = false;
    private String absoluteName;
    private final boolean hasAbsoluteNameLength = false;
    private int absoluteNameLength;
    private boolean hasLastModified = false;
    private long lastModified;
    private boolean hasIsHidden = false;
    private boolean isHidden;
    private boolean hasIsFile = false;
    private boolean isFile;
    private boolean hasIsDirectory = false;
    private boolean isDirectory = false;
    private boolean hasCanRead = false;
    private boolean canRead;
    private boolean hasCanWrite = false;
    private boolean canWrite;
    private boolean hasParentFile = false;
    private Path parentFile;
    private boolean hasExists = false;
    private boolean exists;
    private boolean hasNotExists = false;
    private boolean notExists;

    public PathCached(Path file) {
        this.path = file;
    }

    public PathCached(Path path, BasicFileAttributes attrs) {
        this.path = path;
        this.attrs = attrs;
    }

    public PathCached(String filepath) {
        this(Paths.get(filepath, new String[0]));
    }

    public static PathCached get(Path path, BasicFileAttributes attrs) {
        return new PathCached(path, attrs);
    }

    @Override
    public int compareTo(PathCached o) {
        return this.path.compareTo(o.path);
    }

    public Path getPath() {
        return this.path;
    }

    public Path getAbsolutePath() {
        if (!this.hasAbsolutePath) {
            this.absolutePath = this.path.toAbsolutePath();
            this.hasAbsolutePath = true;
        }
        return this.absolutePath;
    }

    public String getAbsoluteName() {
        if (!this.hasAbsoluteName) {
            this.absoluteName = this.getAbsolutePath().toString();
            this.hasAbsoluteName = true;
        }
        return this.absoluteName;
    }

    public int getAbsoluteNameLength() {
        this.absoluteNameLength = this.getAbsoluteName().length();
        return this.absoluteNameLength;
    }

    public String getPrefix() {
        if (!this.hasSplitted) {
            String[] sf;
            this.hasSplitted = true;
            String fName = this.getFileName();
            if (fName != null && (sf = FileOperations.splitFilename(fName)) != null) {
                this.prefix = sf[0];
                this.suffix = sf[1];
            }
        }
        return this.prefix;
    }

    public String getSuffix() {
        this.getPrefix();
        return this.suffix;
    }

    public File toFile() {
        if (!this.hasFile) {
            this.file = this.path.toFile();
            this.hasFile = true;
        }
        return this.file;
    }

    public boolean isRegularFile() throws IOException {
        if (!this.hasIsFile) {
            if (this.attrs == null) {
                this.readAttributes();
            }
            this.isFile = this.attrs.isRegularFile();
            this.hasIsFile = true;
        }
        return this.isFile;
    }

    public boolean isDirectory() {
        if (!this.hasIsDirectory) {
            if (this.attrs == null) {
                try {
                    this.readAttributes();
                }
                catch (IOException e) {
                    return false;
                }
            }
            this.isDirectory = this.attrs.isDirectory();
            this.hasIsDirectory = true;
        }
        return this.isDirectory;
    }

    public boolean isHidden() {
        if (!this.hasIsHidden) {
            if (this.getFileName().startsWith(".")) {
                this.isHidden = true;
            } else {
                try {
                    this.isHidden = Files.isHidden(this.path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.hasIsHidden = true;
        }
        return this.isHidden;
    }

    public boolean isReadable() {
        if (!this.hasCanRead) {
            this.canRead = Files.isReadable(this.path);
            this.hasCanRead = true;
        }
        return this.canRead;
    }

    public boolean isWritable() {
        if (!this.hasCanWrite) {
            this.canWrite = Files.isWritable(this.path);
            this.hasCanWrite = true;
        }
        return this.canWrite;
    }

    public String getFileName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.path != null) {
            this.name = this.path.getFileName().toString();
            return this.name;
        }
        return null;
    }

    public long lastModified() throws IOException {
        if (!this.hasLastModified) {
            if (this.attrs == null) {
                this.readAttributes();
            }
            this.lastModified = this.attrs.lastModifiedTime().toMillis();
            this.hasLastModified = true;
        }
        return this.lastModified;
    }

    public long lastModified(boolean refresh) throws IOException {
        if (refresh) {
            if (this.attrs == null) {
                this.readAttributes();
            }
            this.lastModified = this.attrs.lastModifiedTime().toMillis();
            this.hasLastModified = true;
            return this.lastModified;
        }
        return this.lastModified();
    }

    public long size() throws IOException {
        if (!this.hasLength) {
            if (this.attrs == null) {
                this.readAttributes();
            }
            this.length = this.attrs.size();
            this.hasLength = true;
        }
        return this.length;
    }

    public Path getParent() {
        if (!this.hasParentFile) {
            this.parentFile = this.path.getParent();
            this.hasParentFile = true;
        }
        return this.parentFile;
    }

    public Path resolve(String other) {
        return this.path.resolve(other);
    }

    public Path resolve(Path other) {
        return this.path.resolve(other);
    }

    public boolean exists() {
        if (!this.hasExists) {
            this.exists = Files.exists(this.path, new LinkOption[0]);
            this.hasExists = true;
        }
        return this.exists;
    }

    public boolean notExists() {
        if (!this.hasNotExists) {
            this.notExists = Files.notExists(this.path, new LinkOption[0]);
            this.hasNotExists = true;
        }
        return this.notExists;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PathCached) {
            return this.path.equals(((PathCached)obj).path);
        }
        return false;
    }

    public String toString() {
        return this.path.toString();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private void readAttributes() throws IOException {
        this.attrs = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
    }
}

