/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.Plugin;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiframework.systeminformation.OperatingPlatform;
import com.neptunelabs.fsiframework.systeminformation.SystemInformation;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PluginLoader {
    private final FSILogger logger;
    private final URLClassLoader clazzLoader;
    private final SystemInformation sysInfo;
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();
    private static final Class<?>[] urlClassLoaderParameters = new Class[]{URL.class};

    public PluginLoader(FSILogger logger, ClassLoader defaultClassLoader, SystemInformation sysInfo) {
        this.logger = logger;
        this.clazzLoader = this.getClassLoader(defaultClassLoader);
        this.sysInfo = sysInfo;
    }

    public void loadPlugin(Path pluginBase, String pluginName, String serverContext) {
        Path directory = pluginBase.resolve(pluginName);
        Path pluginConfigFile = directory.resolve("config.xml");
        Document configXML = FileOperations.getXMLFileContent(this.logger, pluginConfigFile);
        if (configXML == null) {
            try (InputStream is22 = this.clazzLoader.getResourceAsStream(pluginName + "/" + "config.xml");){
                configXML = FileOperations.getXMLFileContent(this.logger, is22);
            }
            catch (IOException is22) {
                // empty catch block
            }
        }
        if (configXML != null) {
            NodeList root = configXML.getElementsByTagName("plugin");
            Node rootNode = root.item(0);
            if (rootNode != null) {
                NamedNodeMap attrs = rootNode.getAttributes();
                Node enabledNode = attrs.getNamedItem("enabled");
                boolean enabled = false;
                if (enabledNode != null) {
                    enabled = Boolean.valueOf(enabledNode.getNodeValue());
                }
                if (enabled) {
                    Plugin plugin = new Plugin();
                    NodeList nodes = rootNode.getChildNodes();
                    if (nodes != null) {
                        for (int i = 0; i < nodes.getLength(); ++i) {
                            String text;
                            Node cNode;
                            NodeList classesNodeList;
                            String dirString;
                            NamedNodeMap nodeAttrs;
                            Node dirNode;
                            Node node = nodes.item(i);
                            if (node.getNodeType() != 1) continue;
                            String string = node.getNodeName().toLowerCase();
                            if (string.equalsIgnoreCase("jars") && (dirNode = (nodeAttrs = node.getAttributes()).getNamedItem("dir")) != null) {
                                dirString = dirNode.getNodeValue();
                                plugin.jars = this.findIncludes(node, directory, dirString, false);
                            }
                            if (string.equalsIgnoreCase("libraries")) {
                                nodeAttrs = node.getAttributes();
                                dirNode = nodeAttrs.getNamedItem("dir");
                                if (dirNode == null) continue;
                                dirString = dirNode.getNodeValue();
                                Node osDetectNode = nodeAttrs.getNamedItem("osdetect");
                                boolean osDetect = osDetectNode != null ? Boolean.valueOf(osDetectNode.getNodeValue()) : false;
                                plugin.libraries = this.findIncludes(node, directory, dirString, osDetect);
                                continue;
                            }
                            if (string.equalsIgnoreCase("init")) {
                                classesNodeList = node.getChildNodes();
                                if (classesNodeList == null) continue;
                                for (int j = 0; j < classesNodeList.getLength(); ++j) {
                                    cNode = classesNodeList.item(j);
                                    if (cNode.getNodeType() != 1 || !cNode.getNodeName().equalsIgnoreCase("class") || (text = PluginLoader.getNodeTextContent(cNode.getChildNodes())) == null) continue;
                                    plugin.initClasses.add(text);
                                }
                                continue;
                            }
                            if (string.equalsIgnoreCase("modules")) {
                                classesNodeList = node.getChildNodes();
                                if (classesNodeList == null) continue;
                                for (int j = 0; j < classesNodeList.getLength(); ++j) {
                                    cNode = classesNodeList.item(j);
                                    if (cNode.getNodeType() != 1 || !cNode.getNodeName().equalsIgnoreCase("context") || (text = PluginLoader.getNodeTextContent(cNode.getChildNodes())) == null || !serverContext.equalsIgnoreCase(text)) continue;
                                    plugin.enabled = true;
                                }
                                continue;
                            }
                            String value = PluginLoader.getNodeTextContent(node.getChildNodes());
                            if (value == null || value.equals("")) continue;
                            plugin.configuration.put(string, value);
                        }
                    }
                    if (plugin.libraries != null) {
                        try {
                            this.loadPluginLibraries(pluginName, plugin.libraries);
                        }
                        catch (IOException i) {
                            // empty catch block
                        }
                    }
                    boolean loadPass = false;
                    if (plugin.initClasses.size() > 0) {
                        loadPass = true;
                        for (String string : plugin.initClasses) {
                            try {
                                Class<?> clazz = this.clazzLoader.loadClass(string);
                                plugin.clazzes.put(string, clazz);
                            }
                            catch (ClassNotFoundException e) {
                                loadPass &= false;
                            }
                        }
                    }
                    if (!loadPass && plugin.enabled) {
                        if (plugin.jars != null) {
                            try {
                                this.loadPluginLibs(pluginName, plugin.jars, this.clazzLoader);
                            }
                            catch (IOException e) {
                                this.logger.log(1045, pluginName, e.getLocalizedMessage());
                            }
                            if (this.clazzLoader != null) {
                                this.logger.log(1046, pluginName);
                                boolean load = false;
                                if (plugin.initClasses.size() > 0) {
                                    try {
                                        for (String initClass : plugin.initClasses) {
                                            Class<?> clazz = this.clazzLoader.loadClass(initClass);
                                            clazz.newInstance();
                                            plugin.clazzes.put(initClass, clazz);
                                            this.logger.log(1047, pluginName, initClass);
                                            load = true;
                                        }
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        this.logger.log(1044, pluginName, "CNFE: " + classNotFoundException.getLocalizedMessage());
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        this.logger.log(1044, pluginName, "IA: " + illegalAccessException.getLocalizedMessage());
                                    }
                                    catch (InstantiationException instantiationException) {
                                        this.logger.log(1044, pluginName, "IE: " + instantiationException.getLocalizedMessage());
                                    }
                                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                        this.logger.log(1044, pluginName, "ULE: " + unsatisfiedLinkError.getLocalizedMessage());
                                    }
                                } else {
                                    load = true;
                                }
                                if (load) {
                                    this.plugins.put(pluginName.toLowerCase(), plugin);
                                }
                            }
                        } else {
                            this.logger.log(1042, pluginName);
                        }
                    } else if (loadPass) {
                        this.plugins.put(pluginName.toLowerCase(), plugin);
                        this.logger.log(1048, pluginName);
                    }
                } else {
                    this.logger.log(1041, pluginName);
                }
            } else {
                this.logger.log(1043, pluginName, pluginConfigFile);
            }
        } else {
            this.logger.log(1040, directory);
        }
    }

    public boolean isPluginLoaded(String name) {
        return this.plugins.containsKey(name.toLowerCase());
    }

    public Plugin getPlugin(String name) {
        return this.plugins.get(name.toLowerCase());
    }

    public static List<String> scanForPlugins(Path pluginBaseDir) {
        ArrayList<String> result = new ArrayList<String>();
        if (Files.isDirectory(pluginBaseDir, new LinkOption[0])) {
            try (DirectoryStream<Path> files = Files.newDirectoryStream(pluginBaseDir);){
                for (Path pluginDir : files) {
                    if (!Files.isDirectory(pluginDir, new LinkOption[0])) continue;
                    Path pluginName = pluginDir.getFileName();
                    Path configFile = Paths.get(pluginDir.toString(), "config.xml");
                    if (!Files.isReadable(configFile)) continue;
                    result.add(pluginName.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private Path[] findIncludes(Node rootNode, Path dirBase, String dir, boolean osDetect) {
        Path[] files;
        final ArrayList<String> includeList = new ArrayList<String>();
        NodeList nodes = rootNode.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                String value;
                NamedNodeMap nodeAttrs;
                Node nameNode;
                String key;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !(key = node.getNodeName().toLowerCase()).equals("include") || (nameNode = (nodeAttrs = node.getAttributes()).getNamedItem("name")) == null || (value = nameNode.getNodeValue()) == null || value.length() <= 0) continue;
                includeList.add(value);
            }
        }
        if (includeList.size() > 0) {
            Path directory;
            if (osDetect) {
                OperatingPlatform op = this.sysInfo.getOperatingPlatform();
                String nativePath = op == OperatingPlatform.Linux ? "linux" : (op == OperatingPlatform.Windows ? "win" : (op == OperatingPlatform.MacOSX ? "mac" : null));
                if (nativePath != null) {
                    nativePath = this.sysInfo.is64() ? nativePath + "64" : nativePath + "32";
                }
                directory = dirBase.resolve(dir).resolve(nativePath);
            } else {
                directory = dirBase.resolve(dir);
            }
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    for (String wildCard : includeList) {
                        if (!FilenameUtils.wildcardMatch((String)entry.getFileName().toString(), (String)wildCard, (IOCase)IOCase.INSENSITIVE)) continue;
                        return true;
                    }
                    return false;
                }
            };
            ArrayList<Path> posList = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, (DirectoryStream.Filter<? super Path>)filter);){
                for (Path entry : stream) {
                    posList.add(entry);
                }
                files = posList.toArray(new Path[0]);
            }
            catch (IOException e) {
                files = null;
            }
        } else {
            files = null;
        }
        return files;
    }

    private void loadPluginLibraries(String pluginName, Path[] libs) throws IOException {
        if (libs != null && libs.length > 0) {
            try {
                for (Path jar : libs) {
                    this.logger.log(1054, jar.toAbsolutePath().getFileName().toString(), pluginName);
                    System.load(jar.toAbsolutePath().toString());
                }
            }
            catch (Throwable t) {
                throw new IOException("Error, could not load library");
            }
        }
    }

    private void loadPluginLibs(String pluginName, Path[] jars, URLClassLoader clazzLoaderz) throws IOException {
        if (jars != null && jars.length > 0) {
            try {
                Class<URLClassLoader> sysclass = URLClassLoader.class;
                Method method = sysclass.getDeclaredMethod("addURL", urlClassLoaderParameters);
                method.setAccessible(true);
                for (Path jar : jars) {
                    this.logger.log(1054, jar.toAbsolutePath().toString(), pluginName);
                    URL url = jar.toUri().toURL();
                    method.invoke((Object)clazzLoaderz, url);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IOException("Error, could not add URL to system classloader");
            }
        }
    }

    private static String getNodeTextContent(NodeList nl) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 3) continue;
            sb.append(n.getNodeValue());
        }
        return sb.toString().trim();
    }

    private URLClassLoader getClassLoader(ClassLoader defaultClassLoader) {
        if (defaultClassLoader != null && defaultClassLoader instanceof URLClassLoader) {
            return (URLClassLoader)defaultClassLoader;
        }
        return (URLClassLoader)this.getClass().getClassLoader();
    }
}

