/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ReaderAbstract
implements Closeable {
    protected final Path path;
    protected SeekableByteChannel channel;
    protected ByteOrder byteOrder;
    protected long length = -1L;

    public ReaderAbstract(Path path, Set<StandardOpenOption> options) throws IOException {
        this.path = path;
        this.checkAccess(options);
        this.init(options);
    }

    public ReaderAbstract(Path path, StandardOpenOption ... options) throws IOException {
        this.path = path;
        HashSet<StandardOpenOption> set = new HashSet<StandardOpenOption>(options.length);
        Collections.addAll(set, options);
        this.checkAccess(set);
        this.init(set);
    }

    private void checkAccess(Set<StandardOpenOption> options) throws IOException {
        if (options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.CREATE_NEW) || options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND) || options.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
            throw new IOException("Only read modes allowed");
        }
    }

    private void init(Set<StandardOpenOption> options) throws IOException {
        this.channel = Files.newByteChannel(this.path, options, new FileAttribute[0]);
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public long length() throws IOException {
        if (this.length == -1L) {
            this.length = this.channel.size();
        }
        return this.length;
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public abstract void close() throws IOException;

    public abstract int read(byte[] var1) throws IOException;

    public abstract int read(ByteBuffer var1) throws IOException;

    public abstract int read() throws IOException;

    public abstract byte readByte() throws IOException;

    public abstract int readUByte() throws IOException;

    public abstract short readShort() throws IOException;

    public abstract int readUShort() throws IOException;

    public abstract int readInt() throws IOException;

    public abstract long readUInt() throws IOException;

    public abstract long readLong() throws IOException;

    public abstract float readFloat() throws IOException;

    public abstract double readDouble() throws IOException;

    public abstract void seek(long var1) throws IOException, IllegalArgumentException;

    public abstract long position() throws IOException;

    public abstract void skip(long var1) throws IOException;

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }
}

