/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.io.ReaderAbstract;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;

public class ReaderChannel
extends ReaderAbstract {
    public ReaderChannel(Path path, Set<StandardOpenOption> options) throws IOException {
        super(path, options);
    }

    public ReaderChannel(Path path, StandardOpenOption ... options) throws IOException {
        super(path, options);
    }

    @Override
    public String toString() {
        return this.path.toString();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.channel.read(ByteBuffer.wrap(bytes));
    }

    @Override
    public int read(ByteBuffer bb) throws IOException {
        return this.channel.read(bb);
    }

    @Override
    public int read() throws IOException {
        ByteBuffer buf = ByteBuffer.allocateDirect(1);
        this.channel.read(buf);
        buf.flip();
        return buf.get() & 0xFF;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    @Override
    public int readUByte() throws IOException {
        return this.read();
    }

    @Override
    public short readShort() throws IOException {
        ByteBuffer buf = ByteBuffer.allocateDirect(2);
        buf.order(this.byteOrder);
        this.channel.read(buf);
        buf.flip();
        return buf.getShort();
    }

    @Override
    public int readUShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readInt() throws IOException {
        ByteBuffer buf = ByteBuffer.allocateDirect(4);
        buf.order(this.byteOrder);
        this.channel.read(buf);
        buf.flip();
        return buf.getInt();
    }

    @Override
    public long readUInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() throws IOException {
        ByteBuffer buf = ByteBuffer.allocateDirect(8);
        buf.order(this.byteOrder);
        this.channel.read(buf);
        buf.flip();
        return buf.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        ByteBuffer buf = ByteBuffer.allocateDirect(4);
        buf.order(this.byteOrder);
        this.channel.read(buf);
        buf.flip();
        return buf.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        ByteBuffer buf = ByteBuffer.allocateDirect(8);
        buf.order(this.byteOrder);
        this.channel.read(buf);
        buf.flip();
        return buf.getDouble();
    }

    @Override
    public void seek(long pos) throws IOException, IllegalArgumentException {
        this.channel.position(pos);
    }

    @Override
    public void skip(long n) throws IOException {
        this.seek(this.channel.position() + n);
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }
}

