/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.io.ReaderAbstract;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class ReaderChannelMapped
extends ReaderAbstract {
    private MappedByteBuffer mappedBuffer;
    private long lastMappingStart;
    private final long DEFAULT_MAP_SIZE = 0x100000L;

    public ReaderChannelMapped(Path path, Set<StandardOpenOption> options) throws IOException {
        super(path, options);
        this.init();
    }

    public ReaderChannelMapped(Path path, StandardOpenOption ... options) throws IOException {
        super(path, options);
        this.init();
    }

    private void init() throws IOException {
        this.length = this.channel.size();
        if (this.length > 0L) {
            long maxSize = Math.min(0x100000L, this.channel.size());
            this.lastMappingStart = 0L;
            this.changeMapping(this.lastMappingStart, maxSize);
            this.byteOrder = ByteOrder.nativeOrder();
            this.mappedBuffer.order(this.byteOrder);
        } else {
            this.lastMappingStart = 0L;
        }
    }

    @Override
    public long position() throws IOException {
        if (this.mappedBuffer != null) {
            return this.lastMappingStart + (long)this.mappedBuffer.position();
        }
        return this.channel.position();
    }

    @Override
    public String toString() {
        return this.path.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.mappedBuffer != null) {
            try {
                this.mappedBuffer.force();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.channel.close();
        if (this.mappedBuffer != null) {
            try {
                this.unmap(this.mappedBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mappedBuffer = null;
    }

    private void unmap(final MappedByteBuffer buffer) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Cleaner cl;
                if (buffer instanceof DirectBuffer && (cl = ((DirectBuffer)((Object)buffer)).cleaner()) != null) {
                    cl.clean();
                }
                return null;
            }
        });
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int blen = -1;
        if (this.mappedBuffer == null) {
            throw new IOException("Empty file");
        }
        blen = (int)Math.min((long)bytes.length, this.channel.size() - (this.channel.position() - (long)this.mappedBuffer.capacity() + (long)this.mappedBuffer.position()));
        if (this.mappedBuffer.remaining() >= blen) {
            this.mappedBuffer.get(bytes, 0, blen);
        } else {
            for (int p = 0; p < blen; ++p) {
                bytes[p] = this.readByte();
            }
        }
        return blen;
    }

    @Override
    public int read(ByteBuffer bb) throws IOException {
        int blen = -1;
        if (this.mappedBuffer == null) {
            throw new IOException("Empty file");
        }
        blen = (int)Math.min((long)bb.remaining(), this.channel.size() - (this.channel.position() - (long)this.mappedBuffer.capacity() + (long)this.mappedBuffer.position()));
        for (int p = 0; p < blen; ++p) {
            bb.put(this.readByte());
        }
        return blen;
    }

    @Override
    public int read() throws IOException {
        if (this.mappedBuffer.remaining() <= 0) {
            this.nextMapping();
        }
        try {
            return this.mappedBuffer.get() & 0xFF;
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte readByte() throws IOException {
        if (this.mappedBuffer.remaining() <= 0) {
            this.nextMapping();
        }
        try {
            return this.mappedBuffer.get();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readUByte() throws IOException {
        if (this.mappedBuffer.remaining() <= 0) {
            this.nextMapping();
        }
        try {
            return this.mappedBuffer.get() & 0xFF;
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public short readShort() throws IOException {
        if (this.mappedBuffer.remaining() < 2) {
            this.nextMapping();
        }
        try {
            return this.mappedBuffer.getShort();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readUShort() throws IOException {
        if (this.mappedBuffer.remaining() < 2) {
            this.nextMapping();
        }
        try {
            return this.mappedBuffer.getShort() & 0xFFFF;
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readInt() throws IOException {
        if (this.mappedBuffer.remaining() < 4) {
            this.nextMapping();
        }
        try {
            return this.mappedBuffer.getInt();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long readUInt() throws IOException {
        if (this.mappedBuffer.remaining() < 4) {
            this.nextMapping();
        }
        try {
            return (long)this.mappedBuffer.getInt() & 0xFFFFFFFFL;
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long readLong() throws IOException {
        if (this.mappedBuffer.remaining() < 8) {
            this.nextMapping();
        }
        try {
            return this.mappedBuffer.getLong();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public float readFloat() throws IOException {
        if (this.mappedBuffer.remaining() < 4) {
            this.nextMapping();
        }
        try {
            return this.mappedBuffer.getFloat();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public double readDouble() throws IOException {
        if (this.mappedBuffer.remaining() < 8) {
            this.nextMapping();
        }
        try {
            return this.mappedBuffer.getDouble();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void seek(long pos) throws IOException, IllegalArgumentException {
        if (this.mappedBuffer != null && pos >= this.lastMappingStart && pos < this.lastMappingStart + (long)this.mappedBuffer.capacity()) {
            long posInBuffer = pos - this.lastMappingStart;
            this.mappedBuffer.position((int)posInBuffer);
        } else if (pos < this.channel.size()) {
            long mapLength = Math.min(0x100000L, this.channel.size() - pos);
            this.changeMapping(pos, mapLength);
        } else {
            this.channel.position(pos);
            this.mappedBuffer.limit(0);
        }
    }

    @Override
    public void skip(long n) throws IOException {
        this.seek(this.position() + n);
    }

    private final void nextMapping() throws IOException, IllegalArgumentException {
        long mapStart = this.lastMappingStart + (long)this.mappedBuffer.capacity() - (long)this.mappedBuffer.remaining();
        long mapLength = Math.min(0x100000L, this.channel.size() - mapStart);
        if (mapLength > 0L) {
            this.changeMapping(mapStart, mapLength);
        }
    }

    private final void changeMapping(long start, long size) throws IOException, IllegalArgumentException {
        if (this.mappedBuffer != null) {
            try {
                this.unmap(this.mappedBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mappedBuffer = ((FileChannel)this.channel).map(FileChannel.MapMode.READ_ONLY, start, size);
        this.mappedBuffer.order(this.byteOrder);
        this.lastMappingStart = start;
    }
}

