/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class SerializedPhpParser {
    private final String input;
    private int index;
    private boolean assumeUTF8 = true;
    private Pattern acceptedAttributeNameRegex = null;
    public static final Object NULL = new Object(){

        public String toString() {
            return "NULL";
        }
    };

    public SerializedPhpParser(String input) {
        this.input = input;
    }

    public SerializedPhpParser(String input, boolean assumeUTF8) {
        this.input = input;
        this.assumeUTF8 = assumeUTF8;
    }

    public Object parse() {
        char type = this.input.charAt(this.index);
        switch (type) {
            case 'i': {
                this.index += 2;
                return this.parseInt();
            }
            case 'd': {
                this.index += 2;
                return this.parseFloat();
            }
            case 'b': {
                this.index += 2;
                return this.parseBoolean();
            }
            case 's': {
                this.index += 2;
                return this.parseString();
            }
            case 'a': {
                this.index += 2;
                return this.parseArray();
            }
            case 'O': {
                this.index += 2;
                return this.parseObject();
            }
            case 'N': {
                this.index += 2;
                return NULL;
            }
        }
        throw new IllegalStateException("Encountered unknown type [" + type + " at position " + this.index + "]\n" + this.input);
    }

    private Object parseObject() {
        PhpObject phpObject = new PhpObject();
        int strLen = this.readLength();
        phpObject.name = this.input.substring(this.index, this.index + strLen);
        this.index = this.index + strLen + 2;
        int attrLen = this.readLength();
        for (int i = 0; i < attrLen; ++i) {
            Object key = this.parse();
            Object value = this.parse();
            if (!this.isAcceptedAttribute(key)) continue;
            phpObject.attributes.put(key, value);
        }
        ++this.index;
        return phpObject;
    }

    private Map<Object, Object> parseArray() {
        int arrayLen = this.readLength();
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < arrayLen; ++i) {
            Object key = this.parse();
            Object value = this.parse();
            if (!this.isAcceptedAttribute(key)) continue;
            result.put(key, value);
        }
        ++this.index;
        return result;
    }

    private boolean isAcceptedAttribute(Object key) {
        if (this.acceptedAttributeNameRegex == null) {
            return true;
        }
        if (!(key instanceof String)) {
            return true;
        }
        return this.acceptedAttributeNameRegex.matcher((String)key).matches();
    }

    private int readLength() {
        int delimiter = this.input.indexOf(58, this.index);
        int arrayLen = Integer.valueOf(this.input.substring(this.index, delimiter));
        this.index = delimiter + 2;
        return arrayLen;
    }

    private String parseString() {
        int strLen = this.readLength();
        int utfStrLen = 0;
        int byteCount = 0;
        while (byteCount != strLen) {
            char ch = this.input.charAt(this.index + utfStrLen++);
            if (this.assumeUTF8) {
                if (ch >= '\u0001' && ch <= '\u007f') {
                    ++byteCount;
                    continue;
                }
                if (ch > '\u07ff') {
                    byteCount += 3;
                    continue;
                }
                byteCount += 2;
                continue;
            }
            ++byteCount;
        }
        String value = this.input.substring(this.index, this.index + utfStrLen);
        this.index = this.index + utfStrLen + 2;
        return value;
    }

    private Boolean parseBoolean() {
        int delimiter = this.input.indexOf(59, this.index);
        String value = this.input.substring(this.index, delimiter);
        if (value.equals("1")) {
            value = "true";
        } else if (value.equals("0")) {
            value = "false";
        }
        this.index = delimiter + 1;
        return Boolean.valueOf(value);
    }

    private Double parseFloat() {
        int delimiter = this.input.indexOf(59, this.index);
        String value = this.input.substring(this.index, delimiter);
        this.index = delimiter + 1;
        return Double.valueOf(value);
    }

    private Integer parseInt() {
        int delimiter = this.input.indexOf(59, this.index);
        String value = this.input.substring(this.index, delimiter);
        this.index = delimiter + 1;
        return Integer.valueOf(value);
    }

    public void setAcceptedAttributeNameRegex(String acceptedAttributeNameRegex) {
        this.acceptedAttributeNameRegex = Pattern.compile(acceptedAttributeNameRegex);
    }

    static class PhpObject {
        String name;
        Map<Object, Object> attributes = new HashMap<Object, Object>();

        PhpObject() {
        }

        public String toString() {
            return "\"" + this.name + "\" : " + this.attributes.toString();
        }
    }
}

