/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class WriterAbstract
implements Closeable {
    protected final Path path;
    protected SeekableByteChannel channel;
    protected ByteOrder byteOrder;
    protected long length = -1L;

    public WriterAbstract(Path path, Set<StandardOpenOption> options) throws IOException {
        this.path = path;
        this.checkAccess(options);
        this.init(options);
    }

    public WriterAbstract(Path path, StandardOpenOption ... options) throws IOException {
        this.path = path;
        HashSet<StandardOpenOption> set = new HashSet<StandardOpenOption>(options.length);
        Collections.addAll(set, options);
        this.checkAccess(set);
        this.init(set);
    }

    private void checkAccess(Set<StandardOpenOption> options) throws IOException {
        if (!(options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.CREATE_NEW) || options.contains(StandardOpenOption.WRITE))) {
            throw new IOException("Only write modes allowed");
        }
    }

    private void init(Set<StandardOpenOption> options) throws IOException {
        this.channel = Files.newByteChannel(this.path, options, new FileAttribute[0]);
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public long length() throws IOException {
        if (this.length == -1L) {
            this.length = this.channel.size();
        }
        return this.length;
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public abstract void close() throws IOException;

    public abstract void write(ByteBuffer var1) throws IOException;

    public abstract void write(byte[] var1) throws IOException;

    public abstract void writeByte(byte var1) throws IOException;

    public abstract void writeShort(short var1) throws IOException;

    public abstract void writeInt(int var1) throws IOException;

    public abstract void writeLong(long var1) throws IOException;

    public abstract void writeFloat(float var1) throws IOException;

    public abstract void writeDouble(double var1) throws IOException;

    public abstract void writeTagByte(short var1, byte var2) throws IOException;

    public abstract void writeTagBytes(short var1, byte[] var2) throws IOException;

    public abstract void writeTagFloat(short var1, float var2) throws IOException;

    public abstract void writeTagFloats(short var1, float[] var2) throws IOException;

    public abstract void write(float[] var1) throws IOException;

    public abstract void writeTagShort(short var1, short var2) throws IOException;

    public abstract void writeTagInt(short var1, int var2) throws IOException;

    public abstract void writeTagLong(short var1, long var2) throws IOException;

    public abstract void writeTagDouble(short var1, double var2) throws IOException;

    public abstract void writeTagUTF8(short var1, String var2) throws IOException;

    public abstract long position() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }
}

