/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.WriterAbstract;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;

public class WriterChannel
extends WriterAbstract {
    public WriterChannel(Path path, Set<StandardOpenOption> options) throws IOException {
        super(path, options);
    }

    public WriterChannel(Path path, StandardOpenOption ... options) throws IOException {
        super(path, options);
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.channel.position(pos);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        buffer.flip();
        this.channel.write(buffer);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.channel.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.channel.write(ByteBuffer.wrap(new byte[]{b}));
    }

    @Override
    public void writeShort(short value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.order(this.byteOrder);
        bb.putShort(value);
        bb.flip();
        this.channel.write(bb);
    }

    @Override
    public void writeInt(int value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(4);
        bb.order(this.byteOrder);
        bb.putInt(value);
        bb.flip();
        this.channel.write(bb);
    }

    @Override
    public void writeLong(long value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(8);
        bb.order(this.byteOrder);
        bb.putLong(value);
        bb.flip();
        this.channel.write(bb);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(4);
        bb.order(this.byteOrder);
        bb.putFloat(value);
        bb.flip();
        this.channel.write(bb);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(8);
        bb.order(this.byteOrder);
        bb.putDouble(value);
        bb.flip();
        this.channel.write(bb);
    }

    @Override
    public void writeTagByte(short tag, byte value) throws IOException {
        this.writeTag(tag, 1);
        this.writeByte(value);
    }

    @Override
    public void writeTagBytes(short tag, byte[] values) throws IOException {
        this.writeTag(tag, values.length);
        this.write(values);
    }

    @Override
    public void writeTagFloat(short tag, float value) throws IOException {
        this.writeTag(tag, 4);
        this.writeFloat(value);
    }

    @Override
    public void writeTagFloats(short tag, float[] values) throws IOException {
        this.writeTag(tag, values.length * 4);
        this.write(values);
    }

    @Override
    public void write(float[] floats) throws IOException {
        for (float f : floats) {
            this.writeFloat(f);
        }
    }

    @Override
    public void writeTagShort(short tag, short value) throws IOException {
        this.writeTag(tag, 2);
        this.writeShort(value);
    }

    @Override
    public void writeTagInt(short tag, int value) throws IOException {
        this.writeTag(tag, 4);
        this.writeInt(value);
    }

    @Override
    public void writeTagLong(short tag, long value) throws IOException {
        this.writeTag(tag, 8);
        this.writeLong(value);
    }

    @Override
    public void writeTagDouble(short tag, double value) throws IOException {
        this.writeTagLong(tag, Double.doubleToRawLongBits(value));
    }

    @Override
    public void writeTagUTF8(short tag, String value) throws IOException {
        byte[] bytes = value.getBytes(FileOperations.charsetUTF8);
        this.writeTag(tag, bytes.length);
        this.write(bytes);
    }

    private void writeTag(short tag, int len) throws IOException {
        this.writeShort(tag);
        this.writeInt(len);
    }
}

