/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.WriterAbstract;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class WriterChannelMapped
extends WriterAbstract {
    private MappedByteBuffer mappedBuffer;
    private long lastMappingStart;
    private final long DEFAULT_MAP_SIZE = 0x100000L;

    public WriterChannelMapped(Path path, Set<StandardOpenOption> options) throws IOException {
        super(path, options);
        this.init();
    }

    public WriterChannelMapped(Path path, StandardOpenOption ... options) throws IOException {
        super(path, options);
        this.init();
    }

    private void init() throws IOException {
        this.length = this.channel.size();
        if (this.length > 0L) {
            long maxSize = Math.min(0x100000L, this.channel.size());
            this.lastMappingStart = 0L;
            this.changeMapping(this.lastMappingStart, maxSize);
            this.byteOrder = ByteOrder.nativeOrder();
            this.mappedBuffer.order(this.byteOrder);
        } else {
            this.lastMappingStart = 0L;
        }
    }

    @Override
    public long position() throws IOException {
        if (this.mappedBuffer != null) {
            return this.lastMappingStart + (long)this.mappedBuffer.position();
        }
        return this.channel.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.lastMappingStart = pos;
        this.setWriteChannelPosition();
    }

    public long getChannelPointer() throws IOException {
        return this.channel.position();
    }

    public int getBufferPosition() {
        return this.mappedBuffer.position();
    }

    @Override
    public void close() throws IOException {
        if (this.mappedBuffer != null) {
            try {
                this.mappedBuffer.force();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.channel.close();
        if (this.mappedBuffer != null) {
            try {
                this.unmap(this.mappedBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mappedBuffer = null;
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        this.setWriteChannelPosition();
        buffer.flip();
        this.channel.write(buffer);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.setWriteChannelPosition();
        this.channel.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.setWriteChannelPosition();
        this.channel.write(ByteBuffer.wrap(new byte[]{b}));
    }

    @Override
    public void writeShort(short value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.order(this.byteOrder);
        bb.putShort(value);
        bb.flip();
        this.setWriteChannelPosition();
        this.channel.write(bb);
    }

    @Override
    public void writeInt(int value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.order(this.byteOrder);
        bb.putInt(value);
        bb.flip();
        this.setWriteChannelPosition();
        this.channel.write(bb);
    }

    @Override
    public void writeLong(long value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.order(this.byteOrder);
        bb.putLong(value);
        bb.flip();
        this.setWriteChannelPosition();
        this.channel.write(bb);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.order(this.byteOrder);
        bb.putFloat(value);
        bb.flip();
        this.setWriteChannelPosition();
        this.channel.write(bb);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.order(this.byteOrder);
        bb.putDouble(value);
        bb.flip();
        this.setWriteChannelPosition();
        this.channel.write(bb);
    }

    @Override
    public void writeTagByte(short tag, byte value) throws IOException {
        this.writeTag(tag, 1);
        this.writeByte(value);
    }

    @Override
    public void writeTagBytes(short tag, byte[] values) throws IOException {
        this.writeTag(tag, values.length);
        this.write(values);
    }

    @Override
    public void writeTagFloat(short tag, float value) throws IOException {
        this.writeTag(tag, 4);
        this.writeFloat(value);
    }

    @Override
    public void writeTagFloats(short tag, float[] values) throws IOException {
        this.writeTag(tag, values.length * 4);
        this.write(values);
    }

    @Override
    public void write(float[] floats) throws IOException {
        for (float f : floats) {
            this.writeFloat(f);
        }
    }

    @Override
    public void writeTagShort(short tag, short value) throws IOException {
        this.writeTag(tag, 2);
        this.writeShort(value);
    }

    @Override
    public void writeTagInt(short tag, int value) throws IOException {
        this.writeTag(tag, 4);
        this.writeInt(value);
    }

    @Override
    public void writeTagLong(short tag, long value) throws IOException {
        this.writeTag(tag, 8);
        this.writeLong(value);
    }

    @Override
    public void writeTagDouble(short tag, double value) throws IOException {
        this.writeTagLong(tag, Double.doubleToRawLongBits(value));
    }

    @Override
    public void writeTagUTF8(short tag, String value) throws IOException {
        byte[] bytes = value.getBytes(FileOperations.charsetUTF8);
        this.writeTag(tag, bytes.length);
        this.write(bytes);
    }

    private void writeTag(short tag, int len) throws IOException {
        this.writeShort(tag);
        this.writeInt(len);
    }

    public void flush() throws IOException {
        ((FileChannel)this.channel).force(false);
    }

    private final void changeMapping(long start, long size) throws IOException, IllegalArgumentException {
        if (this.mappedBuffer != null) {
            try {
                this.unmap(this.mappedBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mappedBuffer = ((FileChannel)this.channel).map(FileChannel.MapMode.READ_WRITE, start, size);
        this.mappedBuffer.order(this.byteOrder);
        this.lastMappingStart = start;
    }

    private final void setWriteChannelPosition() throws IOException {
        if (this.mappedBuffer != null) {
            this.channel.position(this.position());
        }
    }

    private void unmap(final MappedByteBuffer buffer) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Cleaner cl;
                if (buffer instanceof DirectBuffer && (cl = ((DirectBuffer)((Object)buffer)).cleaner()) != null) {
                    cl.clean();
                }
                return null;
            }
        });
    }
}

