/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.io;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class XMLOperations {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getXMLContent(FSILogger logger, InputStream bais, Path file) {
        Document doc = null;
        if (bais != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setCoalescing(true);
            factory.setExpandEntityReferences(false);
            try {
                factory.setFeature("http://xml.org/sax/features/namespaces", false);
                factory.setFeature("http://xml.org/sax/features/validation", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                DocumentBuilder parser = factory.newDocumentBuilder();
                doc = parser.parse(bais);
            }
            catch (SAXException saxe) {
                if (logger != null) {
                    logger.log(1006, file, saxe.getLocalizedMessage());
                }
            }
            catch (ParserConfigurationException pce) {
                if (logger != null) {
                    logger.log(1006, file, pce.getLocalizedMessage());
                }
            }
            catch (IOException e) {
                if (logger != null) {
                    logger.log(1007, file, e.getLocalizedMessage());
                }
            }
            finally {
                try {
                    bais.close();
                }
                catch (IOException saxe) {}
            }
        }
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document getXMLContent(FSILogger logger, byte[] xmlraw, Path file) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xmlraw);){
            Document document = XMLOperations.getXMLContent(logger, bais, file);
            return document;
        }
        catch (IOException e) {
            if (logger == null) return null;
            logger.log(1006, file, e.getLocalizedMessage());
            return null;
        }
    }

    public static Document getXMLContent(FSILogger logger, byte[] xmlraw, String filename) {
        return XMLOperations.getXMLContent(logger, xmlraw, Paths.get(filename, new String[0]));
    }

    public static void writeXMLContent(FSILogger logger, Document doc, Path target, boolean indent) {
        try {
            DOMSource source = new DOMSource(doc);
            try (OutputStream outputStream = Files.newOutputStream(target, new OpenOption[0]);){
                StreamResult result = new StreamResult(outputStream);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                if (indent) {
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                }
                transformer.transform(source, result);
            }
        }
        catch (IOException | TransformerException e) {
            logger.logException(e, 1059, e.getLocalizedMessage(), target);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] indentXMLDocument(FSILogger logger, Document document, Path sourceFile) {
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast();){
            DOMSource ds = new DOMSource(document);
            StreamResult sr = new StreamResult(baos);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(ds, sr);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (TransformerException e) {
            if (logger == null) return null;
            logger.log(1014, sourceFile);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String performXSLTransformation(FSILogger logger, Document input, String xsl) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try (StringWriterFast sw = new StringWriterFast();){
            Templates template = factory.newTemplates(new StreamSource(new StringReader(xsl)));
            Transformer transformer = template.newTransformer();
            DOMSource source = new DOMSource(input);
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            String string = sw.getBuffer().toString();
            return string;
        }
        catch (IOException | TransformerException e) {
            if (logger == null) return null;
            logger.log(1049, "TransformerConfigurationException", e.getLocalizedMessage());
            return null;
        }
    }

    public static String elementNamesToLowerCase(FSILogger logger, Document input) {
        String xsl = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:variable name=\"lcase\">abcdefghijklmnopqrstuvwxyz</xsl:variable><xsl:variable name=\"ucase\">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template><xsl:template match=\"*\"><xsl:element name=\"{translate(local-name(),$ucase,$lcase)}\"><xsl:apply-templates select=\"@*|node()\"/></xsl:element></xsl:template></xsl:stylesheet>";
        return XMLOperations.performXSLTransformation(logger, input, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:variable name=\"lcase\">abcdefghijklmnopqrstuvwxyz</xsl:variable><xsl:variable name=\"ucase\">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template><xsl:template match=\"*\"><xsl:element name=\"{translate(local-name(),$ucase,$lcase)}\"><xsl:apply-templates select=\"@*|node()\"/></xsl:element></xsl:template></xsl:stylesheet>");
    }

    public static <T> T unmarshalJAXB(InputStream is, Class<T> clasz) throws IOException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clasz});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            return (T)unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public static <T> T unmarshalJAXB(Path path, Class<T> clasz) throws IOException {
        try (InputStream os = Files.newInputStream(path, new OpenOption[0]);){
            T t = XMLOperations.unmarshalJAXB(os, clasz);
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshalJAXB(String xml, Class<T> clasz) throws IOException {
        try (StringReader sr = new StringReader(xml);){
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clasz});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Object object = unmarshaller.unmarshal((Reader)sr);
            return (T)object;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public static void marshalJAXBIndent(Object entity, Path path) throws JAXBException, IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            XMLOperations.marshalJAXBIndent(entity, os);
        }
    }

    public static void marshalJAXBIndent(Object entity, OutputStream stream) throws JAXBException {
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{entity.getClass()}).createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(entity, stream);
    }
}

