/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.licensing;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.licensing.RSAKey;
import java.math.BigInteger;

public final class KeyLoader {
    public RSAKey loadRSAKey(String key) {
        RSAKey rsa = new RSAKey();
        byte[] rawkey = this.xRead(key);
        if (rawkey != null) {
            int pos = 0;
            int len = (rawkey[pos++] & 0xFF) << 8 | rawkey[pos++] & 0xFF;
            byte[] bsoftware = new byte[len];
            System.arraycopy(rawkey, pos, bsoftware, 0, len);
            rsa.software = new String(bsoftware, FileOperations.charsetUTF8);
            pos += len;
            len = (rawkey[pos++] & 0xFF) << 8 | rawkey[pos++] & 0xFF;
            byte[] bmajorVersion = new byte[len];
            System.arraycopy(rawkey, pos, bmajorVersion, 0, len);
            rsa.majorVersion = Integer.valueOf(new String(bmajorVersion, FileOperations.charsetUTF8));
            pos += len;
            len = (rawkey[pos++] & 0xFF) << 8 | rawkey[pos++] & 0xFF;
            byte[] rawbytes = new byte[len];
            System.arraycopy(rawkey, pos, rawbytes, 0, len);
            rsa.exponent = new BigInteger(rawbytes);
            pos += len;
            len = (rawkey[pos++] & 0xFF) << 8 | rawkey[pos++] & 0xFF;
            rawbytes = new byte[len];
            System.arraycopy(rawkey, pos, rawbytes, 0, len);
            rsa.modulus = new BigInteger(rawbytes);
            pos += len;
        }
        return rsa;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] xRead(String str) {
        byte[] bstr = str.getBytes(FileOperations.charsetUTF8);
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(bstr.length);){
            int c = 0;
            int p = 0;
            int y = -1;
            int l = 170;
            int m = 0;
            while (true) {
                if (c >= bstr.length) {
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                while (++y < 2) {
                    int h = bstr[c + y];
                    h = h < 47 ? (h -= 45) : (h < 58 ? (h -= 46) : (h < 91 ? (h -= 53) : (h -= 59)));
                    p |= y == 1 ? (h & 0xF) << 4 : h & 0xF;
                    if ((1 ^ h & 3 ^ h >> 2 & 3) == h >> 4) continue;
                    byte[] byArray = null;
                    return byArray;
                }
                y = -1;
                m = (l ^ c / 2 * 146) & 0xFF;
                l = p;
                baos.write((char)(p ^= m));
                p = 0;
                c += 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }
}

