/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.licensing;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.licensing.KeyLoader;
import com.neptunelabs.fsiframework.licensing.LicenceDecrypt;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.nio.ByteOrder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Licence {
    private long maxImages = 1L;
    private int maxConnectors = 1;
    private int maxUserGroups = 1;
    private boolean jmxSupport = true;
    private boolean stagingLicence = false;
    private boolean trialLicence = false;
    private boolean batchProcessing = true;
    private boolean mirrorLicence = false;
    private String edition = null;
    private int editionID = 0;
    private long expireTime = 0L;
    private byte[][] macs;
    private Integer[] usids;
    private Map<String, String> modules;
    private String pid;
    private String licensee;
    private String fsiviewerLCID;
    private long registerDate;
    private int licenceID;
    private int minVersion = 0;
    private int maxVersion = 0;
    private boolean flagNFR = false;
    private boolean flagNonProfit = false;
    private boolean hasLicence = false;
    private int errorCode = 0;
    private long fileLastModified = 0L;
    private static final long hashAddOn = 5872115821672947552L;
    private static final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static final int sMod = 157;
    private final byte[] mapKey = new byte[]{-42, -8, -28};
    private final byte[] mapApplicationID = new byte[]{-36, -19, -19, -15, -12, -2, -4, -23, -12, -14, -13, -44, -39};
    private final byte[] mapKeyVersion = new byte[]{-42, -8, -28, -53, -8, -17, -18, -12, -14, -13};
    private final byte[] mapPID = new byte[]{-51, -44, -39};
    private final byte[] mapModules = new byte[]{-48, -14, -7, -24, -15, -8, -18};
    private final byte[] mapMACList = new byte[]{-48, -36, -34, -47, -12, -18, -23};
    private final byte[] mapRegisterDate = new byte[]{-49, -8, -6, -12, -18, -23, -8, -17, -39, -4, -23, -8};
    private final byte[] mapUSIDList = new byte[]{-56, -50, -44, -39, -47, -12, -18, -23};
    private final byte[] mapLicencee = new byte[]{-47, -12, -2, -8, -13, -18, -8, -8};
    private final byte[] mapLimitation = new byte[]{-47, -12, -16, -12, -23, -4, -23, -12, -14, -13};
    private final byte[] mapLicenceID = new byte[]{-47, -12, -2, -8, -13, -2, -8, -44, -39};
    private final byte[] mapAppID = new byte[]{-36, -19, -19, -44, -39};
    private final byte[] mapAppVersionFrom = new byte[]{-36, -19, -19, -53, -8, -17, -18, -12, -14, -13, -37, -17, -14, -16};
    private final byte[] mapAppVersionTo = new byte[]{-36, -19, -19, -53, -8, -17, -18, -12, -14, -13, -55, -14};
    private final byte[] mapExpireDate = new byte[]{-40, -27, -19, -12, -17, -8, -39, -4, -23, -8};
    private final byte[] mapImages = new byte[]{-44, -16, -4, -6, -8, -18};
    private final byte[] mapEditionID = new byte[]{-40, -7, -12, -23, -12, -14, -13, -44, -39};
    private final byte[] mapEdition = new byte[]{-40, -7, -12, -23, -12, -14, -13};
    private final byte[] mapNFR = new byte[]{-45, -37, -49};
    private final byte[] mapLMR = new byte[]{-47, -48, -49};
    private final byte[] mapNonProfit = new byte[]{-45, -14, -13, -51, -17, -14, -5, -12, -23};
    private final byte[] mapGroups = new byte[]{-38, -17, -14, -24, -19, -18};
    private final byte[] mapConnectors = new byte[]{-34, -14, -13, -13, -8, -2, -23, -14, -17, -18};
    private final byte[] mapStaging = new byte[]{-50, -23, -4, -6, -12, -13, -6};
    private byte[] mapTrial = new byte[]{-55, -17, -12, -4, -15};
    private final byte[] mapBatch = new byte[]{-33, -4, -23, -2, -11};
    private final byte[] mapMirror = new byte[]{-48, -12, -17, -17, -14, -17};
    private final byte[] mapJMX = new byte[]{-41, -48, -59};
    private byte[] mapMinBuild = new byte[]{-48, -12, -13, -33, -24, -12, -15, -7};
    private byte[] mapMaxBuild = new byte[]{-48, -4, -27, -33, -24, -12, -15, -7};
    private final byte[] mapFSIViewerLCID = new byte[]{-37, -50, -44, -53, -12, -8, -22, -8, -17, -47, -34, -44, -39};
    private final String sKey = this.bytesToString(this.mapKey, 157);
    private final String sApplicationID = this.bytesToString(this.mapApplicationID, 157);
    private final String sKeyVersion = this.bytesToString(this.mapKeyVersion, 157);
    private final String sPID = this.bytesToString(this.mapPID, 157);
    private final String sModules = this.bytesToString(this.mapModules, 157);
    private final String sMACList = this.bytesToString(this.mapMACList, 157);
    private final String sRegisterDate = this.bytesToString(this.mapRegisterDate, 157);
    private final String sUSIDList = this.bytesToString(this.mapUSIDList, 157);
    private final String sImages = this.bytesToString(this.mapImages, 157);
    private final String sEditionID = this.bytesToString(this.mapEditionID, 157);
    private final String sLicencee = this.bytesToString(this.mapLicencee, 157);
    private final String sLimitation = this.bytesToString(this.mapLimitation, 157);
    private final String sLicenceID = this.bytesToString(this.mapLicenceID, 157);
    private final String sAppID = this.bytesToString(this.mapAppID, 157);
    private final String sAppVersionFrom = this.bytesToString(this.mapAppVersionFrom, 157);
    private final String sAppVersionTo = this.bytesToString(this.mapAppVersionTo, 157);
    private final String sExpireDate = this.bytesToString(this.mapExpireDate, 157);
    private final String sEdition = this.bytesToString(this.mapEdition, 157);
    private final String sNFR = this.bytesToString(this.mapNFR, 157);
    private final String sLMR = this.bytesToString(this.mapLMR, 157);
    private final String sNonProfit = this.bytesToString(this.mapNonProfit, 157);
    private final String sGroups = this.bytesToString(this.mapGroups, 157);
    private final String sConnectors = this.bytesToString(this.mapConnectors, 157);
    private final String sStaging = this.bytesToString(this.mapStaging, 157);
    private final String sTrial = this.bytesToString(this.mapTrial, 157);
    private final String sBatch = this.bytesToString(this.mapBatch, 157);
    private final String sMirror = this.bytesToString(this.mapMirror, 157);
    private final String sJMX = this.bytesToString(this.mapJMX, 157);
    private final String sMinBuild = this.bytesToString(this.mapMinBuild, 157);
    private final String sMaxBuild = this.bytesToString(this.mapMaxBuild, 157);
    private final String sFSIViewerLCID = this.bytesToString(this.mapFSIViewerLCID, 157);
    public static final int ERROR_STRUCTURE = 1;
    public static final int ERROR_CONTAINER_VERSION = 2;
    public static final int ERROR_MAJOR_VERSION = 4;
    public static final int ERROR_APPLICATION_ID = 8;

    public boolean decodeLicenceString(FSILogger logger, String licencestr, int requiredKeyVersion, int applicationID, int appMajorVersion, String publicKey, long lastModified) {
        int error = 0;
        Map<String, ?> licenceMap = this.decodeLicence(publicKey, licencestr);
        if (licenceMap != null) {
            error = this.evaluateLicence(licenceMap, requiredKeyVersion, applicationID, appMajorVersion);
            this.fileLastModified = lastModified;
        } else {
            error |= 1;
        }
        this.errorCode = error;
        if (error == 0) {
            this.hasLicence = true;
            return true;
        }
        return false;
    }

    private int evaluateLicence(Map<String, ?> licenceMap, int requiredKeyVersion, int applicationID, int keySubVersion) {
        int error = 0;
        try {
            this.batchProcessing = false;
            this.jmxSupport = false;
            this.mirrorLicence = false;
            int keyVersion = (Integer)licenceMap.get(this.sKeyVersion);
            if (keyVersion == requiredKeyVersion) {
                int appID = this.getInteger(licenceMap.get(this.sAppID));
                if (appID == applicationID) {
                    int keySubFrom = this.getInteger(licenceMap.get(this.sAppVersionFrom));
                    int keySubTo = this.getInteger(licenceMap.get(this.sAppVersionTo));
                    if (keySubVersion >= keySubFrom && keySubVersion <= keySubTo) {
                        Object o = licenceMap.get(this.sPID);
                        if (o != null && o instanceof String) {
                            this.pid = (String)o;
                        }
                        if ((o = licenceMap.get(this.sRegisterDate)) != null && o instanceof String) {
                            Date date = dateFormatter.parse((String)o);
                            this.registerDate = date.getTime();
                        }
                        if ((o = licenceMap.get(this.sLicenceID)) != null) {
                            this.licenceID = this.getInteger(o);
                        }
                        if ((o = licenceMap.get(this.sLicencee)) != null && o instanceof String) {
                            this.licensee = (String)o;
                        }
                        if ((o = licenceMap.get(this.sUSIDList)) != null && o instanceof Map) {
                            Map usidlist = (Map)o;
                            this.usids = new Integer[usidlist.size()];
                            int ic = 0;
                            for (Object usido : usidlist.values()) {
                                this.usids[ic] = this.getInteger(usido);
                                ++ic;
                            }
                        }
                        if ((o = licenceMap.get(this.sModules)) != null && o instanceof Map) {
                            this.modules = (Map)o;
                        }
                        if ((o = licenceMap.get(this.sLimitation)) != null && o instanceof Map) {
                            Map limits = (Map)o;
                            for (Map.Entry entry : limits.entrySet()) {
                                Matcher m;
                                Pattern p;
                                String key = (String)entry.getKey();
                                if (key.equalsIgnoreCase(this.sExpireDate)) {
                                    String source = (String)entry.getValue();
                                    Date date = dateFormatter.parse(source);
                                    this.expireTime = date.getTime();
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sImages)) {
                                    this.maxImages = this.getInteger(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sEditionID)) {
                                    this.editionID = this.getInteger(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sEdition)) {
                                    this.edition = (String)entry.getValue();
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sNFR)) {
                                    this.flagNFR = this.getBoolean(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sLMR)) {
                                    this.macs = this.decodeLMR((String)entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sNonProfit)) {
                                    this.flagNonProfit = this.getBoolean(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sJMX)) {
                                    this.jmxSupport = this.getBoolean(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sFSIViewerLCID)) {
                                    this.fsiviewerLCID = (String)entry.getValue();
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sStaging)) {
                                    this.stagingLicence = this.getBoolean(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sTrial)) {
                                    this.trialLicence = this.getBoolean(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sBatch)) {
                                    this.batchProcessing = this.getBoolean(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sMirror)) {
                                    this.mirrorLicence = this.getBoolean(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sGroups)) {
                                    this.maxUserGroups = this.getInteger(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sConnectors)) {
                                    this.maxConnectors = this.getInteger(entry.getValue());
                                    continue;
                                }
                                if (key.equalsIgnoreCase(this.sMinBuild)) {
                                    String minBuildStr = (String)entry.getValue();
                                    p = Pattern.compile("(\\d{2})[.](\\d{2})");
                                    m = p.matcher(minBuildStr);
                                    if (!m.matches()) continue;
                                    this.minVersion = this.getInteger(m.group(1)) * 100 + this.getInteger(m.group(2));
                                    continue;
                                }
                                if (!key.equalsIgnoreCase(this.sMaxBuild)) continue;
                                String maxBuildStr = (String)entry.getValue();
                                p = Pattern.compile("(\\d{2})[.](\\d{2})");
                                m = p.matcher(maxBuildStr);
                                if (!m.matches()) continue;
                                this.maxVersion = this.getInteger(m.group(1)) * 100 + this.getInteger(m.group(2));
                            }
                        }
                    } else {
                        error |= 4;
                    }
                } else {
                    error |= 8;
                }
            } else {
                error |= 2;
            }
        }
        catch (ClassCastException e) {
            error |= 1;
        }
        catch (NullPointerException e) {
            error |= 1;
        }
        catch (ParseException e) {
            error |= 1;
        }
        catch (NumberFormatException e) {
            error |= 1;
        }
        return error;
    }

    public long getLongHash() {
        return 5872115821672947552L;
    }

    public int getMinVersion() {
        return this.minVersion;
    }

    public int getMaxVersion() {
        return this.maxVersion;
    }

    public String getNiceMinVersion() {
        if (this.minVersion > 100) {
            int majorVersion = this.minVersion / 100;
            int minorVersion = this.minVersion - majorVersion * 100;
            return String.format("%d.%02d", majorVersion, minorVersion);
        }
        return "";
    }

    public String getNiceMaxVersion() {
        if (this.maxVersion > 100) {
            int majorVersion = this.maxVersion / 100;
            int minorVersion = this.maxVersion - majorVersion * 100;
            return String.format("%d.%02d", majorVersion, minorVersion);
        }
        return "";
    }

    public long getMaxImages() {
        return this.maxImages;
    }

    public int getMaxConnectors() {
        return this.maxConnectors;
    }

    public int getMaxUserGroups() {
        return this.maxUserGroups;
    }

    public int getMaxInstances() {
        if (this.usids != null) {
            return this.usids.length;
        }
        return 0;
    }

    public boolean isJMXEnabled() {
        return this.jmxSupport;
    }

    public boolean isStagingLicence() {
        return this.stagingLicence;
    }

    public boolean isTrialLicence() {
        return this.trialLicence;
    }

    public boolean isMirrorLicence() {
        return this.mirrorLicence;
    }

    public boolean isBatchProcessingEnabled() {
        return this.batchProcessing;
    }

    public int getEditonID() {
        return this.editionID;
    }

    public String getEdition() {
        return this.edition;
    }

    public boolean getFlagNFR() {
        return this.flagNFR;
    }

    public boolean getFlagNonProfit() {
        return this.flagNonProfit;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public long getRegisterTime() {
        return this.registerDate;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public byte[][] getMacAddresses() {
        return this.macs;
    }

    public String getFSIViewerLCID() {
        return this.fsiviewerLCID;
    }

    public String getPID() {
        return this.pid;
    }

    public Integer[] getUSID() {
        return this.usids;
    }

    public int getLicenceID() {
        return this.licenceID;
    }

    public long getFileLastModified() {
        return this.fileLastModified;
    }

    public Map<String, String> getModules() {
        return this.modules != null ? this.modules : new HashMap<String, String>();
    }

    public boolean hasLicence() {
        return this.hasLicence;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int hashCode() {
        int result = 0;
        result = (int)((long)result ^ this.maxImages);
        result ^= this.maxConnectors;
        result = this.jmxSupport ? ~result : (result ^= this.maxUserGroups);
        result = this.stagingLicence ? ~result : result;
        result = this.batchProcessing ? ~result : result;
        result ^= this.editionID;
        result = (int)((long)result ^ this.expireTime);
        if (this.macs != null) {
            for (byte[] mac : this.macs) {
                for (int j = 0; j < mac.length; ++j) {
                    result ^= mac[j] << j * 8 % 24;
                }
            }
        }
        if (this.usids != null) {
            for (Object usid : (Object)this.usids) {
                result ^= ((Integer)usid).intValue();
            }
        }
        if (this.modules != null) {
            Object object = this.modules.values().iterator();
            while (object.hasNext()) {
                String mod = (String)object.next();
                result ^= mod.hashCode();
            }
        }
        if (this.pid != null) {
            result ^= this.pid.hashCode();
        }
        if (this.licensee != null) {
            result ^= this.licensee.hashCode();
        }
        if (this.fsiviewerLCID != null) {
            result ^= this.fsiviewerLCID.hashCode();
        }
        result = (int)((long)result ^ this.registerDate);
        result = this.flagNFR ? ~result : (result ^= this.licenceID);
        result = this.flagNonProfit ? ~result : result;
        return result;
    }

    private Map<String, ?> decodeLicence(String publicKey, String rawLicence) {
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator i = new StringCharacterIterator(rawLicence);
        char c = i.current();
        while (c != '\uffff') {
            if (c >= '.' && c <= 'z') {
                sb.append(c);
            }
            c = i.next();
        }
        LicenceDecrypt ldec = new LicenceDecrypt();
        ldec.loadRSAKey(publicKey);
        Map<String, ?> licenceMap = ldec.decryptLicenceKey(sb.toString());
        return licenceMap;
    }

    private String bytesToString(byte[] bytes, int mod) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            char c = (char)((b ^ mod) & 0xFF);
            sb.append(c);
        }
        return sb.toString();
    }

    private String getNodeTextContent(NodeList nl) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 3) continue;
            sb.append(n.getNodeValue());
        }
        return sb.toString().trim();
    }

    private int getInteger(Object o) throws NumberFormatException {
        int ret = 0;
        if (o instanceof Integer) {
            ret = (Integer)o;
        } else if (o instanceof String) {
            ret = Integer.valueOf((String)o);
        }
        return ret;
    }

    private boolean getBoolean(Object o) throws NumberFormatException {
        boolean ret = false;
        if (o instanceof Boolean) {
            ret = (Boolean)o;
        } else if (o instanceof String) {
            ret = Boolean.valueOf((String)o);
        }
        return ret;
    }

    private byte[][] decodeLMR(String rawLMR) {
        ByteArrayWalker bb;
        int tag;
        Object result = null;
        KeyLoader kl = new KeyLoader();
        byte[] rawCont = kl.xRead(rawLMR);
        if (rawCont != null && (tag = (bb = ByteArrayWalker.wrap(rawCont, ByteOrder.LITTLE_ENDIAN)).getInt()) == 1) {
            int macNum = bb.getInt();
            result = new byte[macNum][];
            for (int n = 0; n < macNum; ++n) {
                int macLen = bb.getInt();
                byte[] mac = new byte[macLen];
                bb.get(mac);
                result[n] = mac;
            }
        }
        return result;
    }
}

