/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.licensing;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiframework.licensing.LicenceList;
import com.neptunelabs.fsiframework.licensing.RawLicence;
import com.neptunelabs.fsiframework.security.DigestUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LicenceContainer {
    private boolean loadedFromFile = false;
    private boolean initializationErrors = false;
    private String errorMessage;
    private LicenceList list = new LicenceList();
    private byte[] licenceRawData;
    private long lastModified = 0L;
    private String containerHash = null;

    private static RawLicence readOldStyleLicence(Path licenceFile) throws IllegalArgumentException, IOException {
        RawLicence rl = new RawLicence();
        rl.lastModified = Files.getLastModifiedTime(licenceFile, new LinkOption[0]).toMillis();
        Document doc = FileOperations.getXMLFileContent(null, licenceFile);
        if (doc != null && doc.hasChildNodes()) {
            Element rootnode = doc.getDocumentElement();
            NodeList nodelist = rootnode.getChildNodes();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Node n = nodelist.item(i);
                if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("key")) continue;
                Node keyNode = n;
                NamedNodeMap keyAttr = keyNode.getAttributes();
                for (int li = 0; li < keyAttr.getLength(); ++li) {
                    String linStrV;
                    Node lin = keyAttr.item(li);
                    String linName = lin.getNodeName();
                    if (linName.equalsIgnoreCase("applicationid")) {
                        linStrV = lin.getNodeValue();
                        try {
                            rl.appid = Integer.valueOf(linStrV);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid value for applicationid");
                        }
                    }
                    if (!linName.equalsIgnoreCase("applicationversion")) continue;
                    linStrV = lin.getNodeValue();
                    try {
                        rl.version = Integer.valueOf(linStrV);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid value for applicationversion");
                    }
                }
                rl.licence = n.getTextContent();
            }
        } else {
            throw new IllegalArgumentException("Missing root node");
        }
        if (rl.appid != null && rl.appid == 22 && rl.version == null) {
            rl.version = 1;
        }
        return rl;
    }

    public static LicenceContainer getInstance(InputStream inputStream) {
        LicenceContainer result = new LicenceContainer();
        try {
            result.list = LicenceContainer.readListFromFile(inputStream, result.lastModified);
        }
        catch (IllegalArgumentException iae) {
            result.initializationErrors = true;
            result.setErrorMessage(iae.getLocalizedMessage());
        }
        result.setLoadedFromFile(false);
        return result;
    }

    public static LicenceContainer getInstance(Path licenceFile) throws IOException {
        LicenceContainer result;
        block9: {
            result = new LicenceContainer();
            if (licenceFile != null && Files.exists(licenceFile, new LinkOption[0])) {
                result.lastModified = Files.getLastModifiedTime(licenceFile, new LinkOption[0]).toMillis();
                byte[] data = FileOperations.readFile(licenceFile);
                result.containerHash = DigestUtils.sha256(data);
                try {
                    result.list = LicenceContainer.readListFromFile(new ByteArrayInputStream(data), result.lastModified);
                }
                catch (IllegalArgumentException iae) {
                    result.initializationErrors = true;
                    result.setErrorMessage(iae.getLocalizedMessage());
                }
                if (result.list == null || result.list.licences == null || !result.isValid()) {
                    try {
                        RawLicence rl = LicenceContainer.readOldStyleLicence(licenceFile);
                        if (rl.appid == null) break block9;
                        result.list = new LicenceList();
                        result.list.licences = new ArrayList<RawLicence>();
                        result.list.licences.add(rl);
                        result.initializationErrors = false;
                        try {
                            FileOperations.copy(licenceFile, licenceFile.resolveSibling("licence.org"));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        LicenceContainer.saveToFile(licenceFile, data);
                    }
                    catch (IOException | IllegalArgumentException iae) {
                        result.initializationErrors = true;
                        result.setErrorMessage(iae.getLocalizedMessage());
                    }
                }
            } else {
                result.setErrorMessage("File " + licenceFile + " does not exist.");
                result.initializationErrors = true;
            }
        }
        result.setLoadedFromFile(true);
        return result;
    }

    private void setLoadedFromFile(boolean value) {
        this.loadedFromFile = value;
    }

    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    private void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getContainerHash() {
        return this.containerHash;
    }

    public void setRawLicences(List<RawLicence> licences) {
        this.list.licences = licences;
    }

    public List<RawLicence> getRawLicences() {
        if (this.list.licences != null) {
            return this.list.licences;
        }
        return new ArrayList<RawLicence>();
    }

    public byte[] getRawLicence() {
        return this.licenceRawData;
    }

    public boolean hasInitializationErrors() {
        return this.initializationErrors;
    }

    public static void saveToFile(Path licenceFile, byte[] data) throws IOException {
        FileOperations.writeFile(licenceFile, data);
    }

    private static void saveLicenceListX(LicenceList ll, Path licenceFile) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            doc.setXmlVersion("1.0");
            Element rootNode = doc.createElement("fsi_licences");
            for (RawLicence rl : ll.licences) {
                Element keyNode = doc.createElement("key");
                keyNode.setAttribute("version", String.valueOf(rl.version));
                keyNode.setAttribute("appid", String.valueOf(rl.appid));
                if (rl.properties != null) {
                    for (RawLicence.LicenceProperty prop : rl.properties) {
                        Element propnode = doc.createElement("property");
                        propnode.setAttribute("name", prop.name);
                        for (String value : prop.values) {
                            Element valueNode = doc.createElement("value");
                            valueNode.setTextContent(value);
                            propnode.appendChild(valueNode);
                        }
                        keyNode.appendChild(propnode);
                    }
                }
                Element licenceNode = doc.createElement("licence");
                String cleanLicenceBlock = LicenceContainer.cleanLicenceString(rl.licence);
                licenceNode.setTextContent(cleanLicenceBlock);
                keyNode.appendChild(licenceNode);
                rootNode.appendChild(keyNode);
            }
            doc.appendChild(rootNode);
            XMLOperations.writeXMLContent(null, doc, licenceFile, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    private static String cleanLicenceString(String licenceString) {
        StringBuilder sb = new StringBuilder("\n      ");
        StringCharacterIterator it = new StringCharacterIterator(licenceString);
        int counter = 0;
        char c = it.current();
        while (c != '\uffff') {
            if (c >= '.' && c <= 'z') {
                sb.append(c);
                if (++counter % 63 == 0) {
                    sb.append("\n      ");
                }
            }
            c = it.next();
        }
        sb.append("\n    ");
        return sb.toString();
    }

    private static LicenceList readListFromFile(InputStream inputStream, long licenceLastModified) throws IllegalArgumentException {
        LicenceList result = new LicenceList();
        result.licences = new ArrayList<RawLicence>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            Element rootNode = doc.getDocumentElement();
            if (!rootNode.getNodeName().equalsIgnoreCase("fsi_licences")) {
                throw new IllegalArgumentException("Invalid root node");
            }
            NodeList keyNodes = rootNode.getChildNodes();
            for (int i = 0; i < keyNodes.getLength(); ++i) {
                Node keyNode = keyNodes.item(i);
                if (keyNode.getNodeType() != 1) continue;
                RawLicence rl = new RawLicence();
                rl.properties = new ArrayList<RawLicence.LicenceProperty>();
                NamedNodeMap attributes = keyNode.getAttributes();
                Node idAttr = attributes.getNamedItem("appid");
                rl.appid = Integer.parseInt(idAttr.getNodeValue());
                Node versionAttr = attributes.getNamedItem("version");
                rl.version = Integer.parseInt(versionAttr.getNodeValue());
                rl.lastModified = licenceLastModified;
                NodeList nl = keyNode.getChildNodes();
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node n = nl.item(j);
                    if (n.getNodeName().equals("licence")) {
                        rl.licence = n.getTextContent();
                        continue;
                    }
                    if (!n.getNodeName().equals("property")) continue;
                    RawLicence.LicenceProperty prop = new RawLicence.LicenceProperty();
                    NamedNodeMap propertyAttributes = n.getAttributes();
                    prop.name = propertyAttributes.getNamedItem("name").getNodeValue();
                    NodeList valueNodes = n.getChildNodes();
                    ArrayList<String> values = new ArrayList<String>();
                    for (int l = 0; l < valueNodes.getLength(); ++l) {
                        Node valueNode = valueNodes.item(l);
                        if (valueNode.getNodeType() != 1) continue;
                        values.add(valueNodes.item(l).getTextContent());
                    }
                    prop.values = values;
                    rl.properties.add(prop);
                }
                result.licences.add(rl);
            }
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Error parsing file");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading file");
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Invalid file");
        }
        return result;
    }

    public boolean isValid() {
        boolean result = true;
        if (this.list.licences != null) {
            for (RawLicence rl : this.list.licences) {
                if (rl.appid == null) {
                    this.errorMessage = "Missing attribute \"appid\".";
                    result = false;
                    continue;
                }
                if (rl.version == null) {
                    this.errorMessage = "Missing attribute \"version\".";
                    result = false;
                    continue;
                }
                if (rl.licence != null) continue;
                this.errorMessage = "Missing element \"licence\".";
                result = false;
            }
        }
        return result;
    }
}

