/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.licensing;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.SerializedPhpParser;
import com.neptunelabs.fsiframework.licensing.InflaterOutputStream;
import com.neptunelabs.fsiframework.licensing.KeyLoader;
import com.neptunelabs.fsiframework.licensing.RSAKey;
import com.neptunelabs.fsiframework.security.RC4;
import java.io.IOException;
import java.util.Map;
import java.util.zip.Inflater;

public final class LicenceDecrypt {
    private KeyLoader kl = new KeyLoader();
    private RSAKey privatekey = null;
    private int errorCode = 0;

    public boolean loadRSAKey(String rawkey) {
        boolean ret = false;
        this.kl = new KeyLoader();
        this.privatekey = this.kl.loadRSAKey(rawkey);
        if (this.privatekey.modulus != null) {
            ret = true;
        }
        return ret;
    }

    public Map<String, ?> decryptLicenceKey(String licencestr) {
        Map licence = null;
        if (this.privatekey.modulus != null) {
            byte[] rawkey = this.kl.xRead(licencestr);
            if (rawkey != null) {
                int pos = 0;
                int len = (rawkey[pos++] & 0xFF) << 8 | rawkey[pos++] & 0xFF;
                byte[] rsasymkey = new byte[len];
                System.arraycopy(rawkey, pos, rsasymkey, 0, len);
                pos += len;
                len = (rawkey[pos++] & 0xFF) << 8 | rawkey[pos++] & 0xFF;
                byte[] ciphermsg = new byte[len];
                System.arraycopy(rawkey, pos, ciphermsg, 0, len);
                pos += len;
                byte[] symkey = RSAKey.encrypt(this.privatekey.modulus, this.privatekey.exponent, rsasymkey);
                byte[] message = RC4.encode(symkey, ciphermsg);
                if (message != null) {
                    Inflater infl = new Inflater(true);
                    try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(1000);
                         InflaterOutputStream ios = new InflaterOutputStream(baos, infl, 8192);){
                        ios.write(message);
                        try {
                            ios.close();
                            SerializedPhpParser spp = new SerializedPhpParser(new String(baos.toByteArray(), FileOperations.charsetUTF8), true);
                            licence = (Map)spp.parse();
                        }
                        catch (ClassCastException e) {
                            this.errorCode = 1;
                        }
                    }
                    catch (IOException e) {
                        this.errorCode = 2;
                    }
                } else {
                    this.errorCode = 3;
                }
            } else {
                this.errorCode = 4;
            }
        } else {
            this.errorCode = 5;
        }
        return licence;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

