/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.licensing;

import com.neptunelabs.fsiframework.helpers.FileEventCallback;
import com.neptunelabs.fsiframework.io.FileEventCursor;
import com.neptunelabs.fsiframework.licensing.LicenceConsumer;
import com.neptunelabs.fsiframework.licensing.LicenceContainer;
import com.neptunelabs.fsiframework.licensing.RawLicence;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LicenceManager {
    private final FSILogger logger;
    private final Path licenceFile;
    private final List<LicenceConsumer> licenceConsumers = new ArrayList<LicenceConsumer>();
    private final Map<Integer, Map<Integer, RawLicence>> licences = new HashMap<Integer, Map<Integer, RawLicence>>();
    private FileEventCursor.RegisteredPath eventPath;
    private FileEventCursor fileEventCursor;
    private String containerHash = null;

    public LicenceManager(FSILogger logger, Path licenceFile) throws IOException {
        this.logger = logger;
        this.licenceFile = licenceFile;
        this.readLicences();
    }

    private void saveLicences() throws IOException {
        if (this.eventPath != null) {
            this.eventPath.setSuspended(true);
        }
        LicenceContainer lc = new LicenceContainer();
        lc.setRawLicences(this.getAllLicences());
        LicenceContainer.saveToFile(this.licenceFile, lc.getRawLicence());
        if (this.eventPath != null) {
            this.eventPath.setSuspended(false);
        }
    }

    public void readLicences() throws IOException {
        this.licences.clear();
        LicenceContainer lc = LicenceContainer.getInstance(this.licenceFile);
        if (!lc.hasInitializationErrors() && lc.isValid()) {
            for (RawLicence rl : lc.getRawLicences()) {
                if (this.licences.containsKey(rl.appid)) {
                    this.licences.get(rl.appid).put(rl.version, rl);
                    continue;
                }
                HashMap<Integer, RawLicence> versionmap = new HashMap<Integer, RawLicence>();
                versionmap.put(rl.version, rl);
                this.licences.put(rl.appid, versionmap);
            }
            this.containerHash = lc.getContainerHash();
        } else {
            this.containerHash = null;
            if (this.logger != null) {
                this.logger.log(7003, lc.getErrorMessage());
            }
        }
        for (LicenceConsumer consumer : this.licenceConsumers) {
            consumer.updateLicenceFromLicenceManager();
        }
    }

    public void setFileEventCursor(FileEventCursor fileEventCursor) {
        this.fileEventCursor = fileEventCursor;
        this.startWatcher();
    }

    private boolean addRawLicence(RawLicence rawLicence) {
        Map<Object, Object> map;
        if (rawLicence == null) {
            throw new IllegalArgumentException("tried to set null licence.");
        }
        boolean replaced = false;
        if (this.licences.containsKey(rawLicence.appid)) {
            map = this.licences.get(rawLicence.appid);
        } else {
            map = new HashMap();
            this.licences.put(rawLicence.appid, map);
        }
        if (map.containsKey(rawLicence.version)) {
            replaced = true;
        }
        map.put(rawLicence.version, rawLicence);
        return replaced;
    }

    public void removeLicence(int appid, int version) throws IOException {
        Map<Integer, RawLicence> map;
        boolean changes = false;
        if (this.licences.containsKey(appid) && (map = this.licences.get(appid)).containsKey(version)) {
            map.remove(version);
            changes = true;
            if (map.size() == 0) {
                this.licences.remove(appid);
            }
        }
        if (changes) {
            this.saveLicences();
            for (LicenceConsumer consumer : this.licenceConsumers) {
                consumer.updateLicenceFromLicenceManager();
            }
        }
    }

    public void removeAllLicences() throws IOException {
        this.licences.clear();
        this.saveLicences();
    }

    public boolean addLicences(Collection<RawLicence> newLicences) throws IOException {
        boolean replaced = false;
        for (RawLicence rl : newLicences) {
            replaced |= this.addRawLicence(rl);
        }
        this.saveLicences();
        for (LicenceConsumer consumer : this.licenceConsumers) {
            consumer.updateLicenceFromLicenceManager();
        }
        return replaced;
    }

    public boolean addLicence(RawLicence licence) throws IOException {
        boolean replaced = this.addRawLicence(licence);
        this.saveLicences();
        for (LicenceConsumer consumer : this.licenceConsumers) {
            consumer.updateLicenceFromLicenceManager();
        }
        return replaced;
    }

    public RawLicence getRawLicence(Integer appID, Integer majorVersion) {
        Map<Integer, RawLicence> versionmap;
        RawLicence rl = null;
        if (appID != null && this.licences.containsKey(appID) && (versionmap = this.licences.get(appID)).containsKey(majorVersion)) {
            rl = versionmap.get(majorVersion);
        }
        return rl;
    }

    public Map<Integer, RawLicence> getRawLicences(Integer appID) {
        Map<Integer, RawLicence> rl = null;
        if (appID != null && this.licences.containsKey(appID)) {
            rl = this.licences.get(appID);
        }
        return rl;
    }

    public boolean hasRawLicences(Integer appID) {
        Map<Integer, RawLicence> m;
        boolean result = false;
        if (appID != null && this.licences.containsKey(appID) && (m = this.licences.get(appID)) != null) {
            result = true;
        }
        return result;
    }

    public List<RawLicence> getAllLicences() {
        ArrayList<RawLicence> result = new ArrayList<RawLicence>();
        for (Map.Entry<Integer, Map<Integer, RawLicence>> e1 : this.licences.entrySet()) {
            for (Map.Entry<Integer, RawLicence> e2 : e1.getValue().entrySet()) {
                result.add(e2.getValue());
            }
        }
        return result;
    }

    public String getLicenceContainerHash() {
        return this.containerHash;
    }

    public void addConsumer(LicenceConsumer consumer) {
        this.licenceConsumers.add(consumer);
    }

    public void shutdown() {
    }

    private void startWatcher() {
        FileEventCallback monitorCallback = new FileEventCallback(this, "readLicences", null);
        ArrayList<FileEventCallback> cL = new ArrayList<FileEventCallback>();
        cL.add(monitorCallback);
        try {
            this.eventPath = this.fileEventCursor.addPathMonitor(this.licenceFile, cL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

