/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.licensing;

import com.neptunelabs.fsiframework.helpers.HexDumpEncoder;
import com.neptunelabs.fsiframework.licensing.Licence;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Random;

public class MulticastService
extends Thread {
    private final Licence licence;
    private MulticastSocket serverSocket;
    private boolean running = false;
    private static int BASEPORT = 4004;
    private int port = 0;
    private String ip4MulticastAddress = "239.192.80.80";
    private String ip6MulticastAddress = "ffx8::80";
    private int multicastTTL = 16;

    public MulticastService(Licence licence) {
        this.licence = licence;
        this.setDaemon(true);
        this.setName("Server Monitor");
        this.startServer();
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            byte[] buf = new byte[2048];
            DatagramPacket p = new DatagramPacket(buf, buf.length);
            try {
                this.serverSocket.receive(p);
                if (p.getLength() > 0) {
                    byte[] rawPacket = p.getData();
                    byte[] packet = new byte[p.getLength()];
                    System.arraycopy(rawPacket, p.getOffset(), packet, 0, p.getLength());
                    System.err.println("PP:" + packet.length + " " + p.getLength() + " " + p.getOffset());
                }
            }
            catch (IOException rawPacket) {
                // empty catch block
            }
            System.err.println("xxx3");
            HexDumpEncoder hde = new HexDumpEncoder();
            System.err.println(hde.encode(buf));
        }
    }

    public void testForLicence() {
        try {
            InetAddress address = InetAddress.getByName(this.ip4MulticastAddress);
            MulticastSocket socket = new MulticastSocket();
            String msg = "Steve send this message";
            byte[] buf = msg.getBytes();
            DatagramPacket p = new DatagramPacket(buf, buf.length, address, 5001);
            socket.setTimeToLive(this.multicastTTL);
            socket.send(p);
            socket.close();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void halt() {
        this.serverSocket.close();
    }

    private void startServer() {
        try {
            InetAddress address = InetAddress.getByName(this.ip4MulticastAddress);
            this.findPort(address);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    private boolean findPort(InetAddress address) {
        Random portSeed = new Random(0L);
        this.port = BASEPORT;
        int count = 5;
        while (count-- > 0) {
            try {
                this.serverSocket = new MulticastSocket(this.port);
                this.serverSocket.setBroadcast(true);
                this.serverSocket.setTimeToLive(this.multicastTTL);
                this.serverSocket.joinGroup(address);
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.port = portSeed.nextInt(Short.MAX_VALUE) + 1025;
        }
        return this.port != 0;
    }
}

