/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.logging;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.debug.Debug;
import com.neptunelabs.fsiframework.logging.Log4JHandler;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FSILogger
extends Thread {
    private volatile boolean running = true;
    private List<Handler> logHandler = null;
    private Log4JHandler log4jHandler;
    protected boolean encounteredErrors = false;
    protected String lastErrorMessage;
    protected String lastMessage = null;
    protected int lastLogCompileLevel;
    protected volatile int lastMessageCounter = 0;
    protected long maxTimeLogRepeat = 60000L;
    protected long lastMessageTime = 0L;
    protected String lastLoglevel = null;
    protected Object[] lastArgs = null;
    private boolean nelaDebugMode = false;
    protected Properties codeMessages = null;
    private final HashMap<Integer, Pair<Integer, String>> compiledMessages = new HashMap();
    private static final Pattern log4pattern = Pattern.compile("(TRACE|DEBUG|INFO|WARN|ERROR|FATAL|)[:,]?[ ]*(.+)", 2);
    private final BlockingQueue<LogContainer> logQueue = new LinkedBlockingQueue<LogContainer>(1024);

    public FSILogger(Path loggerConfigDir, String name, String codesResource) {
        this.initFSILogger(null, loggerConfigDir, name, codesResource, "log4j", true);
    }

    public FSILogger(Path loggerConfigDir, String name, String codesResource, boolean compile) {
        this.initFSILogger(null, loggerConfigDir, name, codesResource, "log4j", compile);
    }

    public FSILogger(Path loggerConfigDir, String name, String codesResource, String fileName) {
        this.initFSILogger(null, loggerConfigDir, name, codesResource, fileName, true);
    }

    public FSILogger(Path loggerConfigDir, String name, String codesResource, String fileName, boolean compile) {
        this.initFSILogger(null, loggerConfigDir, name, codesResource, fileName, compile);
    }

    public FSILogger(Handler handler, String codesResource) {
        this.initFSILogger(handler, null, null, codesResource, null, true);
    }

    public void addCodes(String codesResource) {
        this.addCodes(codesResource, true);
    }

    public void addCodes(String codesResource, boolean compile) {
        Properties loadedCodeMessages = new Properties();
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream instrm = cl.getResourceAsStream(codesResource);){
            loadedCodeMessages.load(instrm);
        }
        catch (Exception ioe) {
            this.logLoggerError("Logging not properly initializied - codes missing.");
        }
        if (this.codeMessages == null) {
            this.codeMessages = new Properties();
        }
        this.codeMessages.putAll((Map<?, ?>)loadedCodeMessages);
        if (compile) {
            this.compileLogCodes(loadedCodeMessages, codesResource);
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                LogContainer logMessage = this.logQueue.take();
                if (logMessage.type == LogType.LOG) {
                    this.logAsync(logMessage.code, logMessage.args);
                    continue;
                }
                if (logMessage.type != LogType.LOGACCESS) continue;
                this.logAccessAsync(logMessage.host, logMessage.user, logMessage.code, logMessage.args);
            }
            catch (InterruptedException e) {
                this.running = false;
            }
        }
    }

    public boolean hasNeLaDebug() {
        return this.nelaDebugMode;
    }

    private void initFSILogger(Handler handler, Path loggerConfigDir, String name, String codesResource, String fileName, boolean compile) {
        this.setDaemon(true);
        this.setPriority(1);
        this.setName("Logger " + name);
        boolean pass = false;
        if (Boolean.valueOf(System.getProperty("com.neptunelabs.devmode", "false")).booleanValue()) {
            this.nelaDebugMode = true;
        }
        if (handler != null) {
            if (this.logHandler == null) {
                this.logHandler = new ArrayList<Handler>();
            }
            this.logHandler.add(handler);
            pass = true;
        } else if (name != null && codesResource != null) {
            this.log4jHandler = new Log4JHandler(this, name, loggerConfigDir, fileName);
            pass = true;
        }
        if (codesResource != null) {
            this.addCodes(codesResource, compile);
        }
        if (!pass) {
            if (loggerConfigDir != null) {
                System.err.println("Missing log4j.xml or log4j.properties file in " + loggerConfigDir.toAbsolutePath());
            } else {
                System.err.println("No logger config directory given");
            }
            System.err.println("Will log to system error console instead.");
        }
    }

    public void addHandler(Handler handler) {
        if (this.logHandler == null) {
            this.logHandler = new ArrayList<Handler>();
        }
        this.logHandler.add(handler);
    }

    public void logAccess(String host, String user, int code, Object ... args) {
        if (this.isAlive()) {
            LogContainer lc = new LogContainer();
            lc.type = LogType.LOGACCESS;
            lc.host = host;
            lc.user = user;
            lc.code = code;
            lc.args = args;
            try {
                this.logQueue.put(lc);
            }
            catch (InterruptedException e) {
                this.logAccessAsync(host, user, code, args);
            }
        } else {
            this.logAccessAsync(host, user, code, args);
        }
    }

    public void log(int code, Object ... args) {
        if (this.isAlive()) {
            LogContainer lc = new LogContainer();
            lc.type = LogType.LOG;
            lc.code = code;
            lc.args = args;
            try {
                this.logQueue.put(lc);
            }
            catch (InterruptedException e) {
                this.logAsync(code, args);
            }
        } else {
            this.logAsync(code, args);
        }
    }

    public void logException(Exception e, int code, Object ... args) {
        this.log(code, args);
        if (e != null && (this.log4jHandler != null && this.log4jHandler.isTraceEnabled() || this.nelaDebugMode)) {
            System.err.println("Debug StackTrace:");
            e.printStackTrace();
        }
    }

    public void logError(Error e, int code, Object ... args) {
        this.log(code, args);
        if (e != null && (this.log4jHandler != null && this.log4jHandler.isTraceEnabled() || this.nelaDebugMode)) {
            System.err.println("Debug StackTrace:");
            e.printStackTrace();
        }
    }

    private void logAccessAsync(String host, String user, int code, Object ... args) {
        if (this.log4jHandler != null) {
            this.log4jHandler.logAccessAsync(host, user, code, args);
        } else {
            this.logLoggerError("Logging with log4j not initialized");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logAsync(int code, Object ... args) {
        if (this.codeMessages == null) {
            System.err.println("Logger not initialized");
            return;
        } else if (this.compiledMessages.containsKey(code)) {
            Pair<Integer, String> levelMessage = this.compiledMessages.get(code);
            Integer level = levelMessage.getItem1();
            String rawMessage = levelMessage.getItem2();
            if (this.logHandler != null) {
                for (Handler handler : this.logHandler) {
                    String message = String.format(rawMessage, args);
                    LogRecord record = new LogRecord(FSILogger.log4jIntLevel2LoggingLevel(level), message);
                    handler.publish(record);
                }
                return;
            } else if (this.log4jHandler == null) {
                String message = String.format(rawMessage, args);
                System.err.println(message);
                return;
            } else {
                if (this.log4jHandler == null || !this.log4jHandler.levelIsEnabled(level)) return;
                this.log4jHandler.log(level, rawMessage, code, args);
            }
            return;
        } else {
            String messageFormat = this.codeMessages.getProperty(Integer.toString(code));
            if (messageFormat == null) {
                this.logLoggerError("Unknown log code number " + code);
                Debug.printStackTrace();
                return;
            } else {
                Matcher log4matcher = log4pattern.matcher(messageFormat);
                if (!log4matcher.find()) {
                    this.logLoggerError("Unknown log code number " + code);
                    return;
                } else {
                    String loglevelstr = log4matcher.group(1);
                    String logmessage = log4matcher.group(2);
                    try {
                        String message = String.format(logmessage, args);
                        if (this.logHandler != null) {
                            for (Handler handler : this.logHandler) {
                                LogRecord record = new LogRecord(FSILogger.getLoggingLevel(loglevelstr.toUpperCase()), message);
                                handler.publish(record);
                            }
                            return;
                        }
                        if (this.log4jHandler == null) {
                            System.err.println(message);
                            return;
                        }
                        if (this.log4jHandler == null) return;
                        this.log4jHandler.logAsync(message, loglevelstr, code, args);
                        return;
                    }
                    catch (IllegalFormatException e) {
                        this.logLoggerError(e.getLocalizedMessage() + " (" + code + " " + logmessage + ")");
                        return;
                    }
                    catch (Exception e) {
                        this.logLoggerError("Error while logging code " + code);
                    }
                }
            }
        }
    }

    public String getLogMessage(int code, Object ... args) {
        String message = "";
        try {
            String messageFormat = this.codeMessages.getProperty(Integer.toString(code));
            if (messageFormat != null) {
                Matcher log4matcher = log4pattern.matcher(messageFormat);
                if (log4matcher.find()) {
                    String logmessage = log4matcher.group(2);
                    message = String.format(logmessage, args).trim();
                }
            } else {
                this.logLoggerError("Unknown log code number " + code);
            }
        }
        catch (Exception e) {
            System.err.println("Exception while logging: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        return message;
    }

    public boolean encounteredErrors() {
        return this.encounteredErrors;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void resetErrorStatus() {
        this.encounteredErrors = false;
        this.lastErrorMessage = null;
    }

    public boolean isTraceEnabled() {
        if (this.log4jHandler != null) {
            return this.log4jHandler.isTraceEnabled();
        }
        return false;
    }

    public boolean isDebugEnabled() {
        if (this.log4jHandler != null) {
            return this.log4jHandler.isDebugEnabled();
        }
        return false;
    }

    public boolean isInfoEnabled() {
        if (this.log4jHandler != null) {
            return this.log4jHandler.isInfoEnabled();
        }
        return false;
    }

    public void setMaxRepeatTime(int value) {
        this.maxTimeLogRepeat = value;
    }

    public void shutdown() {
        LogContainer logMessage;
        this.running = false;
        this.interrupt();
        while ((logMessage = (LogContainer)this.logQueue.poll()) != null) {
            if (logMessage.type == LogType.LOG) {
                this.logAsync(logMessage.code, logMessage.args);
                continue;
            }
            if (logMessage.type != LogType.LOGACCESS) continue;
            this.logAccessAsync(logMessage.host, logMessage.user, logMessage.code, logMessage.args);
        }
        if (this.log4jHandler != null) {
            this.log4jHandler.shutdown();
        }
    }

    private void logLoggerError(String message) {
        if (this.log4jHandler != null) {
            this.log4jHandler.error(message);
        } else {
            System.err.println(message);
        }
    }

    private void compileLogCodes(Properties newCodeMessages, String orgFile) {
        if (newCodeMessages != null) {
            for (Map.Entry<Object, Object> entry : newCodeMessages.entrySet()) {
                String rawCode = (String)entry.getKey();
                String rawMessage = (String)entry.getValue();
                Matcher log4matcher = log4pattern.matcher(rawMessage);
                if (log4matcher.find()) {
                    String loglevelstr = log4matcher.group(1);
                    String logmessage = log4matcher.group(2);
                    try {
                        Integer logLevelInt = this.getLogLevelInt(loglevelstr.toUpperCase());
                        Pair<Integer, String> pair = new Pair<Integer, String>(logLevelInt, logmessage);
                        this.compiledMessages.put(Integer.valueOf(rawCode), pair);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid Log Code: " + rawCode + " in " + orgFile);
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("Invalid Log Level: " + loglevelstr + " (" + rawMessage + " in " + orgFile + ")");
                    }
                    continue;
                }
                System.err.println("Log Entry: " + rawMessage + " in " + orgFile);
            }
        }
    }

    static boolean compareArgs(Object[] args1, Object[] args2) {
        boolean result;
        if (args1 != null && args2 != null) {
            if (args1.length == args2.length) {
                result = true;
                for (int p = 0; p < args1.length; ++p) {
                    if (args1[p] == null || args2[p] == null || args1[p].hashCode() == args2[p].hashCode()) continue;
                    result = false;
                    break;
                }
            } else {
                result = false;
            }
        } else {
            result = args1 == null && args2 == null;
        }
        return result;
    }

    private static Level getLoggingLevel(String level4JStr) {
        Level result = level4JStr.equals("OFF") ? Level.OFF : (level4JStr.equals("FATAL") ? Level.SEVERE : (level4JStr.equals("ERROR") ? Level.SEVERE : (level4JStr.equals("WARN") ? Level.WARNING : (level4JStr.equals("DEBUG") ? Level.FINE : (level4JStr.equals("TRACE") ? Level.FINER : (level4JStr.equals("ALL") ? Level.ALL : Level.INFO))))));
        return result;
    }

    private static Level log4jIntLevel2LoggingLevel(int level) {
        Level result = level == Integer.MIN_VALUE ? Level.ALL : (level == Integer.MAX_VALUE ? Level.OFF : (level == 10000 ? Level.FINE : (level == 5000 ? Level.FINER : (level == 40000 ? Level.SEVERE : (level == 50000 ? Level.SEVERE : (level == 20000 ? Level.INFO : Level.WARNING))))));
        return result;
    }

    private int getLogLevelInt(String loglevelstr) {
        int result = 0;
        if (loglevelstr.equalsIgnoreCase("T") || loglevelstr.equalsIgnoreCase("TRACE")) {
            result = 5000;
        } else if (loglevelstr.equalsIgnoreCase("D") || loglevelstr.equalsIgnoreCase("DEBUG")) {
            result = 10000;
        } else if (loglevelstr.equalsIgnoreCase("I") || loglevelstr.equalsIgnoreCase("INFO")) {
            result = 20000;
        } else if (loglevelstr.equalsIgnoreCase("W") || loglevelstr.equalsIgnoreCase("WARN")) {
            result = 30000;
        } else if (loglevelstr.equalsIgnoreCase("E") || loglevelstr.equalsIgnoreCase("ERROR")) {
            result = 40000;
        } else if (loglevelstr.equalsIgnoreCase("F") || loglevelstr.equalsIgnoreCase("FATAL")) {
            result = 50000;
        }
        return result;
    }

    boolean levelIsEnabled(int level) {
        boolean result = false;
        if (this.log4jHandler != null) {
            result = this.log4jHandler.levelIsEnabled(level);
        }
        return result;
    }

    private class LogContainer {
        LogType type;
        int code;
        String host;
        String user;
        Object[] args;
    }

    private static enum LogType {
        LOG,
        LOGACCESS;

    }
}

