/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.logging;

import com.neptunelabs.fsiframework.logging.FSILogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.MissingFormatArgumentException;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

class Log4JHandler {
    private Logger log4jLogger = null;
    private final FSILogger fsilogger;
    private Level effectiveLevel = null;

    Log4JHandler(FSILogger fsilogger, String name, Path loggerConfigDir, String fileName) {
        this.fsilogger = fsilogger;
        boolean pass = false;
        if (loggerConfigDir != null && fileName != null) {
            Path propertiesfile;
            Path xmlfile = loggerConfigDir.resolve(fileName + ".xml");
            if (Files.isReadable(xmlfile) && Files.isRegularFile(xmlfile, new LinkOption[0])) {
                try {
                    DOMConfigurator.configure((String)xmlfile.toAbsolutePath().toString());
                    pass = true;
                }
                catch (AccessControlException e) {
                    System.err.println("Logging not properly initializied - could not read " + xmlfile);
                }
                catch (FactoryConfigurationError e) {
                    System.err.println("Logging not properly initializied - could not read " + xmlfile);
                }
                catch (NullPointerException e) {
                    System.err.println("Logging not properly initializied - could not read " + xmlfile);
                }
                catch (Exception e) {
                    System.err.println("Logging not properly initializied - " + e.getLocalizedMessage());
                }
            }
            if (!pass && Files.isReadable(propertiesfile = loggerConfigDir.resolve(fileName + ".properties")) && Files.isRegularFile(propertiesfile, new LinkOption[0])) {
                try {
                    PropertyConfigurator.configure((String)propertiesfile.toAbsolutePath().toString());
                    pass = true;
                }
                catch (AccessControlException e) {
                    System.err.println("Logging not properly initializied - could not read " + propertiesfile.toAbsolutePath().toString());
                }
            }
            this.log4jLogger = Logger.getLogger((String)name);
            this.effectiveLevel = this.log4jLogger.getEffectiveLevel();
        }
    }

    boolean isTraceEnabled() {
        return this.log4jLogger.isTraceEnabled();
    }

    boolean isDebugEnabled() {
        return this.log4jLogger.isDebugEnabled();
    }

    boolean isInfoEnabled() {
        return this.log4jLogger.isInfoEnabled();
    }

    boolean levelIsEnabled(int level) {
        if (this.effectiveLevel != null) {
            return Level.toLevel((int)level).isGreaterOrEqual((Priority)this.effectiveLevel);
        }
        return false;
    }

    void log(int level, String rawMessage, int code, Object ... args) {
        if (level == this.fsilogger.lastLogCompileLevel && rawMessage.equals(this.fsilogger.lastMessage) && FSILogger.compareArgs(args, this.fsilogger.lastArgs) && System.currentTimeMillis() - this.fsilogger.lastMessageTime < this.fsilogger.maxTimeLogRepeat) {
            ++this.fsilogger.lastMessageCounter;
            this.fsilogger.lastMessageTime = System.currentTimeMillis();
        } else {
            if (this.fsilogger.lastMessageCounter > 1) {
                this.log4jLogger.log((Priority)Level.toLevel((int)this.fsilogger.lastLogCompileLevel), (Object)("Last message repeated " + (this.fsilogger.lastMessageCounter - 1) + " times."));
            }
            boolean send = false;
            try {
                String message = String.format(rawMessage, args);
                if (message != null) {
                    if (level == 5000 && this.log4jLogger.isTraceEnabled()) {
                        MDC.put((String)"code", (Object)code);
                        this.log4jLogger.trace((Object)message);
                        send = true;
                    } else if (level == 10000 && this.log4jLogger.isDebugEnabled()) {
                        MDC.put((String)"code", (Object)code);
                        this.log4jLogger.debug((Object)message);
                        send = true;
                    } else if (level == 20000 && this.log4jLogger.isInfoEnabled()) {
                        MDC.put((String)"code", (Object)code);
                        this.log4jLogger.info((Object)message);
                        send = true;
                    } else if (level == 30000 && this.log4jLogger.isEnabledFor((Priority)Level.WARN)) {
                        MDC.put((String)"code", (Object)code);
                        this.log4jLogger.warn((Object)message);
                        send = true;
                    } else if (level == 40000 && this.log4jLogger.isEnabledFor((Priority)Level.ERROR)) {
                        MDC.put((String)"code", (Object)code);
                        this.log4jLogger.error((Object)message);
                        this.fsilogger.encounteredErrors = true;
                        this.fsilogger.lastErrorMessage = message;
                        send = true;
                    } else if (level == 50000 && this.log4jLogger.isEnabledFor((Priority)Level.FATAL)) {
                        MDC.put((String)"code", (Object)code);
                        this.log4jLogger.fatal((Object)message);
                        this.fsilogger.encounteredErrors = true;
                        this.fsilogger.lastErrorMessage = message;
                        send = true;
                    }
                } else {
                    System.err.println("Wrong Message: " + rawMessage);
                }
            }
            catch (MissingFormatArgumentException mfe) {
                System.err.println("Error formatting message for log code: " + code + ": " + mfe.getMessage());
            }
            if (send) {
                this.fsilogger.lastMessageCounter = 1;
                this.fsilogger.lastMessage = rawMessage;
                this.fsilogger.lastMessageTime = System.currentTimeMillis();
                this.fsilogger.lastLogCompileLevel = level;
                this.fsilogger.lastArgs = args;
            }
        }
    }

    void logAsync(String message, String loglevelstr, int code, Object ... args) throws InvocationTargetException, IllegalAccessException {
        if (message.equals(this.fsilogger.lastMessage)) {
            ++this.fsilogger.lastMessageCounter;
        } else {
            String loglevelName;
            if (this.fsilogger.lastMessageCounter > 1) {
                Method repeatedMethod = this.getLogMethod(this.fsilogger.lastLoglevel);
                repeatedMethod.invoke((Object)this.log4jLogger, "Last message repeated " + (this.fsilogger.lastMessageCounter - 1) + " times.");
            }
            this.fsilogger.lastMessageCounter = 1;
            this.fsilogger.lastMessage = message;
            this.fsilogger.lastLoglevel = loglevelName = this.getLogLevelName(loglevelstr);
            Method logMethod = this.getLogMethod(loglevelName);
            MDC.put((String)"code", (Object)code);
            logMethod.invoke((Object)this.log4jLogger, message);
            if (loglevelName.equals("error") || loglevelName.equals("fatal")) {
                this.fsilogger.encounteredErrors = true;
                this.fsilogger.lastErrorMessage = message;
            }
        }
    }

    void logAccessAsync(String host, String user, int code, Object ... args) {
        Method logMethod = this.getLogMethod("info");
        MDC.put((String)"code", (Object)code);
        if (host != null) {
            MDC.put((String)"ip", (Object)host);
        } else {
            MDC.put((String)"ip", (Object)"-");
        }
        if (user != null) {
            MDC.put((String)"user", (Object)user);
        } else {
            MDC.put((String)"user", (Object)"-");
        }
        String logmessage = this.fsilogger.codeMessages.getProperty(Integer.toString(code));
        if (logmessage == null) {
            logmessage = "Unknown logging code " + code;
        }
        String message = String.format(logmessage, args).trim();
        try {
            logMethod.invoke((Object)this.log4jLogger, message);
        }
        catch (Exception e) {
            this.logLoggerError("Error while logging code " + message + (e.getLocalizedMessage() != null ? " " + e.getLocalizedMessage() : "(" + this.log4jLogger + ")"));
        }
    }

    private Method getLogMethod(String loglevelName) {
        Method result = null;
        if (loglevelName != null) {
            try {
                result = this.log4jLogger.getClass().getMethod(loglevelName, new Object().getClass());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return result;
    }

    private void logLoggerError(String message) {
        if (this.log4jLogger != null) {
            this.log4jLogger.error((Object)message);
        } else {
            System.err.println(message);
        }
    }

    void warn(Object message) {
        this.log4jLogger.warn(message);
    }

    void error(Object message) {
        this.log4jLogger.error(message);
    }

    void shutdown() {
        Appender app;
        Enumeration appenum = this.log4jLogger.getAllAppenders();
        if (appenum.hasMoreElements() && !((app = (Appender)appenum.nextElement()) instanceof ConsoleAppender)) {
            app.close();
        }
        MDC.clear();
    }

    private String getLogLevelName(String loglevelstr) {
        String result = null;
        if (loglevelstr.equalsIgnoreCase("T") || loglevelstr.equalsIgnoreCase("TRACE")) {
            result = "trace";
        } else if (loglevelstr.equalsIgnoreCase("D") || loglevelstr.equalsIgnoreCase("DEBUG")) {
            result = "debug";
        } else if (loglevelstr.equalsIgnoreCase("I") || loglevelstr.equalsIgnoreCase("INFO")) {
            result = "info";
        } else if (loglevelstr.equalsIgnoreCase("W") || loglevelstr.equalsIgnoreCase("WARN")) {
            result = "warn";
        } else if (loglevelstr.equalsIgnoreCase("E") || loglevelstr.equalsIgnoreCase("ERROR")) {
            result = "error";
        } else if (loglevelstr.equalsIgnoreCase("F") || loglevelstr.equalsIgnoreCase("FATAL")) {
            result = "fatal";
        }
        if (result == null) {
            this.logLoggerError("Invalid log-level for following message - using ERROR level");
            result = "error";
        }
        return result;
    }
}

