/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.mail;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiframework.mail.SMTPAuthenticator;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public final class SMTPMailer {
    private static final String MAILER = "NeptuneLabs Application Mailer";
    private final FSILogger logger;
    private final String mailhost;
    private final int mailport;
    private Authenticator auth = null;
    private final Properties props;
    private boolean mailhostEmpty = false;
    private InternetAddress fromID = null;
    private String subject = null;
    private MimeBodyPart textMessage = null;
    private MimeBodyPart htmlMessage = null;
    private final ArrayList<InternetAddress> toList = new ArrayList();
    private final ArrayList<InternetAddress> ccList = new ArrayList();
    private final ArrayList<InternetAddress> bccList = new ArrayList();

    public SMTPMailer(FSILogger logger, String mailhost, int mailport, String mailuser, String mailpass) {
        this.logger = logger;
        this.mailhost = mailhost;
        this.mailport = mailport;
        this.props = System.getProperties();
        this.props.put("mail.transport.protocol", "smtp");
        this.auth = null;
        if (!mailuser.equals("") && !mailpass.equals("")) {
            this.auth = new SMTPAuthenticator(mailuser, mailpass);
            this.props.put("mail.smtp.auth", "true");
        }
        if (this.mailhost == null || this.mailhost.equals("")) {
            this.mailhostEmpty = true;
        }
    }

    public void setFrom(String name, String from) {
        try {
            if (from != null && !from.equals("")) {
                this.logger.log(1010, "From", from);
                this.fromID = new InternetAddress(from, false);
                if (name != null && !name.equals("")) {
                    this.fromID.setPersonal(name);
                }
            }
        }
        catch (MessagingException e) {
            this.logger.log(1009, new Object[]{"From Address", e});
        }
        catch (UnsupportedEncodingException e) {
            this.logger.log(1009, "From Address", e);
        }
    }

    public void setSubject(String subject) {
        if (subject != null && !subject.equals("")) {
            this.subject = subject;
        }
    }

    public void setTextMsg(String message, boolean striptags) {
        if (striptags) {
            Pattern pat = Pattern.compile("<body>(.+)</body>", 42);
            Matcher mat = pat.matcher(message);
            if (mat.find()) {
                message = mat.group(1);
            }
            message = message.replaceAll("<a .*href.+\"(.+)\">.+</a>", "\\1");
            message = message.replaceAll("<([^>]+)>", "");
        }
        this.textMessage = new MimeBodyPart();
        try {
            this.textMessage.setContent((Object)message, "text/plain");
        }
        catch (MessagingException e) {
            this.logger.log(1009, new Object[]{"Build Message", e});
        }
    }

    public void setHTMLMsg(String message) {
        this.htmlMessage = new MimeBodyPart();
        try {
            this.htmlMessage.setContent((Object)message, "text/html");
        }
        catch (MessagingException e) {
            this.logger.log(1009, new Object[]{"Build Message", e});
        }
    }

    public void addTo(String name, String to) {
        try {
            InternetAddress id = new InternetAddress(to.trim(), false);
            if (name != null && !name.equals("")) {
                id.setPersonal(name.trim());
            }
            this.toList.add(id);
            this.logger.log(1010, "To Address", to);
        }
        catch (AddressException e) {
            this.logger.log(1009, new Object[]{"To Address", e});
        }
        catch (UnsupportedEncodingException e) {
            this.logger.log(1009, "To Address", e);
        }
    }

    public void addCC(String name, String cc) {
        if (!this.mailhostEmpty) {
            try {
                InternetAddress id = new InternetAddress(cc.trim(), false);
                if (name != null && !name.equals("")) {
                    id.setPersonal(name.trim());
                }
                this.ccList.add(id);
                this.logger.log(1010, "CC Address", cc);
            }
            catch (AddressException e) {
                this.logger.log(1009, new Object[]{"CC Address", e});
            }
            catch (UnsupportedEncodingException e) {
                this.logger.log(1009, "CC Address", e);
            }
        } else {
            this.logger.log(1011, "carbon copy (cc)");
        }
    }

    public void addBCC(String name, String bcc) {
        if (!this.mailhostEmpty) {
            try {
                InternetAddress id = new InternetAddress(bcc.trim(), false);
                if (name != null && !name.equals("")) {
                    id.setPersonal(name.trim());
                }
                this.bccList.add(id);
                this.logger.log(1010, "BCC Address", bcc);
            }
            catch (AddressException e) {
                this.logger.log(1009, new Object[]{"BCC Address", e});
            }
            catch (UnsupportedEncodingException e) {
                this.logger.log(1009, "BCC Address", e);
            }
        } else {
            this.logger.log(1011, "blind carbon copy (bcc)");
        }
    }

    public boolean send() {
        boolean ret = false;
        Session session = this.auth != null ? Session.getInstance((Properties)this.props, (Authenticator)this.auth) : Session.getInstance((Properties)this.props, null);
        MimeMessage msg = new MimeMessage(session);
        try {
            this.prepareMessage(msg);
            if (this.mailport > 0) {
                this.props.put("mail.smtp.port", (Object)this.mailport);
            }
            if (!this.mailhostEmpty) {
                this.props.put("mail.smtp.host", this.mailhost);
                if (this.toList.size() > 0) {
                    msg.setRecipients(Message.RecipientType.TO, (Address[])this.toList.toArray(new InternetAddress[0]));
                }
                if (this.ccList.size() > 0) {
                    msg.setRecipients(Message.RecipientType.CC, (Address[])this.ccList.toArray(new InternetAddress[0]));
                }
                if (this.bccList.size() > 0) {
                    msg.setRecipients(Message.RecipientType.BCC, (Address[])this.bccList.toArray(new InternetAddress[0]));
                }
                ret = this.sendMessage(msg);
            } else {
                String mxhost;
                HashMap<InternetAddress, String> receivers = new HashMap<InternetAddress, String>();
                if (this.toList.size() > 0) {
                    for (InternetAddress internetAddress : this.toList) {
                        mxhost = this.getMXHost(internetAddress);
                        if (mxhost == null) continue;
                        receivers.put(internetAddress, mxhost);
                    }
                }
                if (this.ccList.size() > 0) {
                    for (InternetAddress internetAddress : this.toList) {
                        mxhost = this.getMXHost(internetAddress);
                        if (mxhost == null) continue;
                        receivers.put(internetAddress, mxhost);
                    }
                }
                if (this.bccList.size() > 0) {
                    for (InternetAddress internetAddress : this.toList) {
                        mxhost = this.getMXHost(internetAddress);
                        if (mxhost == null) continue;
                        receivers.put(internetAddress, mxhost);
                    }
                }
                for (Map.Entry entry : receivers.entrySet()) {
                    String hostname = (String)entry.getValue();
                    this.props.put("mail.smtp.host", hostname);
                    msg.setRecipient(Message.RecipientType.TO, (Address)entry.getKey());
                    ret = this.sendMessage(msg);
                }
            }
        }
        catch (MessagingException e) {
            this.logger.log(1009, new Object[]{"failed " + this.mailhost + ":" + this.mailport, e});
        }
        return ret;
    }

    private String getMXHost(InternetAddress iaddr) {
        int pos;
        String mxhost = null;
        String email = iaddr.getAddress();
        if (email != null && (pos = email.indexOf("@")) != -1 && pos < email.length()) {
            String emailhost = email.substring(pos + 1);
            try {
                Pattern pat;
                Matcher mat;
                InitialDirContext ictx = new InitialDirContext();
                Attributes attributes = ictx.getAttributes("dns:/" + emailhost, new String[]{"MX"});
                Attribute attr = attributes.get("MX");
                String record = (String)attr.get();
                if (record != null && (mat = (pat = Pattern.compile("\\d*\\s*([\\w\\.\\-]+)")).matcher(record)).find() && (mxhost = mat.group(1)).endsWith(".")) {
                    mxhost = mxhost.substring(0, mxhost.length() - 1);
                }
            }
            catch (NamingException e) {
                this.logger.log(1009, "failed " + mxhost, e);
            }
        }
        return mxhost;
    }

    private void prepareMessage(MimeMessage msg) throws MessagingException {
        msg.setHeader("X-Mailer", MAILER);
        if (this.fromID != null) {
            msg.setFrom((Address)this.fromID);
        }
        if (this.subject != null) {
            msg.setSubject(this.subject);
        }
        MimeMultipart multipartBody = new MimeMultipart("alternative");
        if (this.textMessage != null) {
            multipartBody.addBodyPart((BodyPart)this.textMessage);
        }
        if (this.htmlMessage != null) {
            multipartBody.addBodyPart((BodyPart)this.htmlMessage);
        }
        MimeBodyPart mbpBody = new MimeBodyPart();
        mbpBody.setContent((Multipart)multipartBody);
        MimeMultipart multipart1 = new MimeMultipart("related");
        multipart1.addBodyPart((BodyPart)mbpBody);
        msg.setContent((Multipart)multipart1);
        msg.setSentDate(new Date());
    }

    private boolean sendMessage(MimeMessage msg) throws MessagingException {
        boolean ret = false;
        Transport.send((Message)msg);
        String id = msg.getMessageID();
        if (id != null) {
            ret = true;
        }
        return ret;
    }
}

