/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.security;

import java.util.Arrays;

public final class BytesToAscii64 {
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+*".toCharArray();
    private static final char FILL = '.';
    private static final int[] IA = new int[256];

    public static final String encode(byte[] sArr) {
        return new String(BytesToAscii64.encodeToChar(sArr));
    }

    private static final char[] encodeToChar(byte[] sArr) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0 || sArr == null) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int dLen = (sLen - 1) / 3 + 1 << 2;
        char[] dArr = new char[dLen];
        int s = 0;
        int d = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = CA[i >>> 18 & 0x3F];
            dArr[d++] = CA[i >>> 12 & 0x3F];
            dArr[d++] = CA[i >>> 6 & 0x3F];
            dArr[d++] = CA[i & 0x3F];
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = CA[i >> 12];
            dArr[dLen - 3] = CA[i >>> 6 & 0x3F];
            dArr[dLen - 2] = left == 2 ? CA[i & 0x3F] : 46;
            dArr[dLen - 1] = 46;
        }
        return dArr;
    }

    public static final byte[] decode(String s) {
        int sIx;
        int sLen = s.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[s.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[s.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = s.charAt(eIx) == '.' ? (s.charAt(eIx - 1) == '.' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (s.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[s.charAt(sIx++)] << 18 | IA[s.charAt(sIx++)] << 12 | IA[s.charAt(sIx++)] << 6 | IA[s.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[s.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (int i = 0; i < iS; ++i) {
            BytesToAscii64.IA[BytesToAscii64.CA[i]] = i;
        }
        BytesToAscii64.IA[46] = 0;
    }
}

