/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.security;

import com.neptunelabs.fsiframework.security.Sha160;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class DigestUtils {
    private static MessageDigest sha256Algorithm = null;

    public static byte[] sha256Raw(byte[] data) {
        if (data != null) {
            try {
                if (sha256Algorithm == null) {
                    sha256Algorithm = MessageDigest.getInstance("SHA-256");
                }
                return sha256Algorithm.digest(data);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] sha256Raw(String data, Charset charset) {
        if (data != null) {
            try {
                if (sha256Algorithm == null) {
                    sha256Algorithm = MessageDigest.getInstance("SHA-256");
                }
                return sha256Algorithm.digest(data.getBytes(charset));
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String sha256(byte[] data) {
        byte[] rawhash = DigestUtils.sha256Raw(data);
        if (rawhash != null) {
            return DigestUtils.byteArrayToHexString(rawhash);
        }
        return null;
    }

    public static String sha256(String data, Charset charset) {
        byte[] rawhash = DigestUtils.sha256Raw(data, charset);
        if (rawhash != null) {
            return DigestUtils.byteArrayToHexString(rawhash);
        }
        return data;
    }

    public static String sha160Hex(byte[] bytes) {
        Sha160 sha = new Sha160();
        byte[] result = sha.digest(bytes);
        return DigestUtils.byteArrayToHexString(result);
    }

    public static String smartPasswordGenerator(int length) {
        Random rand = new Random();
        StringBuilder sb = new StringBuilder();
        int c = 0;
        while (c < length) {
            int x = rand.nextInt(123);
            if (x >= 50 && x <= 57) {
                sb.append((char)x);
                ++c;
                continue;
            }
            if (x >= 97 && x <= 104) {
                sb.append((char)x);
                ++c;
                continue;
            }
            if (x >= 106 && x <= 107) {
                sb.append((char)x);
                ++c;
                continue;
            }
            if (x < 109 || x > 122) continue;
            sb.append((char)x);
            ++c;
        }
        return sb.toString();
    }

    private static String byteArrayToHexString(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

