/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.security;

public final class RipeMD160 {
    private static final int BLOCK_SIZE = 64;
    private long count = 0L;
    private final byte[] buffer;
    private static final int[] R = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2, 4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13};
    private static final int[] Rp = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14, 12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11};
    private static final int[] S = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6};
    private static final int[] Sp = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11};
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private final int[] X = new int[16];

    public RipeMD160() {
        this.buffer = new byte[64];
    }

    public void update(byte b) {
        int i = (int)(this.count % 64L);
        ++this.count;
        this.buffer[i] = b;
        if (i == 63) {
            this.transform(this.buffer, 0);
        }
    }

    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int offset, int len) {
        int n = (int)(this.count % 64L);
        this.count += (long)len;
        int partLen = 64 - n;
        int i = 0;
        if (len >= partLen) {
            System.arraycopy(b, offset, this.buffer, n, partLen);
            this.transform(this.buffer, 0);
            i = partLen;
            while (i + 64 - 1 < len) {
                this.transform(b, offset + i);
                i += 64;
            }
            n = 0;
        }
        if (i < len) {
            System.arraycopy(b, offset + i, this.buffer, n, len - i);
        }
    }

    public byte[] digest(byte[] b) {
        this.update(b);
        return this.digest();
    }

    public byte[] digest() {
        byte[] tail = this.padBuffer();
        this.update(tail, 0, tail.length);
        byte[] result = this.getResult();
        this.reset();
        return result;
    }

    public void reset() {
        this.count = 0L;
        int i = 0;
        while (i < 64) {
            this.buffer[i++] = 0;
        }
        this.resetContext();
    }

    private void transform(byte[] in, int offset) {
        int T;
        int s;
        int Ep;
        int Dp;
        int Cp;
        int Bp;
        int Ap;
        int i;
        for (i = 0; i < 16; ++i) {
            this.X[i] = in[offset++] & 0xFF | (in[offset++] & 0xFF) << 8 | (in[offset++] & 0xFF) << 16 | in[offset++] << 24;
        }
        int A = Ap = this.h0;
        int B = Bp = this.h1;
        int C = Cp = this.h2;
        int D = Dp = this.h3;
        int E = Ep = this.h4;
        for (i = 0; i < 16; ++i) {
            s = S[i];
            T = A + (B ^ C ^ D) + this.X[i];
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + (Bp ^ (Cp | ~Dp)) + this.X[Rp[i]] + 1352829926;
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
        }
        while (i < 32) {
            s = S[i];
            T = A + (B & C | ~B & D) + this.X[R[i]] + 1518500249;
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + (Bp & Dp | Cp & ~Dp) + this.X[Rp[i]] + 1548603684;
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
            ++i;
        }
        while (i < 48) {
            s = S[i];
            T = A + ((B | ~C) ^ D) + this.X[R[i]] + 1859775393;
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + ((Bp | ~Cp) ^ Dp) + this.X[Rp[i]] + 1836072691;
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
            ++i;
        }
        while (i < 64) {
            s = S[i];
            T = A + (B & D | C & ~D) + this.X[R[i]] + -1894007588;
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + (Bp & Cp | ~Bp & Dp) + this.X[Rp[i]] + 2053994217;
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
            ++i;
        }
        while (i < 80) {
            s = S[i];
            T = A + (B ^ (C | ~D)) + this.X[R[i]] + -1454113458;
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + (Bp ^ Cp ^ Dp) + this.X[Rp[i]];
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
            ++i;
        }
        T = this.h1 + C + Dp;
        this.h1 = this.h2 + D + Ep;
        this.h2 = this.h3 + E + Ap;
        this.h3 = this.h4 + A + Bp;
        this.h4 = this.h0 + B + Cp;
        this.h0 = T;
    }

    private byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int padding = n < 56 ? 56 - n : 120 - n;
        byte[] result = new byte[padding + 8];
        result[0] = -128;
        long bits = this.count << 3;
        result[padding++] = (byte)bits;
        result[padding++] = (byte)(bits >>> 8);
        result[padding++] = (byte)(bits >>> 16);
        result[padding++] = (byte)(bits >>> 24);
        result[padding++] = (byte)(bits >>> 32);
        result[padding++] = (byte)(bits >>> 40);
        result[padding++] = (byte)(bits >>> 48);
        result[padding] = (byte)(bits >>> 56);
        return result;
    }

    private byte[] getResult() {
        return new byte[]{(byte)this.h0, (byte)(this.h0 >>> 8), (byte)(this.h0 >>> 16), (byte)(this.h0 >>> 24), (byte)this.h1, (byte)(this.h1 >>> 8), (byte)(this.h1 >>> 16), (byte)(this.h1 >>> 24), (byte)this.h2, (byte)(this.h2 >>> 8), (byte)(this.h2 >>> 16), (byte)(this.h2 >>> 24), (byte)this.h3, (byte)(this.h3 >>> 8), (byte)(this.h3 >>> 16), (byte)(this.h3 >>> 24), (byte)this.h4, (byte)(this.h4 >>> 8), (byte)(this.h4 >>> 16), (byte)(this.h4 >>> 24)};
    }

    private void resetContext() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
    }
}

