/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.security;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignedObject;

public class SecurityHelper {
    private final FSILogger logger;

    public SecurityHelper(FSILogger logger) {
        this.logger = logger;
    }

    public final void generateKeyPair(String path) {
        KeyPair pair = null;
        try {
            KeyPairGenerator kg = KeyPairGenerator.getInstance("DSA");
            kg.initialize(1024);
            pair = kg.generateKeyPair();
            PublicKey pubKey = pair.getPublic();
            PrivateKey privKey = pair.getPrivate();
            Path dir = Paths.get(path, new String[0]);
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            FileOperations.writeObjectToFile(dir.resolve("publicKey"), pubKey);
            FileOperations.writeObjectToFile(dir.resolve("privateKey"), privKey);
        }
        catch (NoSuchAlgorithmException nsae) {
            this.logger.log(1024, nsae.getClass().getName() + ": " + nsae.getLocalizedMessage());
        }
        catch (IOException ioe) {
            this.logger.log(1024, ioe.getClass().getName() + ": " + ioe.getLocalizedMessage());
        }
    }

    public final SignedObject signObject(Serializable object, PrivateKey key) {
        try {
            Signature sig = Signature.getInstance(key.getAlgorithm());
            SignedObject so = new SignedObject(object, key, sig);
            return so;
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.log(1025, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        catch (SignatureException e) {
            this.logger.log(1025, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        catch (InvalidKeyException e) {
            this.logger.log(1025, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            this.logger.log(1025, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return null;
    }

    public final boolean verifySignature(SignedObject signedObject, PublicKey key) {
        try {
            Signature sig = Signature.getInstance(key.getAlgorithm());
            return signedObject.verify(key, sig);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.log(1026, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        catch (InvalidKeyException e) {
            this.logger.log(1026, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        catch (SignatureException e) {
            this.logger.log(1026, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return false;
    }

    public final String sha1sum(ByteBuffer data) {
        String result = null;
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA1");
            hash.update(data.duplicate());
            data.clear();
            byte[] digest = hash.digest();
            result = String.format("%0" + digest.length * 2 + "x", new BigInteger(1, digest)).trim();
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.log(1027, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return result;
    }

    public final String sha1sum(Path path) {
        String result = null;
        try (SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);){
            ByteBuffer data = ByteBuffer.allocate((int)channel.size());
            channel.read(data);
            result = this.sha1sum(data);
        }
        catch (IOException e) {
            this.logger.log(1027, e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        return result;
    }
}

