/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.security;

public final class Sha160 {
    private static final int BLOCK_SIZE = 64;
    private final byte[] buffer;
    private long count = 0L;
    private final int[] w = new int[80];
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;

    public Sha160() {
        this.buffer = new byte[64];
    }

    public void update(byte b) {
        int i = (int)(this.count % 64L);
        ++this.count;
        this.buffer[i] = b;
        if (i == 63) {
            this.transform(this.buffer, 0);
        }
    }

    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int offset, int len) {
        int n = (int)(this.count % 64L);
        this.count += (long)len;
        int partLen = 64 - n;
        int i = 0;
        if (len >= partLen) {
            System.arraycopy(b, offset, this.buffer, n, partLen);
            this.transform(this.buffer, 0);
            i = partLen;
            while (i + 64 - 1 < len) {
                this.transform(b, offset + i);
                i += 64;
            }
            n = 0;
        }
        if (i < len) {
            System.arraycopy(b, offset + i, this.buffer, n, len - i);
        }
    }

    public byte[] digest(byte[] b) {
        this.update(b);
        return this.digest();
    }

    public byte[] digest() {
        byte[] tail = this.padBuffer();
        this.update(tail, 0, tail.length);
        byte[] result = this.getResult();
        this.reset();
        return result;
    }

    public void reset() {
        this.count = 0L;
        int i = 0;
        while (i < 64) {
            this.buffer[i++] = 0;
        }
        this.resetContext();
    }

    private void transform(byte[] in, int offset) {
        int[] result = this.sha(this.h0, this.h1, this.h2, this.h3, this.h4, in, offset);
        this.h0 = result[0];
        this.h1 = result[1];
        this.h2 = result[2];
        this.h3 = result[3];
        this.h4 = result[4];
    }

    private byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int padding = n < 56 ? 56 - n : 120 - n;
        byte[] result = new byte[padding + 8];
        result[0] = -128;
        long bits = this.count << 3;
        result[padding++] = (byte)(bits >>> 56);
        result[padding++] = (byte)(bits >>> 48);
        result[padding++] = (byte)(bits >>> 40);
        result[padding++] = (byte)(bits >>> 32);
        result[padding++] = (byte)(bits >>> 24);
        result[padding++] = (byte)(bits >>> 16);
        result[padding++] = (byte)(bits >>> 8);
        result[padding] = (byte)bits;
        return result;
    }

    private byte[] getResult() {
        return new byte[]{(byte)(this.h0 >>> 24), (byte)(this.h0 >>> 16), (byte)(this.h0 >>> 8), (byte)this.h0, (byte)(this.h1 >>> 24), (byte)(this.h1 >>> 16), (byte)(this.h1 >>> 8), (byte)this.h1, (byte)(this.h2 >>> 24), (byte)(this.h2 >>> 16), (byte)(this.h2 >>> 8), (byte)this.h2, (byte)(this.h3 >>> 24), (byte)(this.h3 >>> 16), (byte)(this.h3 >>> 8), (byte)this.h3, (byte)(this.h4 >>> 24), (byte)(this.h4 >>> 16), (byte)(this.h4 >>> 8), (byte)this.h4};
    }

    private void resetContext() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
    }

    private final int[] sha(int hh0, int hh1, int hh2, int hh3, int hh4, byte[] in, int offset) {
        int T;
        int r;
        int A = hh0;
        int B = hh1;
        int C = hh2;
        int D = hh3;
        int E = hh4;
        for (r = 0; r < 16; ++r) {
            this.w[r] = in[offset++] << 24 | (in[offset++] & 0xFF) << 16 | (in[offset++] & 0xFF) << 8 | in[offset++] & 0xFF;
        }
        for (r = 16; r < 80; ++r) {
            T = this.w[r - 3] ^ this.w[r - 8] ^ this.w[r - 14] ^ this.w[r - 16];
            this.w[r] = T << 1 | T >>> 31;
        }
        for (r = 0; r < 20; ++r) {
            T = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + this.w[r] + 1518500249;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = T;
        }
        for (r = 20; r < 40; ++r) {
            T = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.w[r] + 1859775393;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = T;
        }
        for (r = 40; r < 60; ++r) {
            T = (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + this.w[r] + -1894007588;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = T;
        }
        for (r = 60; r < 80; ++r) {
            T = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.w[r] + -899497514;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = T;
        }
        return new int[]{hh0 + A, hh1 + B, hh2 + C, hh3 + D, hh4 + E};
    }
}

