/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.sort;

import java.util.Comparator;

public class FastQuickSort {
    public static void sort(Comparable[] a) {
        FastQuickSort.sort(a, 0, a.length - 1);
        FastQuickSort.insertSort(a, 0, a.length - 1);
    }

    public static void sort(Comparable[] a, Comparator<Comparable> comparator) {
        if (comparator != null) {
            FastQuickSort.sortComparator(a, 0, a.length - 1, comparator);
            FastQuickSort.insertSortComparator(a, 0, a.length - 1, comparator);
        } else {
            FastQuickSort.sort(a);
        }
    }

    private static void sort(Comparable[] a, int l, int r) {
        int M = 4;
        if (r - l > 4) {
            int i = (r + l) / 2;
            if (a[l].compareTo(a[i]) > 0) {
                FastQuickSort.swap(a, l, i);
            }
            if (a[l].compareTo(a[r]) > 0) {
                FastQuickSort.swap(a, l, r);
            }
            if (a[i].compareTo(a[r]) > 0) {
                FastQuickSort.swap(a, i, r);
            }
            int j = r - 1;
            FastQuickSort.swap(a, i, j);
            i = l;
            Comparable v = a[j];
            while (true) {
                if (a[++i].compareTo(v) < 0) {
                    continue;
                }
                while (a[--j].compareTo(v) > 0) {
                }
                if (j < i) break;
                FastQuickSort.swap(a, i, j);
            }
            FastQuickSort.swap(a, i, r - 1);
            FastQuickSort.sort(a, l, j);
            FastQuickSort.sort(a, i + 1, r);
        }
    }

    private static void insertSort(Comparable[] a, int lo0, int hi0) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            Comparable v = a[i];
            for (int j = i; j > lo0 && a[j - 1].compareTo(v) > 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = v;
        }
    }

    private static void sortComparator(Comparable[] a, int l, int r, Comparator<Comparable> comparator) {
        int M = 4;
        if (r - l > 4) {
            int i = (r + l) / 2;
            if (comparator.compare(a[l], a[i]) > 0) {
                FastQuickSort.swap(a, l, i);
            }
            if (comparator.compare(a[l], a[r]) > 0) {
                FastQuickSort.swap(a, l, r);
            }
            if (comparator.compare(a[i], a[r]) > 0) {
                FastQuickSort.swap(a, i, r);
            }
            int j = r - 1;
            FastQuickSort.swap(a, i, j);
            i = l;
            Comparable v = a[j];
            while (true) {
                if (comparator.compare(a[++i], v) < 0) {
                    continue;
                }
                while (comparator.compare(a[--j], v) > 0) {
                }
                if (j < i) break;
                FastQuickSort.swap(a, i, j);
            }
            FastQuickSort.swap(a, i, r - 1);
            FastQuickSort.sort(a, l, j);
            FastQuickSort.sort(a, i + 1, r);
        }
    }

    private static void insertSortComparator(Comparable[] a, int lo0, int hi0, Comparator<Comparable> comparator) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            Comparable v = a[i];
            for (int j = i; j > lo0 && comparator.compare(a[j - 1], v) > 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = v;
        }
    }

    private static void swap(Comparable[] a, int i, int j) {
        Comparable T = a[i];
        a[i] = a[j];
        a[j] = T;
    }
}

