/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.systeminformation;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiframework.systeminformation.MachineFingerprint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MachineFingerprintWindows
extends MachineFingerprint {
    public MachineFingerprintWindows(FSILogger logger, File tempdir, File localVolume) {
        super(logger, tempdir, localVolume);
    }

    public synchronized HashMap<String, byte[]> scan() throws IOException {
        String line;
        HashMap result = null;
        this.syshashes.clear();
        String syssum = this.getSerialNumber();
        StringReader sr = new StringReader(syssum);
        BufferedReader bs = new BufferedReader(sr);
        Pattern linepat = Pattern.compile("(.+)-(.+): (.+)");
        while ((line = bs.readLine()) != null) {
            MessageDigest md;
            Matcher linemat = linepat.matcher(line);
            if (!linemat.find()) continue;
            if (this.syshashes.containsKey(linemat.group(1))) {
                md = (MessageDigest)this.syshashes.get(linemat.group(1));
                md.update(linemat.group(3).getBytes());
                continue;
            }
            try {
                md = MessageDigest.getInstance("SHA-1");
                md.update(linemat.group(3).getBytes());
                this.syshashes.put(linemat.group(1), md);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.log(1015, e.getLocalizedMessage());
            }
        }
        bs.close();
        sr.close();
        if (this.syshashes.size() > 0) {
            result = new HashMap();
            for (Map.Entry sysentry : this.syshashes.entrySet()) {
                MessageDigest md = (MessageDigest)sysentry.getValue();
                result.put(sysentry.getKey(), md.digest());
            }
        }
        return result;
    }

    private String getSerialNumber() {
        String result = null;
        try {
            File file = File.createTempFile("tmp", ".vbs");
            FileWriter fw = new FileWriter(file);
            StringBuilder sb = new StringBuilder();
            sb.append("On Error Resume Next\n");
            sb.append("Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\n");
            sb.append("Set colDrives = objFSO.Drives\n");
            sb.append("Set objDrive = colDrives.item(\"" + this.localVolume.getPath() + "\")\n");
            sb.append("Wscript.Echo \"HDD-SerialNumber: \" & objDrive.SerialNumber\n");
            sb.append("Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\n");
            sb.append("Set colItems = objWMIService.ExecQuery(\"Select * from Win32_BaseBoard\")\n");
            sb.append("For Each objItem in colItems\n");
            sb.append("Wscript.Echo \"MB-Product: \" & objItem.Product\n");
            sb.append("Wscript.Echo \"MB-Version: \" & objItem.Version\n");
            sb.append("Next\n");
            sb.append("Set colItems = objWMIService.ExecQuery(\"Select * from Win32_Processor\")\n");
            sb.append("For Each objItem in colItems\n");
            sb.append("Wscript.Echo \"CPU-Description: \" & objItem.Description\n");
            sb.append("Wscript.Echo \"CPU-Name: \" & objItem.Name\n");
            sb.append("Wscript.Echo \"CPU-ProcessorId: \" & objItem.ProcessorId\n");
            sb.append("Wscript.Echo \"CPU-Revision: \" & objItem.Revision\n");
            sb.append("Wscript.Echo \"CPU-Version: \" & objItem.Version\n");
            sb.append("Next\n");
            sb.append("Set colItems = objWMIService.ExecQuery(\"Select * from Win32_NetworkAdapter where NetEnabled=true and PhysicalAdapter=true\")\n");
            sb.append("For Each objItem in colItems\n");
            sb.append("Wscript.Echo \"NIC-MAC: \" & objItem.MACAddress & \" \" & objItem.Description\n");
            sb.append("Next\n");
            sb.append("Set colItems = objWMIService.ExecQuery(\"Select * from Win32_OperatingSystem\")\n");
            sb.append("For Each objItem in colItems\n");
            sb.append("Wscript.Echo \"SYS-Serial: \" & objItem.SerialNumber\n");
            sb.append("Next\n");
            fw.write(sb.toString());
            fw.close();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("cscript");
            cmd.add("//T:30");
            cmd.add("//NoLogo");
            cmd.add(file.getPath());
            result = this.runCommand(cmd);
            if (result != null) {
                result = result.trim();
            }
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (IOException e) {
            this.logger.log(1013, e.getLocalizedMessage());
        }
        return result;
    }
}

