/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.systeminformation;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.DirectOutputStream;
import com.neptunelabs.fsiframework.systeminformation.OperatingPlatform;
import com.neptunelabs.fsiframework.systeminformation.OperatingSystem;
import com.neptunelabs.fsiframework.systeminformation.VMVendor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Properties;

public final class SystemInformation
implements Serializable {
    private static final long serialVersionUID = -5755039192523708059L;
    private final Properties props;
    private OperatingSystem os = OperatingSystem.Unknown;
    private OperatingPlatform platform = OperatingPlatform.Unknown;

    public SystemInformation() {
        this.props = System.getProperties();
        String osname = this.props.getProperty("os.name");
        String osversion = this.props.getProperty("os.version");
        if (osname.equals("AIX")) {
            this.os = OperatingSystem.AIX;
            this.platform = OperatingPlatform.Unix;
        } else if (osname.equals("Digital Unix")) {
            this.os = OperatingSystem.DigitalUnix;
            this.platform = OperatingPlatform.Unix;
        } else if (osname.equals("FreeBSD")) {
            this.os = OperatingSystem.FreeBSD;
            this.platform = OperatingPlatform.Unix;
        } else if (osname.equals("HP UX")) {
            this.os = OperatingSystem.HPUX;
            this.platform = OperatingPlatform.Unix;
        } else if (osname.equals("Irix")) {
            this.os = OperatingSystem.Irix;
            this.platform = OperatingPlatform.Unix;
        } else if (osname.equals("Linux")) {
            this.os = OperatingSystem.Linux;
            this.platform = OperatingPlatform.Linux;
        } else if (osname.equals("Mac OS")) {
            this.os = OperatingSystem.MacOS;
            this.platform = OperatingPlatform.MacOS;
        } else if (osname.equals("Mac OS X")) {
            this.os = OperatingSystem.MacOSX;
            this.platform = OperatingPlatform.MacOSX;
        } else if (osname.equals("MPE/iX")) {
            this.os = OperatingSystem.MPEiX;
            this.platform = OperatingPlatform.MPEiX;
        } else if (osname.equals("Netware 4.11")) {
            this.os = OperatingSystem.Netware;
            this.platform = OperatingPlatform.Netware;
        } else if (osname.equals("OS/2")) {
            this.os = OperatingSystem.OS2;
            this.platform = OperatingPlatform.OS2;
        } else if (osname.equals("Solaris")) {
            this.os = OperatingSystem.Solaris;
            this.platform = OperatingPlatform.Unix;
        } else if (osname.equals("SunOS")) {
            this.os = OperatingSystem.SunOS;
            this.platform = OperatingPlatform.Unix;
        } else if (osname.equals("OpenVMS")) {
            this.os = OperatingSystem.OpenVMS;
            this.platform = OperatingPlatform.Unix;
        } else if (osname.equals("OSF1")) {
            this.os = OperatingSystem.OSF1;
            this.platform = OperatingPlatform.Unix;
        } else if (osname.toLowerCase().indexOf("win") >= 0) {
            if (osversion.equals("5.0")) {
                this.os = OperatingSystem.Windows2000;
                this.platform = OperatingPlatform.Windows;
            } else if (osversion.equals("5.1")) {
                this.os = OperatingSystem.WindowsXP;
                this.platform = OperatingPlatform.Windows;
            } else if (osversion.equals("5.2")) {
                this.os = osname.contains("XP") ? OperatingSystem.WindowsXP : OperatingSystem.Windows2003;
                this.platform = OperatingPlatform.Windows;
            } else if (osversion.equals("6.0")) {
                this.os = osname.contains("Vista") ? OperatingSystem.WindowsVista : OperatingSystem.Windows2008;
                this.platform = OperatingPlatform.Windows;
            } else if (osversion.equals("6.1")) {
                this.os = osname.contains("7") ? OperatingSystem.Windows7 : OperatingSystem.Windows2008;
                this.platform = OperatingPlatform.Windows;
            } else if (osversion.equals("6.2")) {
                this.os = osname.contains("8") ? OperatingSystem.Windows8 : OperatingSystem.Windows2012;
                this.platform = OperatingPlatform.Windows;
            } else if (osversion.equals("6.3")) {
                if (osname.contains("8")) {
                    this.os = OperatingSystem.Windows8;
                }
                this.platform = OperatingPlatform.Windows;
            } else if (osversion.equals("10.0")) {
                this.os = OperatingSystem.Windows10;
                this.platform = OperatingPlatform.Windows;
            } else if (osname.equals("Windows 95")) {
                this.os = OperatingSystem.Windows95;
                this.platform = OperatingPlatform.Windows;
            } else if (osname.equals("Windows 98")) {
                this.os = OperatingSystem.Windows98;
                this.platform = OperatingPlatform.Windows;
            } else if (osname.equals("Windows NT")) {
                this.os = OperatingSystem.WindowsNT;
                this.platform = OperatingPlatform.Windows;
            } else if (osname.equals("Windows CE")) {
                this.os = OperatingSystem.WindowsCE;
                this.platform = OperatingPlatform.Windows;
            }
        } else if (osname.equals("OS/390")) {
            this.os = OperatingSystem.OS390;
            this.platform = OperatingPlatform.Unix;
        }
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final String getOSInformation() {
        return this.props.getProperty("os.name") + " " + this.props.getProperty("os.version");
    }

    public final String getJVMInformation() {
        return this.props.getProperty("java.vm.vendor") + " " + this.props.getProperty("java.vm.name") + " " + this.props.getProperty("java.vm.version");
    }

    public final int getProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public String getJVMVersionDetailed() {
        return (String)this.props.get("java.version");
    }

    public String getFileEncoding() {
        return this.props.getProperty("file.encoding");
    }

    public String getJNUEncoding() {
        String ret = this.props.getProperty("sun.jnu.encoding");
        return ret != null ? ret : "";
    }

    public String getJVMVersionDetailedWithArch() {
        String result = this.getJVMVersionDetailed();
        result = this.is64() ? result + " 64 Bit" : result + " 32 Bit";
        return result;
    }

    public float getJVMVersion() {
        Float ret = Float.valueOf(0.0f);
        try {
            ret = Float.valueOf((String)this.props.get("java.specification.version"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret.floatValue();
    }

    public OperatingSystem getOperatingSystem() {
        return this.os;
    }

    public String getOperationSystemString() {
        return this.props.getProperty("os.name");
    }

    public OperatingPlatform getOperatingPlatform() {
        return this.platform;
    }

    public boolean is64() {
        boolean result = false;
        int datamodel = Integer.valueOf((String)this.props.get("sun.arch.data.model"));
        if (datamodel == 64) {
            result = true;
        }
        return result;
    }

    public VMVendor getVMVendor() {
        VMVendor result = VMVendor.Unknown;
        String vendorRaw = (String)this.props.get("java.vm.vendor");
        if (vendorRaw.contains("OpenJDK")) {
            result = VMVendor.OpenJDK;
        } else if (vendorRaw.contains("Sun Microsystems")) {
            result = VMVendor.Sun;
        } else if (vendorRaw.contains("Oracle")) {
            result = VMVendor.Oracle;
        } else if (vendorRaw.contains("IBM")) {
            result = VMVendor.IBM;
        } else if (vendorRaw.contains("Apple")) {
            result = VMVendor.Apple;
        }
        return result;
    }

    public File getCurrentVolume() {
        File result;
        File master = result = this.getCurrentDirectory();
        while ((result = result.getParentFile()) != null) {
            master = result;
        }
        return master;
    }

    public File getCurrentDirectory() {
        File tempFile;
        File result = null;
        String temp = (String)this.props.get("user.dir");
        if (temp != null && (tempFile = new File(temp)).exists()) {
            result = tempFile;
        }
        return result;
    }

    public Path getTempDirectory() {
        Path tempFile;
        Path result = null;
        String temp = (String)this.props.get("java.specification.version");
        if (temp != null && Files.isWritable(tempFile = Paths.get(temp, new String[0]))) {
            result = tempFile;
        }
        return result;
    }

    public String getHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public byte[][] getHostAddresses() {
        Object result = null;
        try {
            InetAddress[] addrs = InetAddress.getAllByName(this.getHostname());
            int count = 0;
            for (InetAddress addr : addrs) {
                if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress()) continue;
                ++count;
            }
            result = new byte[count][];
            int p = 0;
            for (int c = 0; c < addrs.length; ++c) {
                if (addrs[c].isLoopbackAddress() || addrs[c].isLinkLocalAddress() || addrs[c].isAnyLocalAddress() || addrs[c].isMulticastAddress()) continue;
                result[p++] = addrs[c].getAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public ByteOrder getPreferedByteOrder() {
        return ByteOrder.nativeOrder();
    }

    public byte[][] getMacs() {
        Object result = null;
        try {
            int macNum = 0;
            Enumeration<NetworkInterface> nic1 = NetworkInterface.getNetworkInterfaces();
            while (nic1.hasMoreElements()) {
                NetworkInterface networkInterface = nic1.nextElement();
                if (networkInterface.isLoopback() || networkInterface.getHardwareAddress() == null) continue;
                ++macNum;
            }
            if (macNum > 0) {
                result = new byte[macNum][];
                Enumeration<NetworkInterface> nic2 = NetworkInterface.getNetworkInterfaces();
                int nc = 0;
                while (nic2.hasMoreElements()) {
                    NetworkInterface networkInterface = nic2.nextElement();
                    if (networkInterface.isLoopback() || networkInterface.getHardwareAddress() == null) continue;
                    result[nc++] = networkInterface.getHardwareAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return result;
    }

    public String getLMR() {
        String result = null;
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(128);
             DirectOutputStream dos = new DirectOutputStream(baos);){
            String version;
            String osInfo;
            byte[][] addrs;
            String hostname;
            dos.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byte[][] macs = this.getMacs();
            if (macs != null) {
                dos.writeInt(1);
                dos.writeInt(macs.length);
                for (byte[] mac : macs) {
                    dos.writeInt(mac.length);
                    dos.write(mac);
                }
            }
            if ((hostname = this.getHostname()) != null) {
                dos.writeInt(2);
                byte[] hostnameBytes = hostname.getBytes(this.getFileEncoding());
                dos.writeInt(hostnameBytes.length);
                dos.write(hostnameBytes);
            }
            if ((addrs = this.getHostAddresses()) != null) {
                dos.writeInt(3);
                dos.writeInt(addrs.length);
                for (byte[] addr : addrs) {
                    dos.writeInt(addr.length);
                    dos.write(addr);
                }
            }
            if ((osInfo = this.getOSInformation()) != null) {
                dos.writeInt(4);
                byte[] osInfoBytes = osInfo.getBytes(this.getFileEncoding());
                dos.writeInt(osInfoBytes.length);
                dos.write(osInfoBytes);
            }
            if ((version = SoftwareVersion.getVersion(true)) != null) {
                dos.writeInt(5);
                byte[] versionBytes = version.getBytes(StandardCharsets.US_ASCII);
                dos.writeInt(versionBytes.length);
                dos.write(versionBytes);
            }
            dos.close();
            byte[] macCont = baos.toByteArray();
            result = SystemInformation.xWrite(macCont);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static String xWrite(byte[] raw) {
        StringBuilder sb = new StringBuilder();
        int[] s = new int[2];
        int l = 170;
        for (int c = 0; c < raw.length; ++c) {
            int p = raw[c] & 0xFF;
            int m = (l ^ c * 146) & 0xFF;
            l = p ^= m;
            s[0] = p & 0xF;
            s[1] = p >> 4 & 0xF;
            for (int y = 0; y < 2; ++y) {
                int ck = (1 ^ s[y] & 3 ^ s[y] >> 2 & 3) << 4;
                int n = y;
                s[n] = s[n] | ck & 0x30;
                int o = s[y] < 2 ? 45 : (s[y] < 12 ? 46 : (s[y] < 38 ? 53 : 59));
                sb.append((char)(s[y] + o));
            }
        }
        return sb.toString();
    }

    public String dumpSystemInformation() {
        StringBuilder sb = new StringBuilder();
        Enumeration<Object> keys = this.props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            sb.append(key);
            sb.append(':');
            sb.append(this.props.getProperty(key));
            sb.append('\n');
        }
        return sb.toString();
    }
}

