/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiframework.updateservice.small;

import com.neptunelabs.fsiframework.io.FileOperations;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class UpdateFileEntry {
    private long size;
    private String checksum;
    private String filename;
    private String path;
    private Path tempFile;

    public UpdateFileEntry(long size, String checksum, String filename, String path) {
        this.size = size;
        this.checksum = checksum;
        this.filename = filename;
        this.path = path;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Path getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(Path tempFile) {
        this.tempFile = tempFile;
    }

    public boolean checkSignature() {
        boolean result = false;
        try {
            byte[] bytes = FileOperations.readFile(this.tempFile);
            MessageDigest hash = MessageDigest.getInstance("SHA1");
            hash.update(bytes);
            byte[] digest = hash.digest();
            String digestStr = String.format("%0" + digest.length * 2 + "x", new BigInteger(1, digest)).trim();
            if (digestStr.equals(this.checksum.trim())) {
                result = true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            result = false;
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }
}

