/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.authentication;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="permissionset")
public class PermissionSet {
    private String name;
    @XmlElement(name="general")
    public General general = new General();
    @XmlElement(name="read")
    public Read read = new Read();
    @XmlElement(name="list")
    public List list = new List();
    @XmlElement(name="write")
    public Write write = new Write();
    @XmlElement(name="tasks")
    public Tasks tasks = new Tasks();
    private static PermissionSet allForbiddenPermissionSet = null;

    public PermissionSet(String name) {
        this.name = name;
    }

    public PermissionSet() {
    }

    public void setFullReadPermissionsEnabled(boolean enabled) {
        this.read.defaultValue = enabled;
        this.list.defaultValue = enabled;
        this.applyDefaults();
    }

    public void setFullWritePermissionsEnabled(boolean enabled) {
        this.write.defaultValue = enabled;
        this.applyDefaults();
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String newname) {
        this.name = newname;
    }

    public static PermissionSet getEmptyPermissionSet() {
        PermissionSet ps = new PermissionSet();
        return ps;
    }

    public static PermissionSet getAllForbiddenPermissionSet() {
        if (allForbiddenPermissionSet == null) {
            PermissionSet ps = new PermissionSet();
            ps.general.defaultValue = false;
            ps.read.defaultValue = false;
            ps.list.defaultValue = false;
            ps.write.defaultValue = false;
            ps.tasks.defaultValue = false;
            ps.applyDefaults();
            allForbiddenPermissionSet = ps;
        }
        return allForbiddenPermissionSet;
    }

    public static PermissionSet getAllForbiddenPermissionsClone() {
        try {
            return PermissionSet.getAllForbiddenPermissionSet().clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void applyDefaults() {
        if (this.general.defaultValue != null) {
            this.general.readLicence = this.general.defaultValue;
            this.general.writeLicence = this.general.defaultValue;
            this.general.changePassword = this.general.defaultValue;
            this.general.writePreferences = this.general.defaultValue;
            this.general.switchUser = this.general.defaultValue;
        }
        if (this.read.defaultValue != null) {
            this.read.renderedImages = this.read.defaultValue;
            this.read.basicMetadata = this.read.defaultValue;
            this.read.extendedMetadata = this.read.defaultValue;
            this.read.files = this.read.defaultValue;
            this.read.downloadSource = this.read.defaultValue;
            this.read.copy = this.read.defaultValue;
            this.read.storageStatus = this.read.defaultValue;
            this.read.iccProfiles = this.read.defaultValue;
            this.read.totalAssetsCount = this.read.defaultValue;
        }
        if (this.list.defaultValue != null) {
            this.list.files = this.list.defaultValue;
            this.list.directories = this.list.defaultValue;
            this.list.searchResults = this.list.defaultValue;
            this.list.connector = this.list.defaultValue;
        }
        if (this.write.defaultValue != null) {
            this.write.createDirectory = this.write.defaultValue;
            this.write.upload = this.write.defaultValue;
            this.write.paste = this.write.defaultValue;
            this.write.moveWithinConnector = this.write.defaultValue;
            this.write.delete = this.write.defaultValue;
            this.write.moveToTrash = this.write.defaultValue;
            this.write.rename = this.write.defaultValue;
            this.write.extendedMetadata = this.write.defaultValue;
            this.write.overwrite = this.write.defaultValue;
        }
        if (this.tasks.defaultValue != null) {
            this.tasks.createArchive = this.tasks.defaultValue;
            this.tasks.batchRendering = this.tasks.defaultValue;
            this.tasks.reimportFiles = this.tasks.defaultValue;
        }
    }

    public boolean isEmpty() {
        return this.general.isEmpty() && this.read.isEmpty() && this.list.isEmpty() && this.write.isEmpty() && this.tasks.isEmpty();
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Name: " + this.name + " ");
        result.append("  general.writeprefs: " + this.general.writePreferences + " ");
        result.append("  read.renderedImages: " + this.read.renderedImages);
        result.append("  read.basicMetadata: " + this.read.basicMetadata);
        return result.toString();
    }

    public PermissionSet clone() throws CloneNotSupportedException {
        PermissionSet clone = new PermissionSet();
        clone.name = this.name;
        clone.general = this.general.clone();
        clone.read = this.read.clone();
        clone.list = this.list.clone();
        clone.write = this.write.clone();
        clone.tasks = this.tasks.clone();
        return clone;
    }

    public int hashCode() {
        return this.general.hashCode() + this.read.hashCode() + this.list.hashCode() + this.write.hashCode() + this.tasks.hashCode();
    }

    public static class Tasks {
        @XmlAttribute(name="default")
        public Boolean defaultValue = null;
        @XmlElement(name="reimportFiles")
        public Boolean reimportFiles = null;
        @XmlElement(name="batchRendering")
        public Boolean batchRendering = null;
        @XmlElement(name="createArchive")
        public Boolean createArchive = null;

        private boolean isEmpty() {
            return this.reimportFiles == null && this.batchRendering == null && this.createArchive == null;
        }

        protected Tasks clone() throws CloneNotSupportedException {
            Tasks clone = new Tasks();
            clone.defaultValue = this.defaultValue;
            clone.reimportFiles = this.reimportFiles;
            clone.batchRendering = this.batchRendering;
            clone.createArchive = this.createArchive;
            return clone;
        }

        public int hashCode() {
            return ("_" + this.defaultValue + this.reimportFiles + this.batchRendering + this.createArchive).hashCode();
        }
    }

    public static class Write {
        @XmlAttribute(name="default")
        public Boolean defaultValue = null;
        @XmlElement(name="delete")
        public Boolean delete = null;
        @XmlElement(name="movetotrash")
        public Boolean moveToTrash = null;
        @XmlElement(name="rename")
        public Boolean rename = null;
        @XmlElement(name="movewithinconnector")
        public Boolean moveWithinConnector = null;
        @XmlElement(name="createdirectory")
        public Boolean createDirectory = null;
        @XmlElement(name="upload")
        public Boolean upload = null;
        @XmlElement(name="paste")
        public Boolean paste = null;
        @XmlElement(name="extendedmetadata")
        public Boolean extendedMetadata = null;
        @XmlElement(name="overwrite")
        public Boolean overwrite = null;

        private boolean isEmpty() {
            return this.delete == null && this.moveToTrash == null && this.rename == null && this.moveWithinConnector == null && this.createDirectory == null && this.upload == null && this.paste == null && this.overwrite == null && this.extendedMetadata == null;
        }

        protected Write clone() throws CloneNotSupportedException {
            Write clone = new Write();
            clone.defaultValue = this.defaultValue;
            clone.delete = this.delete;
            clone.moveToTrash = this.moveToTrash;
            clone.rename = this.rename;
            clone.moveWithinConnector = this.moveWithinConnector;
            clone.createDirectory = this.createDirectory;
            clone.upload = this.upload;
            clone.paste = this.paste;
            clone.extendedMetadata = this.extendedMetadata;
            clone.overwrite = this.overwrite;
            return clone;
        }

        public int hashCode() {
            return ("_" + this.defaultValue + this.delete + this.moveToTrash + this.rename + this.moveWithinConnector + this.createDirectory + this.upload + this.paste + this.extendedMetadata + this.overwrite).hashCode();
        }
    }

    public static class List {
        @XmlAttribute(name="default")
        public Boolean defaultValue = null;
        @XmlElement(name="files")
        public Boolean files = null;
        @XmlElement(name="directories")
        public Boolean directories = null;
        @XmlElement(name="searchresults")
        public Boolean searchResults = null;
        @XmlElement(name="connector")
        public Boolean connector = null;

        private boolean isEmpty() {
            return this.files == null && this.directories == null && this.searchResults == null && this.connector == null;
        }

        protected List clone() throws CloneNotSupportedException {
            List clone = new List();
            clone.defaultValue = this.defaultValue;
            clone.files = this.files;
            clone.directories = this.directories;
            clone.searchResults = this.searchResults;
            clone.connector = this.connector;
            return clone;
        }

        public int hashCode() {
            return ("_" + this.defaultValue + this.files + this.directories + this.searchResults + this.connector).hashCode();
        }
    }

    public static class Read {
        @XmlAttribute(name="default")
        public Boolean defaultValue = null;
        @XmlElement(name="renderedimages")
        public Boolean renderedImages = null;
        @XmlElement(name="files")
        public Boolean files = null;
        @XmlElement(name="downloadsource")
        public Boolean downloadSource = null;
        @XmlElement(name="copy")
        public Boolean copy = null;
        @XmlElement(name="storagestatus")
        public Boolean storageStatus = null;
        @XmlElement(name="basicmetadata")
        public Boolean basicMetadata = null;
        @XmlElement(name="extendedmetadata")
        public Boolean extendedMetadata = null;
        @XmlElement(name="iccprofiles")
        public Boolean iccProfiles = null;
        @XmlElement(name="totalassetscount")
        public Boolean totalAssetsCount = null;

        private boolean isEmpty() {
            return this.renderedImages == null && this.files == null && this.downloadSource == null && this.copy == null && this.storageStatus == null && this.basicMetadata == null && this.extendedMetadata == null && this.iccProfiles == null && this.totalAssetsCount == null;
        }

        protected Read clone() throws CloneNotSupportedException {
            Read clone = new Read();
            clone.defaultValue = this.defaultValue;
            clone.renderedImages = this.renderedImages;
            clone.files = this.files;
            clone.downloadSource = this.downloadSource;
            clone.copy = this.copy;
            clone.storageStatus = this.storageStatus;
            clone.basicMetadata = this.basicMetadata;
            clone.extendedMetadata = this.extendedMetadata;
            clone.iccProfiles = this.iccProfiles;
            clone.totalAssetsCount = this.totalAssetsCount;
            return clone;
        }

        public int hashCode() {
            return ("_" + this.defaultValue + this.renderedImages + this.files + this.downloadSource + this.copy + this.storageStatus + this.basicMetadata + this.extendedMetadata + this.iccProfiles + this.totalAssetsCount).hashCode();
        }
    }

    public static class General {
        @XmlAttribute(name="default")
        public Boolean defaultValue = null;
        @XmlElement(name="readlicence")
        public Boolean readLicence = null;
        @XmlElement(name="writelicence")
        public Boolean writeLicence = null;
        @XmlElement(name="switchuser")
        public Boolean switchUser = null;
        @XmlElement(name="changepassword")
        public Boolean changePassword = null;
        @XmlElement(name="writepreferences")
        public Boolean writePreferences = null;

        private boolean isEmpty() {
            return this.readLicence == null && this.writeLicence == null && this.switchUser == null && this.changePassword == null && this.writePreferences == null;
        }

        protected General clone() throws CloneNotSupportedException {
            General clone = new General();
            clone.defaultValue = this.defaultValue;
            clone.readLicence = this.readLicence;
            clone.writeLicence = this.writeLicence;
            clone.switchUser = this.switchUser;
            clone.changePassword = this.changePassword;
            clone.writePreferences = this.writePreferences;
            return clone;
        }

        public int hashCode() {
            return (this.defaultValue + " " + this.readLicence + " " + this.writeLicence + " " + this.switchUser + " " + this.changePassword + " " + this.writePreferences).hashCode();
        }
    }
}

