/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.download;

import com.neptunelabs.fsiframework.io.FileOperations;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class DownloadJob
implements Comparable<DownloadJob>,
Serializable {
    private static final long serialVersionUID = 7821300352297580600L;
    private long creationTime = 0L;
    private long scheduledStart = 0L;
    private long startTime = 0L;
    private long finishedTime = 0L;
    private String user;
    private Set<String> groups;
    private Set<String> files;
    private String name;
    private String id;
    private String renderingQuery = null;
    private long archiveSize = 0L;
    private boolean replaceFilenameExtension = false;
    volatile JobState status = JobState.UNKNOWN;
    ArchiveType archiveType = ArchiveType.ZIP;
    int queuePos = -1;
    int fileCount = 1;
    AtomicInteger progressCount = new AtomicInteger(0);

    private DownloadJob() {
    }

    public static DownloadJob createJob() {
        DownloadJob job = new DownloadJob();
        job.creationTime = System.currentTimeMillis();
        job.id = String.valueOf(job.creationTime);
        return job;
    }

    public final int getFileCount() {
        return this.fileCount;
    }

    public final int getProgressCount() {
        return this.progressCount.get();
    }

    public final Set<String> getGroups() {
        return this.groups;
    }

    public final Set<String> getFiles() {
        return this.files;
    }

    public final String getID() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final String getRenderingQuery() {
        return this.renderingQuery;
    }

    public final long getArchiveSize() {
        return this.archiveSize;
    }

    public final void setArchiveSize(long archiveSize) {
        this.archiveSize = archiveSize;
    }

    public final void setScheduledStart(long scheduledStart) {
        this.scheduledStart = scheduledStart;
    }

    public final long getScheduledStart() {
        return this.scheduledStart;
    }

    public final void setCreator(String creator) {
        this.user = creator;
    }

    public final void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public final void setFiles(Set<String> files) {
        this.files = files;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setRenderingQuery(String renderingQuery) {
        this.renderingQuery = renderingQuery;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public final long getFinishedTime() {
        return this.finishedTime;
    }

    public final void setFinishedTime(long finishedTime) {
        this.finishedTime = finishedTime;
    }

    public final String getUser() {
        return this.user;
    }

    public final JobState getStatus() {
        return this.status;
    }

    public final int getQueuePos() {
        return this.queuePos;
    }

    public final ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public final void setArchiveType(ArchiveType archiveType) {
        this.archiveType = archiveType;
    }

    public final long getLastModified() {
        long lmdate = 0L;
        switch (this.status) {
            case COMPLETE: 
            case ERROR: {
                if (lmdate >= this.finishedTime) break;
                lmdate = this.finishedTime;
                break;
            }
            case PROCESSING: 
            case UNKNOWN: {
                lmdate = System.currentTimeMillis();
                break;
            }
            case QUEUED: {
                if (lmdate >= this.creationTime) break;
                lmdate = this.creationTime;
                break;
            }
            case CANCELLED: {
                lmdate = this.startTime != 0L ? this.startTime : this.creationTime;
            }
        }
        return lmdate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DownloadJob) {
            DownloadJob other = (DownloadJob)obj;
            return other.id.equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(DownloadJob other) {
        if (this.equals(other)) {
            return 0;
        }
        return (int)(other.creationTime - this.creationTime);
    }

    void saveToFile(Path targetFile) throws IOException {
        FileOperations.writeObjectToFile(targetFile, this);
    }

    public static DownloadJob createFromFile(Path jobfile) throws IOException {
        try {
            return (DownloadJob)FileOperations.readObjectFromFile(jobfile);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public final boolean isReplaceFilenameExtension() {
        return this.replaceFilenameExtension;
    }

    public final void setReplaceFilenameExtension(boolean replaceFilenameExtension) {
        this.replaceFilenameExtension = replaceFilenameExtension;
    }

    public static enum ArchiveType {
        ZIP,
        TAR_GZ,
        TAR_BZ2;

    }

    public static enum JobState {
        UNKNOWN,
        COMPLETE,
        PROCESSING,
        ERROR,
        QUEUED,
        CANCELLED;

    }
}

