/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.download;

import com.neptunelabs.fsiframework.comparator.FSIStringComparator;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import java.util.Comparator;

public final class DownloadJobComparator
implements Comparator<DownloadJob> {
    private final FSIStringComparator stringComparator;
    private final SupportedSortfield sortField;
    private final SortDirection order;

    public DownloadJobComparator(String sortField, SortDirection order, FSIStringComparator stringComparator) {
        this.stringComparator = stringComparator;
        this.sortField = this.evaluateSortField(sortField);
        this.order = order;
    }

    private SupportedSortfield evaluateSortField(String requestedSortField) {
        SupportedSortfield result;
        try {
            result = SupportedSortfield.valueOf(requestedSortField.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            result = SupportedSortfield.NO_SORTING;
        }
        return result;
    }

    @Override
    public int compare(DownloadJob job1, DownloadJob job2) {
        int result;
        boolean orderConsidered = false;
        switch (this.sortField) {
            case LASTMODIFIED: {
                long job1lm = job1.getLastModified();
                long job2lm = job2.getLastModified();
                result = job1lm < job2lm ? -1 : (job1lm == job2lm ? 0 : 1);
                break;
            }
            case STARTDATE: {
                long job1val = job1.getStartTime();
                long job2val = job2.getStartTime();
                result = job1val < job2val ? -1 : (job1val == job2val ? 0 : 1);
                break;
            }
            case FILESIZE: {
                long job1val = job1.getArchiveSize();
                long job2val = job2.getArchiveSize();
                result = job1val < job2val ? -1 : (job1val == job2val ? 0 : 1);
                break;
            }
            case DURATION: {
                long job1val = (job1.getFinishedTime() - job1.getStartTime()) / 1000L;
                long job2val = (job2.getFinishedTime() - job2.getStartTime()) / 1000L;
                result = job1val < job2val ? -1 : (job1val == job2val ? 0 : 1);
                break;
            }
            case CREATIONDATE: {
                long job1val = job1.getCreationTime();
                long job2val = job2.getCreationTime();
                result = job1val < job2val ? -1 : (job1val == job2val ? 0 : 1);
                break;
            }
            case SCHEDULEDATE: {
                long job1val = job1.getScheduledStart();
                long job2val = job2.getScheduledStart();
                result = job1val < job2val ? -1 : (job1val == job2val ? 0 : 1);
                break;
            }
            case CREATEDBY: {
                result = this.stringComparator.compare(job1.getUser(), job2.getUser());
                orderConsidered = true;
                break;
            }
            case QUEUEPOS: {
                long job1val = job1.getQueuePos();
                long job2val = job2.getQueuePos();
                result = job1val < job2val ? -1 : (job1val == job2val ? 0 : 1);
                break;
            }
            case PROGRESS: {
                long job1val = job1.getProgressCount() * 100 / job1.getFileCount();
                long job2val = job2.getProgressCount() * 100 / job2.getFileCount();
                result = job1val < job2val ? -1 : (job1val == job2val ? 0 : 1);
                break;
            }
            case STATUS: {
                long job1val = job1.getStatus().ordinal();
                long job2val = job2.getStatus().ordinal();
                result = job1val < job2val ? -1 : (job1val == job2val ? 0 : 1);
                break;
            }
            default: {
                result = 0;
            }
        }
        if (result == 0) {
            result = this.stringComparator.compare(job1.getName(), job2.getName());
            orderConsidered = true;
        }
        if (!orderConsidered && this.order == SortDirection.DESC) {
            result = -result;
        }
        return result;
    }

    private static enum SupportedSortfield {
        NO_SORTING,
        FILENAME,
        LASTMODIFIED,
        STARTDATE,
        FILESIZE,
        DURATION,
        CREATIONDATE,
        SCHEDULEDATE,
        CREATEDBY,
        QUEUEPOS,
        PROGRESS,
        STATUS;

    }
}

