/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.download;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.MimeHelper;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.requestprocessor.MainProcessor;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public final class DownloadJobProcessor
extends Thread {
    private final BlockingQueue<DownloadJob> joblist = new LinkedBlockingQueue<DownloadJob>();
    private final Map<String, EnqueueJobTimerTask> scheduledJobs = new ConcurrentHashMap<String, EnqueueJobTimerTask>();
    private final SourceManagerSettings settings;
    private final StorageHelperV1002 storageHelper;
    private Path downloadsFolder;
    private Path joblistFolder;
    private volatile DownloadJob currentJob = null;
    private volatile STATE state;
    private final Timer timer;

    public DownloadJobProcessor(SourceManagerSettings settings) {
        this.settings = settings;
        this.storageHelper = settings.getStorageHelper();
        try {
            this.downloadsFolder = this.storageHelper.getDownloadsFolder();
            this.joblistFolder = this.downloadsFolder.resolve("pending");
            if (Files.notExists(this.joblistFolder, new LinkOption[0])) {
                Files.createDirectories(this.joblistFolder, new FileAttribute[0]);
            }
        }
        catch (NotConfiguredException | IOException e) {
            this.downloadsFolder = null;
            this.joblistFolder = null;
        }
        this.setName("Download Job Processor");
        this.timer = new Timer("Download Job Processor Timer", true);
    }

    public void restartJob(String jobID) throws IOException {
        Path jobFile = this.downloadsFolder.resolve(jobID + ".job");
        if (Files.notExists(jobFile, new LinkOption[0])) {
            jobFile = this.joblistFolder.resolve(jobID + ".job");
        }
        DownloadJob job = DownloadJob.createFromFile(jobFile);
        Files.deleteIfExists(jobFile);
        if (job.status == DownloadJob.JobState.QUEUED && job.getScheduledStart() != 0L) {
            job.setScheduledStart(0L);
        }
        this.enqueueJob(job);
    }

    public boolean enqueueJob(DownloadJob job) {
        Path jobFile = this.joblistFolder.resolve(job.getID() + ".job");
        job.status = DownloadJob.JobState.QUEUED;
        try {
            job.saveToFile(jobFile);
        }
        catch (IOException e) {
            this.settings.getFSILogger().log(3255, jobFile, job.getID());
            return false;
        }
        if (job.getScheduledStart() == 0L || job.getScheduledStart() < System.currentTimeMillis()) {
            this.joblist.add(job);
        } else {
            this.scheduleJob(job);
        }
        return true;
    }

    public List<DownloadJob> getJobs(String username, Set<String> groups) {
        HashSet<DownloadJob> allJobs = new HashSet<DownloadJob>();
        int pos = 1;
        for (DownloadJob queuedJob : this.joblist) {
            queuedJob.queuePos = pos++;
            allJobs.add(queuedJob);
        }
        if (this.currentJob != null) {
            allJobs.add(this.currentJob);
        }
        for (EnqueueJobTimerTask task : this.scheduledJobs.values()) {
            allJobs.add(task.job);
        }
        ArrayList<DownloadJob> result = new ArrayList<DownloadJob>();
        for (DownloadJob job : allJobs) {
            if (!job.getUser().equals(username) && Collections.disjoint(job.getGroups(), groups)) continue;
            result.add(job);
        }
        return result;
    }

    @Override
    public void run() {
        if (this.downloadsFolder != null) {
            try {
                this.initJobQueueFromFileSystem();
                this.state = STATE.IDLE;
                while (this.state != STATE.STOPPING) {
                    this.currentJob = null;
                    try {
                        DownloadJob job;
                        this.state = STATE.IDLE;
                        this.currentJob = job = this.joblist.take();
                        this.state = STATE.WORKING;
                        this.processJob(job);
                    }
                    catch (InterruptedException e) {
                        this.state = STATE.STOPPING;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.state = STATE.STOPPED;
    }

    private void initJobQueueFromFileSystem() throws IOException {
        List<DownloadJob> allJobs = this.readJobsFromDirectory(this.joblistFolder);
        Collections.sort(allJobs);
        long currentTime = System.currentTimeMillis();
        for (DownloadJob job : allJobs) {
            if (job.getScheduledStart() == 0L) {
                this.joblist.add(job);
                continue;
            }
            if (job.getScheduledStart() < currentTime) {
                this.cancelJob(job.getID());
                continue;
            }
            this.scheduleJob(job);
        }
    }

    private void scheduleJob(DownloadJob job) {
        EnqueueJobTimerTask task = new EnqueueJobTimerTask(job);
        long delay = job.getScheduledStart() - System.currentTimeMillis();
        this.timer.schedule((TimerTask)task, delay);
        this.scheduledJobs.put(job.getID(), task);
    }

    private List<DownloadJob> readJobsFromDirectory(Path joblistFolderValue) throws IOException {
        ArrayList<DownloadJob> result = new ArrayList<DownloadJob>();
        List<PathCached> files = FileOperations.listAllFiles(joblistFolderValue, "*");
        for (PathCached f : files) {
            if (!f.isRegularFile() || !f.getFileName().endsWith(".job")) continue;
            try {
                DownloadJob job = DownloadJob.createFromFile(f.getPath());
                if (job == null) continue;
                result.add(job);
            }
            catch (IOException ioe) {
                this.settings.getFSILogger().log(3241, f, ioe.getLocalizedMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processJob(DownloadJob job) {
        String jobfilename = job.getID();
        this.settings.getFSILogger().log(3250, job.getID(), job.getUser());
        if (job.getRenderingQuery() != null && !this.settings.getLicence().isBatchProcessingEnabled()) {
            job.status = DownloadJob.JobState.CANCELLED;
            this.settings.getFSILogger().log(2059, job.getName());
        } else {
            job.status = DownloadJob.JobState.PROCESSING;
            Path tmpArchiveFile = this.downloadsFolder.resolve(jobfilename + ".tmp");
            try {
                int fileCounter = 0;
                for (String assetURLPath : job.getFiles()) {
                    SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, job.getUser());
                    String[] splitPath = StorageHelperV1002.splitAssetURLPath(assetURLPath);
                    Path targetFile = connector.getInboxDirectory().resolve(splitPath[1]);
                    if (Files.isDirectory(targetFile, new LinkOption[0])) {
                        fileCounter = (int)((long)fileCounter + FileOperations.countFilesRecursively(targetFile));
                        continue;
                    }
                    ++fileCounter;
                }
                job.fileCount = fileCounter;
                this.settings.getFSILogger().log(3251, job.getID(), job.fileCount);
                if (job.status == DownloadJob.JobState.PROCESSING) {
                    job.setStartTime(System.currentTimeMillis());
                    this.createArchive(job, tmpArchiveFile);
                }
                if (Files.exists(tmpArchiveFile, new LinkOption[0])) {
                    Path finalZipFile = this.downloadsFolder.resolve(jobfilename + ".download");
                    FileOperations.move(tmpArchiveFile, finalZipFile);
                    job.setArchiveSize(Files.size(finalZipFile));
                }
                job.setFinishedTime(System.currentTimeMillis());
                if (job.status == DownloadJob.JobState.PROCESSING) {
                    job.status = DownloadJob.JobState.COMPLETE;
                }
            }
            catch (IOException e) {
                this.settings.getFSILogger().log(3239, e.getLocalizedMessage());
                job.status = DownloadJob.JobState.ERROR;
            }
            catch (NotConfiguredException e) {
                this.settings.getFSILogger().log(3239, e.getLocalizedMessage());
                job.status = DownloadJob.JobState.ERROR;
            }
            finally {
                try {
                    Files.deleteIfExists(tmpArchiveFile);
                }
                catch (IOException e) {}
            }
        }
        Path finalJobFile = this.downloadsFolder.resolve(jobfilename + ".job");
        try {
            job.saveToFile(finalJobFile);
        }
        catch (IOException e) {
            this.settings.getFSILogger().log(3255, finalJobFile, job.getID());
            return false;
        }
        Path queueFile = this.joblistFolder.resolve(jobfilename + ".job");
        try {
            Files.deleteIfExists(queueFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.settings.getFSILogger().log(3252, job.getID(), job.getStatus().name());
        return true;
    }

    private void addEntryToArchive(Path file, String pathInArchive, ArchiveOutputStream out, DownloadJob.ArchiveType archiveType) throws IOException {
        Object fileentry = archiveType == DownloadJob.ArchiveType.ZIP ? new ZipArchiveEntry(file.toFile(), pathInArchive) : new TarArchiveEntry(file.toFile(), pathInArchive);
        out.putArchiveEntry((ArchiveEntry)fileentry);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            out.write(FileOperations.readFile(file));
        }
        out.closeArchiveEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursivelyAddToArchive(DownloadJob job, Path file, String pathInArchive, String assetURLPath, ArchiveOutputStream out, DownloadJob.ArchiveType archiveType) throws IOException {
        block24: {
            block23: {
                SourceConnectorReader connector;
                if (!Files.isRegularFile(file, new LinkOption[0])) break block23;
                boolean addRenderedFile = false;
                if (job.getRenderingQuery() != null && (connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath)).getMountType() != SourceConnectorReader.SourceConnectorType.STATIC) {
                    Path tmpFile;
                    addRenderedFile = true;
                    MainProcessor engine = (MainProcessor)this.settings.getServletContext().getAttribute("com.neptunelabs.fsiserver.requestprocessor.MainProcessor");
                    Parameters parameters = new Parameters(job.getRenderingQuery());
                    parameters.put(Parameters.General.source, assetURLPath);
                    int i = 0;
                    String basename = String.valueOf(System.currentTimeMillis());
                    while (Files.exists(tmpFile = this.settings.getWorkDirectory().resolve(basename + "_" + i), new LinkOption[0])) {
                    }
                    try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));){
                        String contentType = engine.handleBatchRequest(parameters, fileOutputStream);
                        String fileSuffix = MimeHelper.getFileExtensionFromMimeType(contentType);
                        if (job.isReplaceFilenameExtension()) {
                            int lastPos = pathInArchive.lastIndexOf(".");
                            pathInArchive = pathInArchive.substring(0, lastPos) + fileSuffix;
                        } else {
                            pathInArchive = pathInArchive + fileSuffix;
                        }
                        this.addEntryToArchive(tmpFile, pathInArchive, out, archiveType);
                        job.progressCount.incrementAndGet();
                    }
                    catch (Exception e) {
                        job.status = DownloadJob.JobState.ERROR;
                        this.settings.getFSILogger().logException(e, 3263, assetURLPath, e.getLocalizedMessage());
                    }
                    finally {
                        Files.deleteIfExists(tmpFile);
                    }
                }
                if (addRenderedFile) break block24;
                this.addEntryToArchive(file, pathInArchive, out, archiveType);
                job.progressCount.incrementAndGet();
                break block24;
            }
            this.addEntryToArchive(file, pathInArchive, out, archiveType);
            List<PathCached> files = FileOperations.listAllFiles(file);
            for (PathCached f : files) {
                this.recursivelyAddToArchive(job, f.getPath(), pathInArchive + "/" + f.getFileName(), assetURLPath + "/" + f.getFileName(), out, archiveType);
                if (job.status == DownloadJob.JobState.PROCESSING) continue;
                break;
            }
        }
    }

    private void createArchive(DownloadJob job, Path archiveFile) throws NotConfiguredException, IOException {
        switch (job.archiveType) {
            case ZIP: {
                this.createZip(job, archiveFile);
                break;
            }
            case TAR_GZ: 
            case TAR_BZ2: {
                this.createTar(job, archiveFile);
            }
        }
        if (job.status != DownloadJob.JobState.PROCESSING) {
            Files.deleteIfExists(archiveFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTar(DownloadJob job, Path tarFile) throws NotConfiguredException, IOException {
        TarArchiveOutputStream tarOut = null;
        OutputStream compressionStream = null;
        try {
            compressionStream = job.getArchiveType() == DownloadJob.ArchiveType.TAR_GZ ? new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(tarFile, new OpenOption[0]))) : new BZip2CompressorOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(tarFile, new OpenOption[0])));
            tarOut = new TarArchiveOutputStream(compressionStream);
            tarOut.setLongFileMode(2);
            this.packArchive(job, (ArchiveOutputStream)tarOut);
        }
        finally {
            if (tarOut != null) {
                tarOut.close();
            }
            if (compressionStream != null) {
                compressionStream.close();
            }
        }
    }

    private void packArchive(DownloadJob job, ArchiveOutputStream archiveOut) throws IOException, NotConfiguredException {
        for (String assetURLPath : job.getFiles()) {
            SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, job.getUser());
            String[] splitPath = StorageHelperV1002.splitAssetURLPath(assetURLPath);
            Path sourceFile = connector.getInboxDirectory().resolve(splitPath[1]);
            this.recursivelyAddToArchive(job, sourceFile, sourceFile.getFileName().toString(), assetURLPath, archiveOut, job.archiveType);
            if (job.status == DownloadJob.JobState.PROCESSING) continue;
            break;
        }
    }

    private void createZip(DownloadJob job, Path zipfile) throws NotConfiguredException, IOException {
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(zipfile, new OpenOption[0])));){
            this.packArchive(job, (ArchiveOutputStream)zos);
        }
    }

    public boolean cancelJob(String id) {
        DownloadJob job = this.removeJobIfScheduled(id);
        if (job == null) {
            job = this.removeJobIfQueued(id);
        }
        if (job == null) {
            job = this.cancelJobIfRunning(id);
        }
        if (job != null) {
            Path finishedFile = this.downloadsFolder.resolve(id + ".job");
            try {
                this.removePendingJobFromFileSystem(id);
                job.progressCount.set(0);
                job.status = DownloadJob.JobState.CANCELLED;
                job.saveToFile(finishedFile);
            }
            catch (IOException e) {
                this.settings.getFSILogger().log(3255, finishedFile, job.getID());
                return false;
            }
        }
        return true;
    }

    private DownloadJob removeJobIfScheduled(String id) {
        EnqueueJobTimerTask task = this.scheduledJobs.get(id);
        if (task != null) {
            task.cancel();
            this.scheduledJobs.remove(id);
            return task.job;
        }
        return null;
    }

    private DownloadJob removeJobIfQueued(String id) {
        DownloadJob foundJob = null;
        for (DownloadJob jobToCheck : this.joblist) {
            if (!jobToCheck.getID().equals(id)) continue;
            foundJob = jobToCheck;
            break;
        }
        if (foundJob != null) {
            this.joblist.remove(foundJob);
        }
        return foundJob;
    }

    private DownloadJob cancelJobIfRunning(String id) {
        if (this.currentJob != null && this.currentJob.getID().equals(id)) {
            this.currentJob.status = DownloadJob.JobState.CANCELLED;
            return this.currentJob;
        }
        return null;
    }

    private void removePendingJobFromFileSystem(String id) throws IOException {
        Path jobfile = this.joblistFolder.resolve(id + ".job");
        Files.deleteIfExists(jobfile);
    }

    public void halt() {
        this.state = STATE.STOPPING;
        this.timer.cancel();
        this.timer.purge();
        this.interrupt();
    }

    private class EnqueueJobTimerTask
    extends TimerTask {
        final DownloadJob job;

        EnqueueJobTimerTask(DownloadJob job) {
            this.job = job;
        }

        @Override
        public void run() {
            DownloadJobProcessor.this.scheduledJobs.remove(this.job.getID());
            DownloadJobProcessor.this.enqueueJob(this.job);
        }
    }

    private static enum STATE {
        IDLE,
        WORKING,
        STOPPING,
        STOPPED;

    }
}

