/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator;

import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.servlet.ServletConfig;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.WarBasedAxisConfigurator;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.util.Loader;

class Axis2ConfigContext
extends WarBasedAxisConfigurator {
    private Path axis2xml = null;
    private final Path repositoryLocation;

    Axis2ConfigContext(ServletConfig servletConfig) throws DeploymentException {
        super(servletConfig);
        Path webInfPath = ServletUtils.getRealPath(servletConfig.getServletContext(), "WEB-INF");
        this.repositoryLocation = webInfPath.resolve("internal/administrator");
        this.axis2xml = this.repositoryLocation.resolve("axis2.xml");
    }

    public synchronized AxisConfiguration getAxisConfiguration() throws AxisFault {
        InputStream configStream = null;
        try {
            configStream = this.axis2xml != null && Files.exists(this.axis2xml, new LinkOption[0]) ? Files.newInputStream(this.axis2xml, new OpenOption[0]) : Loader.getResourceAsStream((String)"org/apache/axis2/deployment/axis2_default.xml");
            this.axisConfig = this.populateAxisConfiguration(configStream);
        }
        catch (IOException e) {
            throw new AxisFault(e.getLocalizedMessage() + " in " + this.axis2xml);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
        }
        this.loadRepository(this.repositoryLocation.toString());
        this.axisConfig.setConfigurator((AxisConfigurator)this);
        return this.axisConfig;
    }
}

