/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator;

import com.neptunelabs.fsiserver.requestprocessor.MainProcessor;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.settings.ServletXMLSettings;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import java.nio.file.Path;
import javax.servlet.GenericServlet;

final class ServletSettingsWrapper
extends ServletXMLSettings {
    private SourceManagerSettings sourcemanagersettings = null;
    private RequestProcessorSettings requestprocessorsettings = null;
    private final Path configHome;

    protected ServletSettingsWrapper(GenericServlet servlet, ServletFileEventCursor fileEventCursor) {
        super(servlet, false, fileEventCursor, true);
        if (this.servletConfig != null) {
            this.configHome = (Path)this.servletConfig.getServletContext().getAttribute("com.neptunelabs.fsiserver.config.home");
            this.servletConfig.getServletContext().setAttribute("FSIServletSettings", (Object)this);
        } else {
            this.configHome = null;
        }
        Path adminDir = this.getRealDir("internal/administrator");
        this.setAdministratorHelpDiretory(adminDir.resolve("help"));
    }

    @Override
    public boolean isViewableDir(String path) {
        return this.getSourceManagerSettings().isViewableDir(path) || this.getServerSettings().isViewableDir(path);
    }

    public Path getConfigHome() {
        return this.configHome;
    }

    @Override
    public boolean isBackupDir(String path) {
        return this.getSourceManagerSettings().isBackupDir(path) || this.getServerSettings().isBackupDir(path);
    }

    @Override
    public synchronized boolean isProtectedDir(Path f) {
        return this.getSourceManagerSettings().isProtectedDir(f) || this.getServerSettings().isProtectedDir(f);
    }

    public UserAuthenticationInterface getUserAuthenticationInterface() {
        UserAuthenticationInterface result = this.getSourceManagerSettings().getUserAuthenticationInterface();
        if (result == null) {
            try {
                result = this.getServerSettings().getUserAuthenticationInterface();
            }
            catch (NotConfiguredException notConfiguredException) {
                // empty catch block
            }
        }
        return result;
    }

    private SourceManagerSettings getSourceManagerSettings() {
        Object o1;
        if (this.sourcemanagersettings == null && (o1 = this.servletContext.getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager")) != null && o1 instanceof MainManager) {
            MainManager sourceManager = (MainManager)o1;
            this.sourcemanagersettings = sourceManager.getSourceManagerSettings();
        }
        return this.sourcemanagersettings;
    }

    private RequestProcessorSettings getServerSettings() {
        Object o1;
        if (this.requestprocessorsettings == null && (o1 = this.servletContext.getAttribute("com.neptunelabs.fsiserver.requestprocessor.MainProcessor")) != null && o1 instanceof MainProcessor) {
            MainProcessor serverengine = (MainProcessor)o1;
            this.requestprocessorsettings = serverengine.getRequestProcessorSettings();
        }
        return this.requestprocessorsettings;
    }
}

