/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.fsiadministrator.WSMain;
import com.neptunelabs.fsiservletframework.BaseWSAdminConnector;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetFileListRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetFileListResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetSoftwareStatusRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetSoftwareStatusResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.interfacewebservice.ReadFileContentsRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.ReadFileContentsResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.RemoteDirectoryType;
import com.neptunelabs.fsiservletframework.interfacewebservice.RemoteFileType;
import com.neptunelabs.fsiservletframework.interfacewebservice.SetMaintenanceEnabledRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.SoftwareStatusType;
import com.neptunelabs.fsiservletframework.interfacewebservice.UpdateUserListRequest;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;

public class WSAdminConnector
extends BaseWSAdminConnector {
    private WSMain getWebinterface() {
        Object o;
        WSMain result = null;
        if (this.settings != null && (o = this.settings.getServletContext().getAttribute("com.neptunelabs.fsiserver.fsiadministrator.WSMain")) != null && o instanceof WSMain) {
            result = (WSMain)o;
        }
        return result;
    }

    @Override
    protected int getRenderedTemplate(String action, Map<String, Object> httpParameters, Map<String, String> sessionData, List<Map<String, Object>> relatedPages, Map<String, String> requiredParameters, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, ByteArrayOutputStream responseBodyOutputStream) {
        int resultStatus = 500;
        WSMain webinterface = this.getWebinterface();
        if (webinterface != null) {
            resultStatus = webinterface.getRenderedTemplate(action, httpParameters, sessionData, relatedPages, requiredParameters, files, responseHeaders, responseSessionData, responseBodyOutputStream);
        }
        return resultStatus;
    }

    @Override
    public GetSoftwareStatusResponse getSoftwareStatus(GetSoftwareStatusRequest getSoftwareStatusRequest) {
        GetSoftwareStatusResponse result = null;
        try {
            WSMain webinterface = this.getWebinterface();
            if (webinterface != null) {
                result = webinterface.getSoftwareStatus();
            } else {
                SoftwareStatusType s = new SoftwareStatusType();
                result = new GetSoftwareStatusResponse();
                result.setGetSoftwareStatusResponse(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void setMaintenanceEnabled(SetMaintenanceEnabledRequest setMaintenanceEnabledRequest) {
        this.settings.setMaintenanceModeEnabled(setMaintenanceEnabledRequest.getSetMaintenanceEnabledRequest().getValue());
    }

    @Override
    public void updateUserList(UpdateUserListRequest requestparams) {
    }

    @Override
    public GetFileListResponse getFileList(GetFileListRequest getFileListRequest) {
        GetFileListResponse result = new GetFileListResponse();
        RemoteDirectoryType baseDir = new RemoteDirectoryType();
        Path base = ServletUtils.getRealPath(this.settings.getServletContext(), "/");
        baseDir.setName("");
        baseDir.setFullPath(base.toAbsolutePath().toString().substring(base.toAbsolutePath().toString().length()) + File.separator);
        baseDir.setFileSeparator(File.separator);
        baseDir.setBackupEnabled(true);
        try {
            this.buildSubDir(baseDir, base, base, "");
            Path defaultConfigHome = ServletUtils.getRealPath(this.settings.getServletContext(), "WEB-INF");
            Path configHomeF = (Path)this.settings.getServletContext().getAttribute("com.neptunelabs.fsiserver.config.home");
            if (!configHomeF.equals(defaultConfigHome)) {
                RemoteDirectoryType configHome = new RemoteDirectoryType();
                configHome.setName("configHome");
                configHome.setFullPath("configHome/");
                configHome.setFileSeparator(File.separator);
                configHome.setBackupEnabled(true);
                this.buildSubDir(configHome, configHomeF, configHomeF, "/configHome");
                baseDir.addSubdirectories(configHome);
            }
            result.setGetFileListResponse(baseDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private void buildSubDir(RemoteDirectoryType rdir, Path dir, Path usedBase, String prefix) throws IOException {
        List<PathCached> items = FileOperations.listAllFiles(dir);
        for (PathCached item : items) {
            String fullPath;
            if (item.isRegularFile()) {
                RemoteFileType rf = new RemoteFileType();
                rf.setName(item.getFileName());
                Calendar lastModified = Calendar.getInstance();
                lastModified.setTimeInMillis(item.lastModified());
                rf.setLastModified(lastModified);
                rf.setSize(item.size());
                rf.setFullPath(prefix + item.getAbsoluteName().substring(usedBase.toAbsolutePath().toString().length()));
                rdir.addFiles(rf);
                continue;
            }
            if (!item.isDirectory() || !this.settings.isViewableDir(fullPath = prefix + item.getAbsoluteName().substring(usedBase.toAbsolutePath().toString().length()) + File.separator)) continue;
            RemoteDirectoryType rd = new RemoteDirectoryType();
            rd.setName(item.getFileName());
            rd.setFileSeparator(File.separator);
            rd.setViewingEnabled(true);
            rd.setBackupEnabled(this.settings.isBackupDir(fullPath));
            rd.setFullPath(fullPath);
            rdir.addSubdirectories(rd);
            this.buildSubDir(rd, item.getPath(), usedBase, prefix);
        }
    }

    @Override
    public ReadFileContentsResponse readFileContents(ReadFileContentsRequest requestparams) {
        ReadFileContentsResponse result = new ReadFileContentsResponse();
        String pathToFile = requestparams.getReadFileContentsRequest();
        Path file = pathToFile.startsWith("/configHome") ? Paths.get(System.getProperty("com.neptunelabs.fsiserver.config.home"), pathToFile.substring(11)) : ServletUtils.getRealPath(this.settings.getServletContext(), pathToFile);
        if (Files.isReadable(file)) {
            result.setReadFileContentsResponse(new DataHandler((DataSource)new FileDataSource(file.toFile())));
        }
        return result;
    }
}

