/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.helpers.FormatBytes;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.fsiadministrator.ServletSettingsWrapper;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.fsiadministrator.actions.AddRendererAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.AddSourceConnectorAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.CopyRendererAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.CopySourceConnectorAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.DefaultAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.DeleteRendererAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.DeleteSourceConnectorAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.EditHeadersAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.EditRendererAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.EditSourceConnectorAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.LicenceAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.ListRenderersAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.ListSkinsAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.ListSourceConnectorsAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.MemoryCacheAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.NewAccountWizard;
import com.neptunelabs.fsiserver.fsiadministrator.actions.NewAdminAccountAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.NewServiceAccountAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.RequestProcessorSettingsAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.SearchDatabaseAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.SourceConnectorAccessAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.SourceManagerSettingsAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.SourceManagerStateAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.UpdateViewersAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.ViewerSettings;
import com.neptunelabs.fsiserver.fsiadministrator.actions.ZipViewerAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.groups.AddGroupAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.groups.CopyGroupAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.groups.DeleteGroupAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.groups.EditGroupAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.groups.ListGroupsAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets.AddPermissionSetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets.CopyPermissionSetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets.DeletePermissionSetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets.EditPermissionSetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets.ListPermissionSetsAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets.AddPropertySetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets.CopyPropertySetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets.DeletePropertySetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets.EditPropertySetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets.ListPropertySetsAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.publishingsets.AddPublishingSetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.publishingsets.CopyPublishingSetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.publishingsets.DeletePublishingSetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.publishingsets.EditPublishingSetAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.publishingsets.ListPublishingSetsAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.skins.DeleteSkinAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.skins.UploadSkinAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.users.ChangePasswordAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.users.DeleteUserAction;
import com.neptunelabs.fsiserver.fsiadministrator.actions.users.ListUsersAction;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.requestprocessor.MainProcessor;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiservletframework.ExtendedServlet;
import com.neptunelabs.fsiservletframework.UncaughtExceptionLogger;
import com.neptunelabs.fsiservletframework.freemarker.TemplateCache;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetSoftwareStatusResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.interfacewebservice.SoftwareStatusType;
import com.neptunelabs.fsiservletframework.security.ServletMerlin;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import com.neptunelabs.fsiservletframework.webinterface.Menu;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;

@WebServlet(name="AdminInterface", displayName="FSIServer Administrator Interface", loadOnStartup=6, initParams={@WebInitParam(name="autorestart", value="true")})
public class WSMain
extends GenericServlet
implements ExtendedServlet {
    private static final long serialVersionUID = 2690752289682006865L;
    private ServletContext servletContext;
    private Configuration cfg;
    private Path templatePath;
    private TemplateCache templateCache;
    private ServletFileEventCursor fileEventCursor = null;
    private FSILogger logger;
    private final Map<String, Action> actions = new HashMap<String, Action>();
    private UncaughtExceptionLogger uncaughtExceptionLogger;
    private ServletSettingsWrapper settings;
    private long currentUserListTimestamp = 0L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.uncaughtExceptionLogger = new UncaughtExceptionLogger(this);
        try {
            this.servletContext = config.getServletContext();
            String configHomeStr = System.getProperty("com.neptunelabs.fsiserver.config.home");
            Path configHome = configHomeStr == null ? ServletUtils.getRealPath(config.getServletContext(), "WEB-INF").resolve("config") : Paths.get(configHomeStr, new String[0]);
            config.getServletContext().setAttribute("com.neptunelabs.fsiserver.config.home", (Object)configHome);
            try {
                Path keystorePath = configHome.resolve("administrator.key");
                ServletMerlin.setKeystoreLocation(keystorePath);
            }
            catch (Exception e) {
                this.uncaughtExceptionLogger.uncaughtException(null, e);
            }
            this.logger = new FSILogger(configHome, "Administrator", "com/neptunelabs/fsiserver/resources/log4j_codes.properties", "log4j");
            this.logger.addCodes("com/neptunelabs/fsiframework/resources/log4j_codes.properties");
            this.logger.addCodes("com/neptunelabs/fsiservletframework/resources/log4j_codes.properties");
            this.logger.start();
            this.uncaughtExceptionLogger.setLogger(this.logger);
            Object fecObj = this.servletContext.getAttribute("fileEventCursor");
            if (fecObj != null) {
                this.fileEventCursor = (ServletFileEventCursor)fecObj;
            } else {
                this.fileEventCursor = new ServletFileEventCursor(this.logger);
                this.fileEventCursor.start();
            }
            try {
                this.initFreeMarker();
            }
            catch (IOException ioe) {
                this.logger.log(2022, ioe.getLocalizedMessage());
                this.destroy();
            }
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.fsiadministrator.WSMain", (Object)this);
            try {
                Logger.selectLoggerLibrary((int)0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.actions.put("default", new DefaultAction(this.servletContext));
            this.actions.put("sourcemanagerstate", new SourceManagerStateAction(this.servletContext));
            this.actions.put("newaccount", new NewAccountWizard(this.servletContext));
            this.actions.put("newserviceaccount", new NewServiceAccountAction(this.servletContext));
            this.actions.put("newadminaccount", new NewAdminAccountAction(this.servletContext));
            this.actions.put("requestprocessorsettings", new RequestProcessorSettingsAction(this.servletContext));
            this.actions.put("sourcemanagersettings", new SourceManagerSettingsAction(this.servletContext));
            this.actions.put("editheaders", new EditHeadersAction(this.servletContext));
            this.actions.put("listrenderer", new ListRenderersAction(this.servletContext));
            this.actions.put("addrenderer", new AddRendererAction(this.servletContext));
            this.actions.put("editrenderer", new EditRendererAction(this.servletContext));
            this.actions.put("copyrenderer", new CopyRendererAction(this.servletContext));
            this.actions.put("deleterenderer", new DeleteRendererAction(this.servletContext));
            this.actions.put("listsourceconnectors", new ListSourceConnectorsAction(this.servletContext));
            this.actions.put("copysourceconnector", new CopySourceConnectorAction(this.servletContext));
            this.actions.put("addsourceconnector", new AddSourceConnectorAction(this.servletContext));
            this.actions.put("editsourceconnector", new EditSourceConnectorAction(this.servletContext));
            this.actions.put("deletesourceconnector", new DeleteSourceConnectorAction(this.servletContext));
            this.actions.put("sourceconnectoraccess", new SourceConnectorAccessAction(this.servletContext));
            this.actions.put("viewersettings", new ViewerSettings(this.servletContext));
            this.actions.put("deleteskin", new DeleteSkinAction(this.servletContext));
            this.actions.put("uploadskin", new UploadSkinAction(this.servletContext));
            this.actions.put("listskins", new ListSkinsAction(this.servletContext));
            this.actions.put("zipviewerdir", new ZipViewerAction(this.servletContext));
            this.actions.put("updateviewers", new UpdateViewersAction(this.servletContext));
            this.actions.put("addpermissionset", new AddPermissionSetAction(this.servletContext));
            this.actions.put("copypermissionset", new CopyPermissionSetAction(this.servletContext));
            this.actions.put("listpermissionsets", new ListPermissionSetsAction(this.servletContext));
            this.actions.put("deletepermissionset", new DeletePermissionSetAction(this.servletContext));
            this.actions.put("editpermissionset", new EditPermissionSetAction(this.servletContext));
            this.actions.put("addpropertyset", new AddPropertySetAction(this.servletContext));
            this.actions.put("copypropertyset", new CopyPropertySetAction(this.servletContext));
            this.actions.put("listpropertysets", new ListPropertySetsAction(this.servletContext));
            this.actions.put("deletepropertyset", new DeletePropertySetAction(this.servletContext));
            this.actions.put("editpropertyset", new EditPropertySetAction(this.servletContext));
            this.actions.put("addpublishingset", new AddPublishingSetAction(this.servletContext));
            this.actions.put("listpublishingsets", new ListPublishingSetsAction(this.servletContext));
            this.actions.put("copypublishingsets", new CopyPublishingSetAction(this.servletContext));
            this.actions.put("deletepublishingset", new DeletePublishingSetAction(this.servletContext));
            this.actions.put("editpublishingset", new EditPublishingSetAction(this.servletContext));
            this.actions.put("listusers", new ListUsersAction(this.servletContext));
            this.actions.put("deleteuser", new DeleteUserAction(this.servletContext));
            this.actions.put("changepassword", new ChangePasswordAction(this.servletContext));
            this.actions.put("addgroup", new AddGroupAction(this.servletContext));
            this.actions.put("listgroups", new ListGroupsAction(this.servletContext));
            this.actions.put("copygroup", new CopyGroupAction(this.servletContext));
            this.actions.put("deletegroup", new DeleteGroupAction(this.servletContext));
            this.actions.put("editgroup", new EditGroupAction(this.servletContext));
            this.actions.put("memorycache", new MemoryCacheAction(this.servletContext));
            this.actions.put("searchdb", new SearchDatabaseAction(this.servletContext));
            this.actions.put("licence", new LicenceAction(this.servletContext));
            this.settings = new ServletSettingsWrapper(this, this.fileEventCursor);
            this.settings.setFSILogger(this.logger);
            this.start();
        }
        catch (Exception e) {
            this.uncaughtExceptionLogger.uncaughtException(null, e);
        }
    }

    @Override
    public void start() {
    }

    public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
    }

    @Override
    public void stop() {
        if (this.templateCache != null) {
            this.templateCache.dispose();
        }
        if (this.settings != null && !this.settings.isRestarting() && this.fileEventCursor != null) {
            this.fileEventCursor.halt();
        }
        if (this.logger != null) {
            this.logger.log(5003, new Object[0]);
            this.logger.shutdown();
        }
    }

    @Override
    public void destroy() {
        this.stop();
        this.cfg.clearEncodingMap();
        this.cfg.clearSharedVariables();
        this.cfg.clearTemplateCache();
        this.cfg = null;
    }

    public GetSoftwareStatusResponse getSoftwareStatus() {
        GetSoftwareStatusResponse result = new GetSoftwareStatusResponse();
        SoftwareStatusType status = new SoftwareStatusType();
        status.setInterfaceEnabled(true);
        status.setSoftwareVersion(SoftwareVersion.getVersion(true));
        status.setSystemKey("generic");
        Calendar cts = Calendar.getInstance();
        cts.setTimeInMillis(this.currentUserListTimestamp);
        status.setUserlistTimestamp(cts);
        status.setMaintenance(false);
        String requestprocessorstatus = null;
        boolean requestprocessorenabled = false;
        Object o1 = this.servletContext.getAttribute("com.neptunelabs.fsiserver.requestprocessor.MainProcessor");
        if (o1 != null && o1 instanceof MainProcessor) {
            MainProcessor requestprocessor = (MainProcessor)o1;
            requestprocessorenabled = requestprocessor.getRequestProcessorSettings().hasSectionEnabled("application");
            requestprocessorstatus = requestprocessor.getStatus();
            status.setError(requestprocessor.hasServletInitError());
            status.setWarn(requestprocessor.hasServletInitWarning());
            status.setErrorMessage(requestprocessor.getServletInitErrorMessage());
            status.setWarnMessage(requestprocessor.getServletInitWarningMessage());
            status.setUptime(requestprocessor.getUptime());
            status.setUpdatePending(Files.isDirectory(requestprocessor.getRequestProcessorSettings().getTemporaryUpdateDirectory(), new LinkOption[0]));
            SystemMonitor monitor = requestprocessor.getRequestProcessorSettings().getSystemMonitor();
            StringBuilder statsString = new StringBuilder();
            if (monitor != null) {
                statsString.append("TTFB: " + monitor.getAvgTTFB60() + "ms");
                statsString.append('\n');
                statsString.append("Bytes delivered: " + FormatBytes.byteToString(monitor.getAccumulator(SystemMonitor.Accumulators.RP_TRAFFIC_ALL), 3, 2));
                statsString.append('\n');
                statsString.append("Hits: " + monitor.getAccumulator(SystemMonitor.Accumulators.RP_HITS_ALL));
                String sstr = statsString.toString();
                status.setStatistics(sstr);
            } else {
                status.setStatistics("Not started");
            }
        } else {
            status.setError(false);
            status.setWarn(false);
        }
        String sourcemanagerstatus = null;
        boolean sourcemanagerenabled = false;
        Object o2 = this.servletContext.getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
        if (o2 != null && o2 instanceof MainManager) {
            MainManager sourcemanager = (MainManager)o2;
            sourcemanagerstatus = sourcemanager.getStatus();
            sourcemanagerenabled = sourcemanager.getSourceManagerSettings().hasSectionEnabled("application");
            status.setError(status.getError() || sourcemanager.hasErrors());
            status.setWarn(status.getWarn() || sourcemanager.hasWarnings());
            String servererror = status.getErrorMessage() != null ? status.getErrorMessage() : "";
            String sourcemanagererror = sourcemanager.getErrorMessage();
            String sep = servererror.length() > 0 && sourcemanagererror.length() > 0 ? "\n" : "";
            status.setErrorMessage(servererror + sep + sourcemanagererror);
            String serverwarn = status.getWarnMessage() != null ? status.getWarnMessage() : "";
            String sourcemanagerwarn = sourcemanager.getWarningMessage();
            sep = serverwarn.length() > 0 && sourcemanagerwarn.length() > 0 ? "\n" : "";
            status.setErrorMessage(serverwarn + sep + sourcemanagerwarn);
            status.setUptime(sourcemanager.getUptime());
            status.setUpdatePending(Files.isDirectory(sourcemanager.getSourceManagerSettings().getTemporaryUpdateDirectory(), new LinkOption[0]));
        }
        status.setStatusMessage(requestprocessorstatus != null ? requestprocessorstatus : sourcemanagerstatus);
        status.setApplicationEnabled(requestprocessorenabled || sourcemanagerenabled);
        result.setGetSoftwareStatusResponse(status);
        return result;
    }

    private void initFreeMarker() throws IOException {
        this.cfg = new Configuration();
        this.cfg.setNumberFormat("0.######");
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setEncoding(Locale.ENGLISH, "UTF-8");
        this.cfg.setOutputEncoding("UTF-8");
        this.cfg.setLocale(Locale.ENGLISH);
        this.cfg.setWhitespaceStripping(true);
        this.templatePath = ServletUtils.getRealPath(this.servletContext, "WEB-INF").resolve("internal/administrator").resolve("templates");
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.cfg.setDirectoryForTemplateLoading(this.templatePath.toFile());
        this.templateCache = new TemplateCache(this.logger, this.cfg, this.fileEventCursor);
        this.templateCache.registerTemplates(TemplateType.ADMINISTRATOR, this.templatePath, this.logger.hasNeLaDebug());
    }

    private int renderTemplate(String template, SimpleHash templateData, OutputStream out) {
        int status = 500;
        try {
            Template tpl = this.templateCache.getTemplate(TemplateType.ADMINISTRATOR, template);
            if (tpl != null) {
                OutputStreamWriter w = new OutputStreamWriter(out);
                tpl.process((Object)templateData, (Writer)w);
                status = 200;
            } else {
                status = 404;
            }
        }
        catch (TemplateException te) {
            this.logger.logException((Exception)((Object)te), 5006, te.getLocalizedMessage() + " " + te.getFTLInstructionStack());
        }
        catch (IOException ioe) {
            this.logger.logException(ioe, 5006, ioe.getLocalizedMessage());
        }
        return status;
    }

    public int getRenderedTemplate(String action, Map<String, Object> httpParameters, Map<String, String> sessionData, List<Map<String, Object>> relatedPages, Map<String, String> requiredParameters, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, ByteArrayOutputStream responseBodyOutputStream) {
        int status = 404;
        SimpleHash templateData = new SimpleHash();
        templateData.put("mysoftware", (Object)SoftwareVersion.getSoftware(false));
        templateData.put("mysoftwareid", (Object)SoftwareVersion.getSoftwareID());
        templateData.put("myversion", (Object)SoftwareVersion.getVersion(true));
        templateData.put("myupdate", (Object)"latest version");
        templateData.put("mystarttime", (Object)System.currentTimeMillis());
        Menu menu = new Menu();
        menu.initTopMenuCSS("topmenu", "topmenudis");
        menu.initMainMenuCSS("mm", "mmdis");
        for (Map.Entry<String, String> entry : sessionData.entrySet()) {
            templateData.put(entry.getKey(), (Object)entry.getValue());
        }
        templateData.put("relatedPages", relatedPages);
        templateData.put("requiredParams", requiredParameters);
        try {
            SimpleScalar authinttm = (SimpleScalar)templateData.get("authorization_int");
            if (authinttm != null) {
                templateData.put("authorization_int", (Object)Integer.parseInt(authinttm.getAsString()));
            }
        }
        catch (TemplateModelException e) {
            this.logger.log(5006, e.getLocalizedMessage());
        }
        String templatename = "";
        Action a = this.actions.get(action);
        if (a != null) {
            if (a instanceof ZipViewerAction) {
                ZipViewerAction da = (ZipViewerAction)a;
                status = da.perform(httpParameters, sessionData, responseHeaders, responseBodyOutputStream);
            } else {
                templatename = a.getTemplateName();
                status = a.perform(httpParameters, sessionData, files, responseHeaders, responseSessionData, templateData);
                boolean sourcemanagerenabled = false;
                Object o2 = this.servletContext.getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
                if (o2 != null && o2 instanceof MainManager) {
                    MainManager sourcemanager = (MainManager)o2;
                    sourcemanagerenabled = sourcemanager.getSourceManagerSettings().hasSectionEnabled("application");
                }
                menu.putTopMenuEntry(templatename, true, AuthorizationLevel.Anonymous, "My Software", "mysoftware.do");
                menu.putMainMenuEntry("common", true, AuthorizationLevel.AppAdmin, "Home", "pt.do?<@printRequiredParams method=\"get\" />action=default");
                menu.putMainMenuEntry("common", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "New Account", "pt.do?<@printRequiredParams method=\"get\" />action=newaccount");
                menu.putMainMenuEntry("common", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "FSI Viewer", "pt.do?<@printRequiredParams method=\"get\" />action=viewersettings");
                menu.putMainMenuEntry("common", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Skins", "pt.do?<@printRequiredParams method=\"get\" />action=listskins", 1);
                menu.putMainMenuEntry("common", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Update", "pt.do?<@printRequiredParams method=\"get\" />action=updateviewers", 1);
                menu.putMainMenuEntry("common", true, AuthorizationLevel.AppAdmin, "Licences", "pt.do?<@printRequiredParams method=\"get\" />action=licence");
                menu.putMainMenuEntry("common", true, AuthorizationLevel.AppAdmin, "Install Licence", "pt.do?<@printRequiredParams method=\"get\" />action=licence&licenceform=1", 1);
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, "Request Processor", "pt.do?<@printRequiredParams method=\"get\" />action=requestprocessorsettings");
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, " General Settings", "pt.do?<@printRequiredParams method=\"get\" />action=requestprocessorsettings&editsettings=1", 1);
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, " Search Database", "pt.do?<@printRequiredParams method=\"get\" />action=requestprocessorsettings&editsearch=1", 1);
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, " Color&nbsp;Management", "pt.do?<@printRequiredParams method=\"get\" />action=requestprocessorsettings&editcms=1", 1);
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, " Limits and Defaults", "pt.do?<@printRequiredParams method=\"get\" />action=requestprocessorsettings&editlimits=1", 1);
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, " Advanced", "pt.do?<@printRequiredParams method=\"get\" />action=requestprocessorsettings&editadvanced=1", 1);
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, " Headers", "pt.do?<@printRequiredParams method=\"get\" />action=editheaders", 1);
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, "Renderers", "pt.do?<@printRequiredParams method=\"get\" />action=listrenderer");
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, "Source Manager", "pt.do?<@printRequiredParams method=\"get\" />action=sourcemanagersettings");
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, " General Settings", "pt.do?<@printRequiredParams method=\"get\" />action=sourcemanagersettings&editsettings=1", 1);
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, " Scanner Settings", "pt.do?<@printRequiredParams method=\"get\" />action=sourcemanagersettings&editscanner=1", 1);
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, " Search Database", "pt.do?<@printRequiredParams method=\"get\" />action=sourcemanagersettings&editsearch=1", 1);
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, " Color Management", "pt.do?<@printRequiredParams method=\"get\" />action=sourcemanagersettings&editcms=1", 1);
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, " Protected Content", "pt.do?<@printRequiredParams method=\"get\" />action=sourcemanagersettings&editprotectedfiles=1", 1);
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, " Cache Settings", "pt.do?<@printRequiredParams method=\"get\" />action=sourcemanagersettings&editcachesettings=1", 1);
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Source Connectors", "pt.do?<@printRequiredParams method=\"get\" />action=listsourceconnectors");
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Search Database", "pt.do?<@printRequiredParams method=\"get\" />action=sourcemanagersettings&editsearch=1", 1);
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Users", "pt.do?<@printRequiredParams method=\"get\" />action=listusers");
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Groups", "pt.do?<@printRequiredParams method=\"get\" />action=listgroups");
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Permission Sets", "pt.do?<@printRequiredParams method=\"get\" />action=listpermissionsets");
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Property Sets", "pt.do?<@printRequiredParams method=\"get\" />action=listpropertysets");
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Publishing Sets", "pt.do?<@printRequiredParams method=\"get\" />action=listpublishingsets");
                menu.putMainMenuEntry("advanced", true, AuthorizationLevel.AppAdmin, "Memory Cache", "pt.do?<@printRequiredParams method=\"get\" />action=memorycache");
                menu.putMainMenuEntry("advanced", sourcemanagerenabled, AuthorizationLevel.AppAdmin, "Search Database", "pt.do?<@printRequiredParams method=\"get\" />action=searchdb");
                templateData.put("color", (Object)sessionData.get("color"));
                templateData.put("topmenu", (Object)menu.getTopMenu(templatename));
                templateData.put("mainmenu1head", (Object)"Common Tasks");
                templateData.put("mainmenu1", (Object)menu.getMainMenu("common"));
                templateData.put("mainmenu2head", (Object)"Advanced");
                templateData.put("mainmenu2", (Object)menu.getMainMenu("advanced"));
                if (status == 200) {
                    status = this.renderTemplate(templatename, templateData, responseBodyOutputStream);
                }
            }
        }
        return status;
    }
}

