/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.requestprocessor.MainProcessor;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.settings.Section;
import freemarker.template.SimpleHash;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public abstract class Action {
    protected final ServletContext servletContext;
    protected final MainManager sourceManager;
    protected final MainProcessor requestProcessor;
    protected final SourceManagerSettings sourceManagerSettings;
    protected final RequestProcessorSettings requestProcessorSettings;
    protected final FSILogger sourceManagerLogger;
    protected final FSILogger requestProcessorLogger;

    public Action(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.sourceManager = (MainManager)servletContext.getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
        if (this.sourceManager != null) {
            this.sourceManagerSettings = this.sourceManager.getSourceManagerSettings();
            this.sourceManagerLogger = this.sourceManagerSettings.getFSILogger();
        } else {
            this.sourceManagerSettings = null;
            this.sourceManagerLogger = null;
        }
        this.requestProcessor = (MainProcessor)servletContext.getAttribute("com.neptunelabs.fsiserver.requestprocessor.MainProcessor");
        if (this.requestProcessor != null) {
            this.requestProcessorSettings = this.requestProcessor.getRequestProcessorSettings();
            this.requestProcessorLogger = this.requestProcessorSettings.getFSILogger();
        } else {
            this.requestProcessorSettings = null;
            this.requestProcessorLogger = null;
        }
    }

    protected UserAuthenticationInterface getUserAuthenticationInterface() {
        return this.sourceManagerSettings.getUserAuthenticationInterface();
    }

    public abstract String getTemplateName();

    public abstract int perform(Map<String, Object> var1, Map<String, String> var2, ListOfFiles var3, Map<String, String> var4, Map<String, String> var5, SimpleHash var6);

    final void putListValuesToTemplate(SimpleHash templateData, String sectionName, String key) {
        List<String> valueList = this.sourceManagerSettings.getPrefsValues(sectionName, key);
        String valueListStr = "";
        StringBuilder valueListBuilder = new StringBuilder("");
        if (valueList != null) {
            for (String value : valueList) {
                valueListBuilder.append(value);
                valueListBuilder.append(",");
            }
            valueListStr = valueListBuilder.toString();
            if (valueListStr.length() > 0) {
                valueListStr = valueListStr.substring(0, valueListStr.length() - 1);
            }
        }
        templateData.put(sectionName, (Object)valueListStr);
    }

    final void putListValuesToSettings(FSIServerSettings settings, Map<String, Object> parameters, String sectionName, String key) {
        String[] values;
        List<String> list = settings.getPrefsValues(sectionName, key);
        if (list != null) {
            for (String s : list.toArray(new String[0])) {
                settings.removePrefs(sectionName, Section.SectionTypes.valueList, key, s);
            }
        }
        String valueListStr = ((String)parameters.get(sectionName)).trim();
        for (String value : values = valueListStr.split(",")) {
            if ((value = value.trim()).length() <= 0) continue;
            settings.setPrefs(sectionName, Section.SectionTypes.valueList, key, value, true);
        }
    }
}

