/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.fsiadministrator.actions.FormHelpers;
import com.neptunelabs.fsiserver.fsiadministrator.actions.RendererAction;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputFormat;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.nio.file.Path;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class AddRendererAction
extends RendererAction {
    public AddRendererAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/addrenderer.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            templateData.put("available_formats", FormHelpers.getAvailableOutputFormats());
            templateData.put("default_format", (Object)OutputFormat.JPEG);
            if (parameters.get("renderername") != null) {
                String renderername = (String)parameters.get("renderername");
                for (Map.Entry<String, Object> e : parameters.entrySet()) {
                    templateData.put(e.getKey(), e.getValue());
                }
                try {
                    Document doc = FormHelpers.buildRendererDocument(parameters);
                    Path rendererFile = this.requestProcessorSettings.getRendererDirectory().resolve(renderername + ".xml");
                    FileOperations.saveXMLFileContent(this.sourceManagerLogger, rendererFile, doc);
                    templateData.put("show_confirmation", true);
                }
                catch (ParserConfigurationException e) {
                    templateData.put("message", (Object)"Error saving renderer.");
                    templateData.put("show_form", true);
                }
                catch (NumberFormatException e) {
                    templateData.put("message", (Object)"Invalid quality value.");
                    templateData.put("show_form", true);
                    status = 200;
                }
                status = 200;
            } else {
                templateData.put("enabled", (Object)"true");
                OutputParameters defaultOutputParams = new OutputParameters();
                this.outputParametersToTemplate(defaultOutputParams, templateData);
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

