/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.helpers.URLDecoderFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.fsiadministrator.actions.FormHelpers;
import com.neptunelabs.fsiserver.utils.SourceConnector;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXB;
import javax.xml.parsers.ParserConfigurationException;

public final class AddSourceConnectorAction
extends Action {
    public AddSourceConnectorAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/addsourceconnector.ftl";
    }

    @Override
    public final int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        block35: {
            if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
                return 403;
            }
            templateData.put("available_formats", FormHelpers.getAvailableFormats());
            templateData.put("available_groups", this.getAvailableGroups());
            templateData.put("available_types", FormHelpers.getAvailableSourceConnectorTypes());
            templateData.put("default_group", (Object)"users");
            templateData.put("available_permissionsets", this.getAvailablePermissionSets());
            templateData.put("default_permissionset", (Object)"rw");
            if (parameters.get("connectorname") == null) {
                if (!parameters.containsKey("enabled")) {
                    templateData.put("enabled", (Object)"true");
                    templateData.put("format", (Object)"JPEG");
                    templateData.put("type", (Object)"storage");
                    templateData.put("quality", (Object)94);
                    templateData.put("download", (Object)"true");
                    templateData.put("mkdir", (Object)"false");
                }
                templateData.put("show_form", true);
                return 200;
            }
            for (Map.Entry<String, Object> e : parameters.entrySet()) {
                templateData.put(e.getKey(), e.getValue());
            }
            String connectorname = ((String)parameters.get("connectorname")).trim();
            if ((connectorname = URLDecoderFast.decode(connectorname, FileOperations.charsetUTF8)).length() == 0) {
                templateData.put("message", (Object)"Invalid source connector name.");
                templateData.put("show_form", true);
                return 200;
            }
            if (this.sourceManagerSettings.getSourceConnector(connectorname) != null) {
                templateData.put("message", (Object)"A source connector of this name already exists.");
                templateData.put("show_form", true);
                return 200;
            }
            String location = ((String)parameters.get("location")).trim();
            if (location.length() == 0) {
                templateData.put("message", (Object)"Invalid location.");
                templateData.put("show_form", true);
                return 200;
            }
            try {
                boolean pass;
                boolean mkdir = Boolean.valueOf((String)parameters.get("mkdir"));
                if (mkdir) {
                    String locationStr = (String)parameters.get("location");
                    if (locationStr != null) {
                        Path locationPath = Paths.get(locationStr, new String[0]);
                        if (!Files.exists(locationPath, new LinkOption[0])) {
                            try {
                                Files.createDirectories(locationPath, new FileAttribute[0]);
                                pass = true;
                            }
                            catch (IOException ioe) {
                                templateData.put("message", (Object)"Unable to create location directory.");
                                templateData.put("show_form", true);
                                pass = false;
                            }
                        } else {
                            pass = true;
                        }
                    } else {
                        templateData.put("message", (Object)"Invalid location.");
                        templateData.put("show_form", true);
                        pass = false;
                    }
                } else {
                    pass = true;
                }
                if (!pass) break block35;
                SourceConnector rawsc = FormHelpers.buildRawSourceConnector(parameters);
                Path connectorFile = this.sourceManagerSettings.getSourceConnectorPath().resolve(connectorname + ".xml");
                boolean fileOkay = false;
                if (Files.notExists(connectorFile, new LinkOption[0])) {
                    try {
                        Files.createFile(connectorFile, new FileAttribute[0]);
                        fileOkay = true;
                    }
                    catch (IOException e) {
                        fileOkay = false;
                        templateData.put("message", (Object)"Error saving source connector to file.");
                        templateData.put("show_form", true);
                    }
                } else {
                    fileOkay = true;
                }
                if (!fileOkay) break block35;
                try (OutputStream fos = Files.newOutputStream(connectorFile, new OpenOption[0]);){
                    JAXB.marshal((Object)rawsc, (OutputStream)fos);
                }
                templateData.put("show_confirmation", true);
            }
            catch (ParserConfigurationException e) {
                templateData.put("message", (Object)"Error saving source connector.");
                templateData.put("show_form", true);
            }
            catch (NumberFormatException e) {
                templateData.put("message", (Object)"Invalid quality value.");
                templateData.put("show_form", true);
            }
            catch (IOException ioe) {
                templateData.put("message", (Object)("Error saving source connector: " + ioe.getLocalizedMessage()));
                templateData.put("show_form", true);
            }
        }
        return 200;
    }

    private List<Map<String, Object>> getAvailablePermissionSets() {
        UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
        ArrayList<String> permissionSets = new ArrayList<String>(uai.getPermissionSets().keySet());
        Collections.sort(permissionSets);
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        for (String permissionSet : permissionSets) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", permissionSet);
            entry.put("description", permissionSet);
            availables.add(entry);
        }
        return availables;
    }

    private List<Map<String, Object>> getAvailableGroups() {
        UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
        ArrayList<String> groupNames = new ArrayList<String>(uai.getGroups().keySet());
        Collections.sort(groupNames);
        groupNames.remove("public");
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        for (String groupName : groupNames) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", groupName);
            entry.put("description", groupName);
            availables.add(entry);
        }
        return availables;
    }
}

