/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.servlet.ServletContext;

public class CopyRendererAction
extends Action {
    public CopyRendererAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/copyrenderer.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("renderername") != null) {
            String originRenderer = (String)parameters.get("renderername");
            if (parameters.get("target") != null && ((String)parameters.get("target")).trim().length() > 0) {
                String destinationRendererName = (String)parameters.get("target");
                Path destinationfile = this.requestProcessorSettings.getRendererDirectory().resolve(destinationRendererName + ".xml");
                if (Files.exists(destinationfile, new LinkOption[0]) && (parameters.get("overwrite") == null || !parameters.get("overwrite").equals("1"))) {
                    templateData.put("renderername", (Object)originRenderer);
                    templateData.put("target", (Object)destinationRendererName);
                    templateData.put("show_overwrite_request", true);
                } else {
                    Path sourcefile = this.requestProcessorSettings.getRendererDirectory().resolve(originRenderer + ".xml");
                    boolean copied = FileOperations.copy(this.sourceManagerLogger, sourcefile, destinationfile);
                    if (copied) {
                        templateData.put("show_confirmation", true);
                    } else {
                        templateData.put("show_error", true);
                    }
                }
            } else {
                templateData.put("renderername", parameters.get("renderername"));
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

