/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CopySourceConnectorAction
extends Action {
    public CopySourceConnectorAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/copysourceconnector.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("connectorname") != null) {
            String originconnector = (String)parameters.get("connectorname");
            if (parameters.get("target") != null && ((String)parameters.get("target")).trim().length() > 0) {
                String destinationconnector = (String)parameters.get("target");
                Path destinationfile = this.sourceManagerSettings.getSourceConnectorPath().resolve(destinationconnector + ".xml");
                if (Files.exists(destinationfile, new LinkOption[0]) && (parameters.get("overwrite") == null || !parameters.get("overwrite").equals("1"))) {
                    templateData.put("connectorname", (Object)originconnector);
                    templateData.put("target", (Object)destinationconnector);
                    templateData.put("show_overwrite_request", true);
                } else {
                    boolean copied;
                    NodeList nl1;
                    Path sourcefile = this.sourceManagerSettings.getSourceConnectorPath().resolve(originconnector + ".xml");
                    boolean nodefound = false;
                    Document doc = FileOperations.getXMLFileContent(this.sourceManagerLogger, sourcefile);
                    NodeList nl = doc.getElementsByTagName("enabled");
                    if (nl.getLength() > 0) {
                        nl.item(0).setTextContent("false");
                        nodefound = true;
                    }
                    if (!nodefound && (nl1 = doc.getElementsByTagName("Enabled")).getLength() > 0) {
                        nl1.item(0).setTextContent("false");
                        nodefound = true;
                    }
                    if (!nodefound) {
                        NodeList nl2 = doc.getChildNodes();
                        Node rootNode = nl2.item(0);
                        Element enabledNode = doc.createElement("enabled");
                        enabledNode.setTextContent("false");
                        rootNode.appendChild(enabledNode);
                    }
                    if (copied = FileOperations.saveXMLFileContent(this.sourceManagerLogger, destinationfile, doc)) {
                        templateData.put("show_confirmation", true);
                    } else {
                        templateData.put("show_error", true);
                    }
                }
            } else {
                templateData.put("connectorname", parameters.get("connectorname"));
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

