/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.licensing.Licence;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.small.ConverterState;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import freemarker.template.SimpleHash;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public final class DefaultAction
extends Action {
    private final SimpleDateFormat sdf = new SimpleDateFormat();

    public DefaultAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/default.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        try {
            SystemMonitor monitor = this.requestProcessor.getRequestProcessorSettings().getSystemMonitor();
            templateData.put("uptime", (Object)(monitor != null ? monitor.getUptimeSec() : 0L));
            templateData.put("queued", (Object)this.sourceManager.getQueuedImages());
            templateData.put("scancount", (Object)this.sourceManager.getScanCount());
            templateData.put("freespace", (Object)(monitor != null ? monitor.getFreeStorageSpace() : 0L));
            templateData.put("usedspace", (Object)(monitor != null ? monitor.getUsedStorageSpace() : 0L));
            templateData.put("cpuload", (Object)Float.valueOf(monitor != null ? (float)monitor.getCPULoad() / 100.0f : 0.0f));
            Licence licence = this.requestProcessor.getRequestProcessorSettings().getLicence();
            templateData.put("licenced", licence.hasLicence());
            templateData.put("pid", (Object)licence.getPID());
            templateData.put("licence_edition", (Object)licence.getEdition());
            templateData.put("licensee", (Object)licence.getLicensee());
            templateData.put("licence_date", (Object)this.sdf.format(new Date(licence.getRegisterTime())));
            templateData.put("licence_state", (Object)this.requestProcessor.getRequestProcessorSettings().isLicensed());
            templateData.put("min_version", (Object)licence.getMinVersion());
            templateData.put("max_version", (Object)licence.getMaxVersion());
            templateData.put("expireResttime", (Object)(monitor != null ? monitor.getExpireRestTime() / 1000L : 0L));
            templateData.put("images", (Object)(monitor != null ? monitor.getAssetCount() : 0L));
            templateData.put("maximages", (Object)licence.getMaxImages());
            templateData.put("groups", (Object)this.requestProcessor.getRequestProcessorSettings().getUserAuthenticationInterface().getGroupCount());
            templateData.put("maxgroups", (Object)licence.getMaxUserGroups());
            templateData.put("connectors", (Object)this.requestProcessor.getRequestProcessorSettings().getSourceConnectorCount());
            templateData.put("maxconnectors", (Object)licence.getMaxConnectors());
            templateData.put("licence_nfr", licence.getFlagNFR());
            templateData.put("licence_non_profit", licence.getFlagNonProfit());
            templateData.put("groups", (Object)this.requestProcessor.getRequestProcessorSettings().getUserAuthenticationInterface().getGroupCount());
            templateData.put("jmx", licence.isJMXEnabled());
            templateData.put("batch_processing", licence.isBatchProcessingEnabled());
            templateData.put("version", (Object)SoftwareVersion.getVersion(false));
            templateData.put("showimporterdetailslink", true);
            if (this.sourceManager.getStatus().equals("disabled")) {
                templateData.put("sourcemanager_state", (Object)"disabled");
            } else {
                templateData.put("sourcemanager_state", (Object)this.determineSourceManagerState(this.sourceManager));
            }
            templateData.put("recently_imported", (Object)this.sourceManager.getRecentConverterJobs().size());
        }
        catch (NotConfiguredException e) {
            return 503;
        }
        return 200;
    }

    private String determineSourceManagerState(MainManager importer) {
        if (importer.getScannerDaemon() != null) {
            ScannerDaemon.STATE scannerstate = importer.getScannerDaemon().getScannerState();
            List<ConverterState> importerJobs = importer.getCurrentConverterJobs();
            int numberOfCurrentJobs = importerJobs.size();
            if (scannerstate == ScannerDaemon.STATE.SCANNING) {
                if (numberOfCurrentJobs > 0) {
                    return "scanning & importing";
                }
                return "scanning";
            }
            if (numberOfCurrentJobs > 0) {
                return "importing";
            }
            return "idle";
        }
        return "stopped";
    }
}

