/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.servlet.ServletContext;

public class DeleteRendererAction
extends Action {
    public DeleteRendererAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/deleterenderer.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("renderername") != null) {
            String renderername = (String)parameters.get("renderername");
            if (parameters.get("confirmed") != null && parameters.get("confirmed").equals("1")) {
                Renderer p = this.requestProcessorSettings.getRenderer(renderername);
                if (p != null) {
                    Path rendererFile = this.requestProcessorSettings.getRendererDirectory().resolve(renderername + ".xml");
                    if (Files.exists(rendererFile, new LinkOption[0])) {
                        try {
                            Files.delete(rendererFile);
                            templateData.put("show_confirmation", true);
                        }
                        catch (IOException e) {
                            templateData.put("show_error", true);
                        }
                    } else {
                        templateData.put("show_confirmation", true);
                    }
                }
            } else {
                templateData.put("renderername", parameters.get("renderername"));
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

