/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import javax.servlet.ServletContext;

public class DeleteSourceConnectorAction
extends Action {
    public DeleteSourceConnectorAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/deletesourceconnector.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("connectorname") != null) {
            String connectorname = (String)parameters.get("connectorname");
            if (parameters.get("confirmed") != null && parameters.get("confirmed").equals("1")) {
                SourceConnectorReader p = this.sourceManagerSettings.getSourceConnector(connectorname);
                if (p == null) {
                    templateData.put("show_confirmation", true);
                } else {
                    boolean success;
                    Path connectorFilePath = this.sourceManagerSettings.getSourceConnectorPath().resolve(connectorname + ".xml");
                    try {
                        success = Files.deleteIfExists(connectorFilePath);
                    }
                    catch (IOException e) {
                        success = false;
                    }
                    catch (SecurityException e) {
                        success = false;
                    }
                    if (success) {
                        templateData.put("show_confirmation", true);
                    } else {
                        templateData.put("show_error", true);
                    }
                }
            } else {
                templateData.put("connectorname", parameters.get("connectorname"));
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

