/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.utils.Headers;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXB;
import org.w3c.dom.Document;

public class EditHeadersAction
extends Action {
    public EditHeadersAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/editheaders.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            try {
                Path headersFilePath = this.requestProcessorSettings.getConfigHome().resolve("headers.xml");
                if (parameters.containsKey("deleteconstant")) {
                    String constant = (String)parameters.get("constant");
                    if (parameters.containsKey("confirmed")) {
                        Headers headers = this.readFromFile(headersFilePath);
                        Headers.NameValuePair toDelete = null;
                        for (Headers.NameValuePair nvp : headers.declarations.constants) {
                            if (!nvp.name.equals(constant)) continue;
                            toDelete = nvp;
                            break;
                        }
                        headers.declarations.constants.remove(toDelete);
                        this.saveToFile(headersFilePath, headers);
                        this.showSummary(headers, "Constant declaration deleted.", templateData);
                    } else {
                        templateData.put("delete_constant", true);
                        templateData.put("constant", (Object)constant);
                    }
                } else if (parameters.containsKey("deleteset")) {
                    String setname = (String)parameters.get("setname");
                    if (parameters.containsKey("confirmed")) {
                        Headers headers = this.readFromFile(headersFilePath);
                        this.removeSetFromHeaders(headers, setname);
                        this.saveToFile(headersFilePath, headers);
                        this.showSummary(headers, "Header set deleted", templateData);
                    } else {
                        templateData.put("delete_set", true);
                        templateData.put("setname", (Object)setname);
                    }
                } else if (parameters.containsKey("addset")) {
                    if (parameters.containsKey("setname")) {
                        String setname = (String)parameters.get("setname");
                        Headers headers = this.readFromFile(headersFilePath);
                        this.addSetToHeaders(headers, setname, parameters);
                        this.saveToFile(headersFilePath, headers);
                        this.showSummary(headers, "Set saved", templateData);
                    } else {
                        templateData.put("addset", true);
                        templateData.put("show_edit_set_form", true);
                    }
                } else if (parameters.containsKey("editset")) {
                    String setname = (String)parameters.get("setname");
                    if (parameters.containsKey("save")) {
                        Headers headers = this.readFromFile(headersFilePath);
                        this.removeSetFromHeaders(headers, setname);
                        this.addSetToHeaders(headers, setname, parameters);
                        this.saveToFile(headersFilePath, headers);
                        this.showSummary(headers, "Changes to Set saved", templateData);
                    } else {
                        Headers headers = this.readFromFile(headersFilePath);
                        Headers.HeaderSet foundSet = null;
                        for (Headers.HeaderSet set : headers.sets) {
                            if (!set.name.equals(setname)) continue;
                            foundSet = set;
                            break;
                        }
                        if (foundSet != null) {
                            SimpleHash h = new SimpleHash();
                            for (Headers.NameValuePair pair : foundSet.headers) {
                                h.put(pair.name, (Object)pair.value);
                            }
                            templateData.put("defined_headers", (Object)h);
                        }
                        templateData.put("setname", (Object)setname);
                        templateData.put("editset", true);
                        templateData.put("show_edit_set_form", true);
                    }
                } else if (parameters.containsKey("addconstant")) {
                    if (parameters.containsKey("name") && parameters.containsKey("value")) {
                        Headers headers = this.readFromFile(headersFilePath);
                        String name = (String)parameters.get("name");
                        String value = (String)parameters.get("value");
                        Headers.NameValuePair pair = new Headers.NameValuePair(name, value);
                        headers.declarations.constants.add(pair);
                        this.saveToFile(headersFilePath, headers);
                        this.showSummary(headers, "Constant declaration saved", templateData);
                    } else {
                        templateData.put("show_add_constant_form", true);
                    }
                } else {
                    Headers headers = this.readFromFile(headersFilePath);
                    this.showSummary(headers, null, templateData);
                }
                status = 200;
            }
            catch (IOException e) {
                status = 500;
            }
        }
        return status;
    }

    private void removeSetFromHeaders(Headers headers, String setname) {
        Headers.HeaderSet toDelete = null;
        for (Headers.HeaderSet set : headers.sets) {
            if (!set.name.equals(setname)) continue;
            toDelete = set;
            break;
        }
        headers.sets.remove(toDelete);
    }

    private void addSetToHeaders(Headers headers, String setname, Map<String, Object> parameters) {
        Headers.HeaderSet newSet = new Headers.HeaderSet();
        newSet.name = setname;
        if (parameters.get("headernames") instanceof String) {
            Headers.NameValuePair pair = new Headers.NameValuePair((String)parameters.get("headernames"), (String)parameters.get("headervalues"));
            newSet.headers.add(pair);
        } else {
            String[] names = (String[])parameters.get("headernames");
            String[] values = (String[])parameters.get("headervalues");
            for (int i = 0; i < names.length; ++i) {
                Headers.NameValuePair pair = new Headers.NameValuePair(names[i], values[i]);
                newSet.headers.add(pair);
            }
        }
        headers.sets.add(newSet);
    }

    private void showSummary(Headers headers, String message, SimpleHash templateData) {
        SimpleHash constants = new SimpleHash();
        for (Headers.NameValuePair pair : headers.declarations.constants) {
            constants.put(pair.name, (Object)pair.value);
        }
        SimpleHash headersets = new SimpleHash();
        for (Headers.HeaderSet set : headers.sets) {
            SimpleHash setHeaders = new SimpleHash();
            for (Headers.NameValuePair pair : set.headers) {
                setHeaders.put(pair.name, (Object)pair.value);
            }
            headersets.put(set.name, (Object)setHeaders);
        }
        templateData.put("show_summary", true);
        if (message != null) {
            templateData.put("message", (Object)message);
        }
        templateData.put("constants", (Object)constants);
        templateData.put("headersets", (Object)headersets);
    }

    private Headers readFromFile(Path path) throws IOException {
        Document doc = FileOperations.getXMLFileContent(this.sourceManagerLogger, path);
        String xml = XMLOperations.elementNamesToLowerCase(this.sourceManagerLogger, doc);
        Headers rawHeaders = XMLOperations.unmarshalJAXB(xml, Headers.class);
        return rawHeaders;
    }

    private void saveToFile(Path targetFilePath, Headers headers) {
        JAXB.marshal((Object)headers, (File)targetFilePath.toFile());
    }
}

